/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import com.sun.tracing.Provider;
import com.sun.tracing.ProviderFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import sun.tracing.dtrace.Activation;
import sun.tracing.dtrace.DTraceProvider;
import sun.tracing.dtrace.JVM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTraceProviderFactory
extends ProviderFactory {
    @Override
    public <T extends Provider> T createProvider(Class<T> clazz) {
        DTraceProvider dTraceProvider = new DTraceProvider(clazz);
        Object t = dTraceProvider.newProxyInstance();
        dTraceProvider.setProxy(t);
        try {
            dTraceProvider.init();
            new Activation(dTraceProvider.getModuleName(), new DTraceProvider[]{dTraceProvider});
        }
        catch (Exception exception) {
            Logger.getAnonymousLogger().warning("Could not initialize tracing provider: " + exception.getMessage());
            dTraceProvider.dispose();
        }
        return t;
    }

    public Map<Class<? extends Provider>, Provider> createProviders(Set<Class<? extends Provider>> set, String string) {
        HashMap<Class<? extends Provider>, Provider> hashMap = new HashMap<Class<? extends Provider>, Provider>();
        HashSet<DTraceProvider> hashSet = new HashSet<DTraceProvider>();
        for (Class<? extends Provider> clazz : set) {
            DTraceProvider dTraceProvider = new DTraceProvider(clazz);
            hashSet.add(dTraceProvider);
            hashMap.put(clazz, (Provider)dTraceProvider.newProxyInstance());
        }
        new Activation(string, hashSet.toArray(new DTraceProvider[0]));
        return hashMap;
    }

    public static boolean isSupported() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                RuntimePermission runtimePermission = new RuntimePermission("com.sun.tracing.dtrace.createProvider");
                securityManager.checkPermission(runtimePermission);
            }
            return JVM.isSupported();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

