/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.presentation.rmi;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.graph.Graph;
import com.sun.corba.se.impl.orbutil.graph.GraphImpl;
import com.sun.corba.se.impl.orbutil.graph.Node;
import com.sun.corba.se.impl.presentation.rmi.DynamicMethodMarshallerImpl;
import com.sun.corba.se.impl.presentation.rmi.IDLNameTranslatorImpl;
import com.sun.corba.se.impl.presentation.rmi.InvocationHandlerFactoryImpl;
import com.sun.corba.se.spi.orbutil.proxy.InvocationHandlerFactory;
import com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
import com.sun.corba.se.spi.presentation.rmi.IDLNameTranslator;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.rmi.CORBA.Tie;

public final class PresentationManagerImpl
implements PresentationManager {
    private Map classToClassData;
    private Map methodToDMM;
    private PresentationManager.StubFactoryFactory staticStubFactoryFactory;
    private PresentationManager.StubFactoryFactory dynamicStubFactoryFactory;
    private ORBUtilSystemException wrapper = null;
    private boolean useDynamicStubs;

    public PresentationManagerImpl(boolean bl) {
        this.useDynamicStubs = bl;
        this.wrapper = ORBUtilSystemException.get("rpc.presentation");
        this.classToClassData = new HashMap();
        this.methodToDMM = new HashMap();
    }

    public synchronized DynamicMethodMarshaller getDynamicMethodMarshaller(Method method) {
        if (method == null) {
            return null;
        }
        DynamicMethodMarshaller dynamicMethodMarshaller = (DynamicMethodMarshaller)this.methodToDMM.get(method);
        if (dynamicMethodMarshaller == null) {
            dynamicMethodMarshaller = new DynamicMethodMarshallerImpl(method);
            this.methodToDMM.put(method, dynamicMethodMarshaller);
        }
        return dynamicMethodMarshaller;
    }

    public synchronized PresentationManager.ClassData getClassData(Class clazz) {
        PresentationManager.ClassData classData = (PresentationManager.ClassData)this.classToClassData.get(clazz);
        if (classData == null) {
            classData = new ClassDataImpl(clazz);
            this.classToClassData.put(clazz, classData);
        }
        return classData;
    }

    public PresentationManager.StubFactoryFactory getStubFactoryFactory(boolean bl) {
        if (bl) {
            return this.dynamicStubFactoryFactory;
        }
        return this.staticStubFactoryFactory;
    }

    public void setStubFactoryFactory(boolean bl, PresentationManager.StubFactoryFactory stubFactoryFactory) {
        if (bl) {
            this.dynamicStubFactoryFactory = stubFactoryFactory;
        } else {
            this.staticStubFactoryFactory = stubFactoryFactory;
        }
    }

    public Tie getTie() {
        return this.dynamicStubFactoryFactory.getTie(null);
    }

    public boolean useDynamicStubs() {
        return this.useDynamicStubs;
    }

    private Set getRootSet(Class clazz, NodeImpl nodeImpl, Graph graph) {
        Set set = null;
        if (clazz.isInterface()) {
            graph.add(nodeImpl);
            set = graph.getRoots();
        } else {
            HashSet<NodeImpl> hashSet = new HashSet<NodeImpl>();
            for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
                NodeImpl nodeImpl2 = new NodeImpl(clazz2);
                graph.add(nodeImpl2);
                hashSet.add(nodeImpl2);
            }
            graph.getRoots();
            graph.removeAll(hashSet);
            set = graph.getRoots();
        }
        return set;
    }

    private Class[] getInterfaces(Set set) {
        Class[] classArray = new Class[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            NodeImpl nodeImpl = (NodeImpl)iterator.next();
            classArray[n++] = nodeImpl.getInterface();
        }
        return classArray;
    }

    private String[] makeTypeIds(NodeImpl nodeImpl, Graph graph, Set set) {
        HashSet hashSet = new HashSet(graph);
        hashSet.removeAll(set);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (set.size() > 1) {
            arrayList.add(nodeImpl.getTypeId());
        }
        this.addNodes(arrayList, set);
        this.addNodes(arrayList, hashSet);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addNodes(List list, Set set) {
        for (NodeImpl nodeImpl : set) {
            String string = nodeImpl.getTypeId();
            list.add(string);
        }
    }

    private static class NodeImpl
    implements Node {
        private Class interf;

        public Class getInterface() {
            return this.interf;
        }

        public NodeImpl(Class clazz) {
            this.interf = clazz;
        }

        public String getTypeId() {
            return "RMI:" + this.interf.getName() + ":0000000000000000";
        }

        public Set getChildren() {
            HashSet<NodeImpl> hashSet = new HashSet<NodeImpl>();
            Class<?>[] classArray = this.interf.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                if (!Remote.class.isAssignableFrom(clazz) || Remote.class.equals(clazz)) continue;
                hashSet.add(new NodeImpl(clazz));
            }
            return hashSet;
        }

        public String toString() {
            return "NodeImpl[" + this.interf + "]";
        }

        public int hashCode() {
            return this.interf.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NodeImpl)) {
                return false;
            }
            NodeImpl nodeImpl = (NodeImpl)object;
            return nodeImpl.interf.equals(this.interf);
        }
    }

    private class ClassDataImpl
    implements PresentationManager.ClassData {
        private Class cls;
        private IDLNameTranslator nameTranslator;
        private String[] typeIds;
        private PresentationManager.StubFactory sfactory;
        private InvocationHandlerFactory ihfactory;
        private Map dictionary;

        public ClassDataImpl(Class clazz) {
            this.cls = clazz;
            GraphImpl graphImpl = new GraphImpl();
            NodeImpl nodeImpl = new NodeImpl(clazz);
            Set set = PresentationManagerImpl.this.getRootSet(clazz, nodeImpl, graphImpl);
            Class[] classArray = PresentationManagerImpl.this.getInterfaces(set);
            this.nameTranslator = IDLNameTranslatorImpl.get(classArray);
            this.typeIds = PresentationManagerImpl.this.makeTypeIds(nodeImpl, graphImpl, set);
            this.ihfactory = new InvocationHandlerFactoryImpl(PresentationManagerImpl.this, this);
            this.dictionary = new HashMap();
        }

        public Class getMyClass() {
            return this.cls;
        }

        public IDLNameTranslator getIDLNameTranslator() {
            return this.nameTranslator;
        }

        public String[] getTypeIds() {
            return this.typeIds;
        }

        public InvocationHandlerFactory getInvocationHandlerFactory() {
            return this.ihfactory;
        }

        public Map getDictionary() {
            return this.dictionary;
        }
    }
}

