/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.OSInfo;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;
import sun.swing.WindowsPlacesBar;

public class WindowsFileChooserUI
extends BasicFileChooserUI {
    private static final OSInfo.WindowsVersion OS_VERSION = OSInfo.getWindowsVersion();
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private FilePane filePane;
    private WindowsPlacesBar placesBar;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut4 = new Dimension(1, 4);
    private static final Dimension vstrut6 = new Dimension(1, 6);
    private static final Dimension vstrut8 = new Dimension(1, 8);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 425;
    private static int PREF_HEIGHT = 245;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 425;
    private static int MIN_HEIGHT = 245;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 444;
    private static int LIST_PREF_HEIGHT = 138;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int folderNameLabelMnemonic = 0;
    private String folderNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String viewMenuButtonToolTipText = null;
    private String viewMenuButtonAccessibleName = null;
    private BasicFileChooserUI.BasicFileView fileView = new WindowsFileView();
    private JLabel fileNameLabel;
    static final int space = 10;

    private void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == 1) {
            this.fileNameLabel.setText(this.folderNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.folderNameLabelMnemonic);
        } else {
            this.fileNameLabel.setText(this.fileNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsFileChooserUI((JFileChooser)jComponent);
    }

    public WindowsFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
        Object object;
        JComponent jComponent;
        JComponent jComponent2;
        JButton jButton;
        Object object2;
        Serializable serializable;
        this.filePane = new FilePane(new WindowsFileChooserUIAccessor());
        jFileChooser.addPropertyChangeListener(this.filePane);
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        jFileChooser.setBorder(new EmptyBorder(4, 10, 10, 10));
        jFileChooser.setLayout(new BorderLayout(8, 8));
        this.updateUseShellFolder();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (OS_VERSION.compareTo(OSInfo.WINDOWS_ME) >= 0) {
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        jFileChooser.add((Component)jToolBar, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText, 11){

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getPreferredSize();
                if (WindowsFileChooserUI.this.placesBar != null) {
                    dimension.width = Math.max(dimension.width, WindowsFileChooserUI.this.placesBar.getWidth());
                }
                return dimension;
            }
        };
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.lookInLabel.setAlignmentX(0.0f);
        this.lookInLabel.setAlignmentY(0.5f);
        jToolBar.add(this.lookInLabel);
        jToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
        this.directoryComboBox = new JComboBox(){

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 60;
                return dimension;
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 150;
                return dimension;
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        this.directoryComboBox.setMaximumRowCount(8);
        jToolBar.add(this.directoryComboBox);
        jToolBar.add(Box.createRigidArea(hstrut10));
        JButton jButton2 = new JButton(this.getChangeToParentDirectoryAction());
        jButton2.setText(null);
        jButton2.setIcon(this.upFolderIcon);
        jButton2.setToolTipText(this.upFolderToolTipText);
        jButton2.putClientProperty("AccessibleName", this.upFolderAccessibleName);
        jButton2.putClientProperty(WindowsLookAndFeel.HI_RES_DISABLED_ICON_CLIENT_KEY, Boolean.TRUE);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.setFocusPainted(false);
        jToolBar.add(jButton2);
        if (OS_VERSION.compareTo(OSInfo.WINDOWS_ME) < 0) {
            jToolBar.add(Box.createRigidArea(hstrut10));
        }
        if (OS_VERSION == OSInfo.WINDOWS_98) {
            serializable = fileSystemView.getHomeDirectory();
            object2 = this.homeFolderToolTipText;
            if (fileSystemView.isRoot((File)serializable)) {
                object2 = this.getFileView(jFileChooser).getName((File)serializable);
            }
            jButton = new JButton(this.getFileView(jFileChooser).getIcon((File)serializable));
            jButton.setToolTipText((String)object2);
            jButton.putClientProperty("AccessibleName", object2);
            jButton.setAlignmentX(0.0f);
            jButton.setAlignmentY(0.5f);
            jButton.setMargin(shrinkwrap);
            jButton.setFocusPainted(false);
            jButton.addActionListener(this.getGoHomeAction());
            jToolBar.add(jButton);
            jToolBar.add(Box.createRigidArea(hstrut10));
        }
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            jButton = new JButton(this.filePane.getNewFolderAction());
            jButton.setText(null);
            jButton.setIcon(this.newFolderIcon);
            jButton.setToolTipText(this.newFolderToolTipText);
            jButton.putClientProperty("AccessibleName", this.newFolderAccessibleName);
            jButton.putClientProperty(WindowsLookAndFeel.HI_RES_DISABLED_ICON_CLIENT_KEY, Boolean.TRUE);
            jButton.setAlignmentX(0.0f);
            jButton.setAlignmentY(0.5f);
            jButton.setMargin(shrinkwrap);
            jButton.setFocusPainted(false);
            jToolBar.add(jButton);
        }
        if (OS_VERSION.compareTo(OSInfo.WINDOWS_ME) < 0) {
            jToolBar.add(Box.createRigidArea(hstrut10));
            serializable = new ButtonGroup();
            object2 = new JToggleButton(this.listViewIcon);
            ((JComponent)object2).setToolTipText(this.listViewButtonToolTipText);
            ((JComponent)object2).putClientProperty("AccessibleName", this.listViewButtonAccessibleName);
            ((JComponent)object2).putClientProperty(WindowsLookAndFeel.HI_RES_DISABLED_ICON_CLIENT_KEY, Boolean.TRUE);
            ((AbstractButton)object2).setFocusPainted(false);
            ((AbstractButton)object2).setSelected(true);
            ((JComponent)object2).setAlignmentX(0.0f);
            ((JComponent)object2).setAlignmentY(0.5f);
            ((AbstractButton)object2).setMargin(shrinkwrap);
            ((AbstractButton)object2).addActionListener(this.filePane.getViewTypeAction(0));
            jToolBar.add((Component)object2);
            ((ButtonGroup)serializable).add((AbstractButton)object2);
            jComponent2 = new JToggleButton(this.detailsViewIcon);
            jComponent2.setToolTipText(this.detailsViewButtonToolTipText);
            jComponent2.putClientProperty("AccessibleName", this.detailsViewButtonAccessibleName);
            jComponent2.putClientProperty(WindowsLookAndFeel.HI_RES_DISABLED_ICON_CLIENT_KEY, Boolean.TRUE);
            ((AbstractButton)jComponent2).setFocusPainted(false);
            jComponent2.setAlignmentX(0.0f);
            jComponent2.setAlignmentY(0.5f);
            ((AbstractButton)jComponent2).setMargin(shrinkwrap);
            ((AbstractButton)jComponent2).addActionListener(this.filePane.getViewTypeAction(1));
            jToolBar.add(jComponent2);
            ((ButtonGroup)serializable).add((AbstractButton)jComponent2);
            jToolBar.add(Box.createRigidArea(new Dimension(60, 0)));
            this.filePane.addPropertyChangeListener(new PropertyChangeListener((JToggleButton)object2, (JToggleButton)jComponent2){
                final /* synthetic */ JToggleButton val$listViewButton;
                final /* synthetic */ JToggleButton val$detailsViewButton;
                {
                    this.val$listViewButton = jToggleButton;
                    this.val$detailsViewButton = jToggleButton2;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("viewType".equals(propertyChangeEvent.getPropertyName())) {
                        int n = WindowsFileChooserUI.this.filePane.getViewType();
                        switch (n) {
                            case 0: {
                                this.val$listViewButton.setSelected(true);
                                break;
                            }
                            case 1: {
                                this.val$detailsViewButton.setSelected(true);
                            }
                        }
                    }
                }
            });
        } else {
            serializable = new ButtonGroup();
            object2 = new JPopupMenu();
            jComponent2 = new JRadioButtonMenuItem(this.filePane.getViewTypeAction(0));
            ((AbstractButton)jComponent2).setSelected(this.filePane.getViewType() == 0);
            ((JPopupMenu)object2).add((JMenuItem)jComponent2);
            ((ButtonGroup)serializable).add((AbstractButton)jComponent2);
            jComponent = new JRadioButtonMenuItem(this.filePane.getViewTypeAction(1));
            ((AbstractButton)jComponent).setSelected(this.filePane.getViewType() == 1);
            ((JPopupMenu)object2).add((JMenuItem)jComponent);
            ((ButtonGroup)serializable).add((AbstractButton)jComponent);
            object = new BufferedImage(this.viewMenuIcon.getIconWidth() + 7, this.viewMenuIcon.getIconHeight(), 2);
            Graphics graphics = ((BufferedImage)object).getGraphics();
            this.viewMenuIcon.paintIcon(this.filePane, graphics, 0, 0);
            int n = ((BufferedImage)object).getWidth() - 5;
            int n2 = ((BufferedImage)object).getHeight() / 2 - 1;
            graphics.setColor(Color.BLACK);
            graphics.fillPolygon(new int[]{n, n + 5, n + 2}, new int[]{n2, n2, n2 + 3}, 3);
            final JButton jButton3 = new JButton(new ImageIcon((Image)object));
            jButton3.setToolTipText(this.viewMenuButtonToolTipText);
            jButton3.putClientProperty("AccessibleName", this.viewMenuButtonAccessibleName);
            jButton3.putClientProperty(WindowsLookAndFeel.HI_RES_DISABLED_ICON_CLIENT_KEY, Boolean.TRUE);
            jButton3.setFocusable(false);
            jButton3.setAlignmentX(0.0f);
            jButton3.setAlignmentY(0.5f);
            jButton3.setMargin(shrinkwrap);
            jButton3.setModel(new DefaultButtonModel(){

                public void setPressed(boolean bl) {
                }

                public void setArmed(boolean bl) {
                }

                public void setSelected(boolean bl) {
                    super.setSelected(bl);
                    this.stateMask = bl ? (this.stateMask |= 5) : (this.stateMask &= 0xFFFFFFFA);
                }
            });
            jButton3.addMouseListener(new MouseAdapter((JPopupMenu)object2){
                final /* synthetic */ JPopupMenu val$viewTypePopupMenu;
                {
                    this.val$viewTypePopupMenu = jPopupMenu;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        jButton3.setSelected(!jButton3.isSelected());
                        if (jButton3.isSelected()) {
                            this.val$viewTypePopupMenu.show(jButton3, 0, jButton3.getHeight());
                        }
                    }
                }
            });
            ((JPopupMenu)object2).addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jButton3.setSelected(false);
                        }
                    });
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
            jToolBar.add(jButton3);
            jToolBar.add(Box.createRigidArea(new Dimension(80, 0)));
            this.filePane.addPropertyChangeListener(new PropertyChangeListener((JRadioButtonMenuItem)jComponent2, (JRadioButtonMenuItem)jComponent){
                final /* synthetic */ JRadioButtonMenuItem val$listViewMenuItem;
                final /* synthetic */ JRadioButtonMenuItem val$detailsViewMenuItem;
                {
                    this.val$listViewMenuItem = jRadioButtonMenuItem;
                    this.val$detailsViewMenuItem = jRadioButtonMenuItem2;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("viewType".equals(propertyChangeEvent.getPropertyName())) {
                        switch (WindowsFileChooserUI.this.filePane.getViewType()) {
                            case 0: {
                                this.val$listViewMenuItem.setSelected(true);
                                break;
                            }
                            case 1: {
                                this.val$detailsViewMenuItem.setSelected(true);
                            }
                        }
                    }
                }
            });
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        serializable = jFileChooser.getAccessory();
        if (serializable != null) {
            this.getAccessoryPanel().add((Component)serializable);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.filePane, "Center");
        jFileChooser.add((Component)this.centerPanel, "Center");
        this.getBottomPanel().setLayout(new BoxLayout(this.getBottomPanel(), 2));
        this.centerPanel.add((Component)this.getBottomPanel(), "South");
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 3));
        ((Container)object2).add(Box.createRigidArea(vstrut4));
        this.fileNameLabel = new JLabel();
        this.populateFileNameLabel();
        this.fileNameLabel.setAlignmentY(0.0f);
        ((Container)object2).add(this.fileNameLabel);
        ((Container)object2).add(Box.createRigidArea(new Dimension(1, 12)));
        jComponent2 = new JLabel(this.filesOfTypeLabelText);
        ((JLabel)jComponent2).setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        ((Container)object2).add(jComponent2);
        this.getBottomPanel().add((Component)object2);
        this.getBottomPanel().add(Box.createRigidArea(new Dimension(15, 0)));
        jComponent = new JPanel();
        jComponent.add(Box.createRigidArea(vstrut8));
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        this.filenameTextField = new JTextField(35){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.fileNameLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!WindowsFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    WindowsFileChooserUI.this.filePane.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        jComponent.add(this.filenameTextField);
        jComponent.add(Box.createRigidArea(vstrut8));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        ((JLabel)jComponent2).setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jComponent.add(this.filterComboBox);
        this.getBottomPanel().add(jComponent);
        this.getBottomPanel().add(Box.createRigidArea(new Dimension(30, 0)));
        this.getButtonPanel().setLayout(new BoxLayout(this.getButtonPanel(), 1));
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser)){

            public Dimension getMaximumSize() {
                return ((WindowsFileChooserUI)WindowsFileChooserUI.this).approveButton.getPreferredSize().width > ((WindowsFileChooserUI)WindowsFileChooserUI.this).cancelButton.getPreferredSize().width ? WindowsFileChooserUI.this.approveButton.getPreferredSize() : WindowsFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        object = this.approveButton.getMargin();
        object = new InsetsUIResource(((Insets)object).top, ((Insets)object).left + 5, ((Insets)object).bottom, ((Insets)object).right + 5);
        this.approveButton.setMargin((Insets)object);
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.getButtonPanel().add(Box.createRigidArea(vstrut6));
        this.getButtonPanel().add(this.approveButton);
        this.getButtonPanel().add(Box.createRigidArea(vstrut4));
        this.cancelButton = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return ((WindowsFileChooserUI)WindowsFileChooserUI.this).approveButton.getPreferredSize().width > ((WindowsFileChooserUI)WindowsFileChooserUI.this).cancelButton.getPreferredSize().width ? WindowsFileChooserUI.this.approveButton.getPreferredSize() : WindowsFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.cancelButton.setMargin((Insets)object);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
    }

    private void updateUseShellFolder() {
        JFileChooser jFileChooser = this.getFileChooser();
        if (OS_VERSION.compareTo(OSInfo.WINDOWS_ME) >= 0) {
            if (FilePane.usesShellFolder(jFileChooser)) {
                if (this.placesBar == null && !UIManager.getBoolean("FileChooser.noPlacesBar")) {
                    this.placesBar = new WindowsPlacesBar(jFileChooser, XPStyle.getXP() != null);
                    jFileChooser.add((Component)this.placesBar, "Before");
                    jFileChooser.addPropertyChangeListener(this.placesBar);
                }
            } else if (this.placesBar != null) {
                jFileChooser.remove(this.placesBar);
                jFileChooser.removePropertyChangeListener(this.placesBar);
                this.placesBar = null;
            }
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.folderNameLabelMnemonic = UIManager.getInt("FileChooser.folderNameLabelMnemonic");
        this.folderNameLabelText = UIManager.getString((Object)"FileChooser.folderNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", locale);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", locale);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", locale);
        this.viewMenuButtonToolTipText = UIManager.getString((Object)"FileChooser.viewMenuButtonToolTipText", locale);
        this.viewMenuButtonAccessibleName = UIManager.getString((Object)"FileChooser.viewMenuButtonAccessibleName", locale);
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        FilePane.addActionsToMap(actionMapUIResource, this.filePane.getActions());
        return actionMapUIResource;
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        return this.filePane.createDetailsView();
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return super.createListSelectionListener(jFileChooser);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        jComponent.removePropertyChangeListener(this.filePane);
        if (this.placesBar != null) {
            jComponent.removePropertyChangeListener(this.placesBar);
        }
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = WindowsFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n ? n : dimension.width, dimension.height < WindowsFileChooserUI.PREF_SIZE.height ? WindowsFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n, WindowsFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() || jFileChooser.isDirectorySelectionEnabled() && jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystemRoot(file)) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.clearIconCache();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.fileNameLabel != null) {
            this.populateFileNameLabel();
        }
        this.clearIconCache();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    WindowsFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    WindowsFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    WindowsFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    WindowsFileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    WindowsFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    WindowsFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    WindowsFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    WindowsFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    WindowsFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    WindowsFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string == "FileChooser.useShellFolder") {
                    WindowsFileChooserUI.this.updateUseShellFolder();
                    WindowsFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                } else if (string.equals("ancestor") && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    WindowsFileChooserUI.this.filenameTextField.selectAll();
                    WindowsFileChooserUI.this.filenameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.filePane.ensureFileIsVisible(jFileChooser, file);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.filePane.rescanCurrentDirectory();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    protected void setDirectorySelected(boolean bl) {
        super.setDirectorySelected(bl);
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            this.approveButton.setMnemonic(this.directoryOpenButtonMnemonic);
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    protected class WindowsFileView
    extends BasicFileChooserUI.BasicFileView {
        protected WindowsFileView() {
            super(WindowsFileChooserUI.this);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }

    protected class DirectoryComboBoxAction
    implements ActionListener {
        protected DirectoryComboBoxAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)WindowsFileChooserUI.this.directoryComboBox.getSelectedItem();
            WindowsFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = WindowsFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                WindowsFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                for (FileFilter fileFilter2 : this.filters) {
                    if (fileFilter2 != fileFilter) continue;
                    bl = true;
                }
                if (!bl) {
                    WindowsFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = WindowsFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = WindowsFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            File file2;
            if (file == null) {
                return;
            }
            boolean bl = FilePane.usesShellFolder(this.chooser);
            this.directories.clear();
            File[] fileArray = bl ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                File file3;
                File file4 = file3 = bl ? ShellFolder.getShellFolder(file2) : file2;
                Vector<File> vector = new Vector<File>(10);
                do {
                    vector.addElement(file4);
                } while ((file4 = file4.getParentFile()) != null);
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    file4 = (File)vector.get(i);
                    if (!this.directories.contains(file4)) continue;
                    int n2 = this.directories.indexOf(file4);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)vector.get(j), n2 + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File file = this.directories.get(i);
                File file2 = file.getParentFile();
                this.depths[i] = 0;
                if (file2 == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!file2.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n) {
            return this.depths != null && n >= 0 && n < this.depths.length ? this.depths[n] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
            } else {
                this.icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(WindowsFileChooserUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = WindowsFileChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = WindowsFileChooserUI.this.directoryComboBoxModel.getDepth(n);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        protected SingleClickListener() {
        }
    }

    protected class WindowsNewFolderAction
    extends BasicFileChooserUI.NewFolderAction {
        protected WindowsNewFolderAction() {
            super(WindowsFileChooserUI.this);
        }
    }

    private class WindowsFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private WindowsFileChooserUIAccessor() {
        }

        public JFileChooser getFileChooser() {
            return WindowsFileChooserUI.this.getFileChooser();
        }

        public BasicDirectoryModel getModel() {
            return WindowsFileChooserUI.this.getModel();
        }

        public JPanel createList() {
            return WindowsFileChooserUI.this.createList(this.getFileChooser());
        }

        public JPanel createDetailsView() {
            return WindowsFileChooserUI.this.createDetailsView(this.getFileChooser());
        }

        public boolean isDirectorySelected() {
            return WindowsFileChooserUI.this.isDirectorySelected();
        }

        public File getDirectory() {
            return WindowsFileChooserUI.this.getDirectory();
        }

        public Action getChangeToParentDirectoryAction() {
            return WindowsFileChooserUI.this.getChangeToParentDirectoryAction();
        }

        public Action getApproveSelectionAction() {
            return WindowsFileChooserUI.this.getApproveSelectionAction();
        }

        public Action getNewFolderAction() {
            return WindowsFileChooserUI.this.getNewFolderAction();
        }

        public MouseListener createDoubleClickListener(JList jList) {
            return WindowsFileChooserUI.this.createDoubleClickListener(this.getFileChooser(), jList);
        }

        public ListSelectionListener createListSelectionListener() {
            return WindowsFileChooserUI.this.createListSelectionListener(this.getFileChooser());
        }
    }
}

