/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.BerDecoder;
import com.sun.jmx.snmp.BerEncoder;
import com.sun.jmx.snmp.BerException;
import com.sun.jmx.snmp.SnmpEngineId;
import com.sun.jmx.snmp.SnmpMsg;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduBulkType;
import com.sun.jmx.snmp.SnmpPduRequestType;
import com.sun.jmx.snmp.SnmpScopedPduBulk;
import com.sun.jmx.snmp.SnmpScopedPduPacket;
import com.sun.jmx.snmp.SnmpScopedPduRequest;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import java.util.logging.Level;

public class SnmpV3Message
extends SnmpMsg {
    public int msgId = 0;
    public int msgMaxSize = 0;
    public byte msgFlags = 0;
    public int msgSecurityModel = 0;
    public byte[] msgSecurityParameters = null;
    public byte[] contextEngineId = null;
    public byte[] contextName = null;
    public byte[] encryptedPdu = null;

    public int encodeMessage(byte[] byArray) throws SnmpTooBigException {
        boolean bl = false;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "encodeMessage", "Can't encode directly V3Message! Need a SecuritySubSystem");
        }
        throw new IllegalArgumentException("Can't encode");
    }

    public void decodeMessage(byte[] byArray, int n) throws SnmpStatusException {
        Object object;
        try {
            object = new BerDecoder(byArray);
            ((BerDecoder)object).openSequence();
            this.version = ((BerDecoder)object).fetchInteger();
            ((BerDecoder)object).openSequence();
            this.msgId = ((BerDecoder)object).fetchInteger();
            this.msgMaxSize = ((BerDecoder)object).fetchInteger();
            this.msgFlags = ((BerDecoder)object).fetchOctetString()[0];
            this.msgSecurityModel = ((BerDecoder)object).fetchInteger();
            ((BerDecoder)object).closeSequence();
            this.msgSecurityParameters = ((BerDecoder)object).fetchOctetString();
            if ((this.msgFlags & 0) == 0) {
                ((BerDecoder)object).openSequence();
                this.contextEngineId = ((BerDecoder)object).fetchOctetString();
                this.contextName = ((BerDecoder)object).fetchOctetString();
                this.data = ((BerDecoder)object).fetchAny();
                this.dataLength = this.data.length;
                ((BerDecoder)object).closeSequence();
            } else {
                this.encryptedPdu = ((BerDecoder)object).fetchOctetString();
            }
            ((BerDecoder)object).closeSequence();
        }
        catch (BerException berException) {
            berException.printStackTrace();
            throw new SnmpStatusException("Invalid encoding");
        }
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            object = new StringBuilder().append("Unmarshalled message : \n").append("version : ").append(this.version).append("\n").append("msgId : ").append(this.msgId).append("\n").append("msgMaxSize : ").append(this.msgMaxSize).append("\n").append("msgFlags : ").append(this.msgFlags).append("\n").append("msgSecurityModel : ").append(this.msgSecurityModel).append("\n").append("contextEngineId : ").append(this.contextEngineId == null ? null : SnmpEngineId.createEngineId(this.contextEngineId)).append("\n").append("contextName : ").append(this.contextName).append("\n").append("data : ").append(this.data).append("\n").append("dat len : ").append(this.data == null ? 0 : this.data.length).append("\n").append("encryptedPdu : ").append(this.encryptedPdu).append("\n");
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "decodeMessage", ((StringBuilder)object).toString());
        }
    }

    public int getRequestId(byte[] byArray) throws SnmpStatusException {
        BerDecoder berDecoder = null;
        int n = 0;
        try {
            berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            berDecoder.fetchInteger();
            berDecoder.openSequence();
            n = berDecoder.fetchInteger();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            // empty catch block
        }
        return n;
    }

    public void encodeSnmpPdu(SnmpPdu snmpPdu, int n) throws SnmpStatusException, SnmpTooBigException {
        Object object;
        SnmpScopedPduPacket snmpScopedPduPacket = (SnmpScopedPduPacket)snmpPdu;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            object = new StringBuilder().append("PDU to marshall: \n").append("security parameters : ").append(snmpScopedPduPacket.securityParameters).append("\n").append("type : ").append(snmpScopedPduPacket.type).append("\n").append("version : ").append(snmpScopedPduPacket.version).append("\n").append("requestId : ").append(snmpScopedPduPacket.requestId).append("\n").append("msgId : ").append(snmpScopedPduPacket.msgId).append("\n").append("msgMaxSize : ").append(snmpScopedPduPacket.msgMaxSize).append("\n").append("msgFlags : ").append(snmpScopedPduPacket.msgFlags).append("\n").append("msgSecurityModel : ").append(snmpScopedPduPacket.msgSecurityModel).append("\n").append("contextEngineId : ").append(snmpScopedPduPacket.contextEngineId).append("\n").append("contextName : ").append(snmpScopedPduPacket.contextName).append("\n");
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "encodeSnmpPdu", ((StringBuilder)object).toString());
        }
        this.version = snmpScopedPduPacket.version;
        this.address = snmpScopedPduPacket.address;
        this.port = snmpScopedPduPacket.port;
        this.msgId = snmpScopedPduPacket.msgId;
        this.msgMaxSize = snmpScopedPduPacket.msgMaxSize;
        this.msgFlags = snmpScopedPduPacket.msgFlags;
        this.msgSecurityModel = snmpScopedPduPacket.msgSecurityModel;
        this.contextEngineId = snmpScopedPduPacket.contextEngineId;
        this.contextName = snmpScopedPduPacket.contextName;
        this.securityParameters = snmpScopedPduPacket.securityParameters;
        this.data = new byte[n];
        try {
            object = new BerEncoder(this.data);
            ((BerEncoder)object).openSequence();
            this.encodeVarBindList((BerEncoder)object, snmpScopedPduPacket.varBindList);
            switch (snmpScopedPduPacket.type) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    SnmpPduRequestType snmpPduRequestType = (SnmpPduRequestType)((Object)snmpScopedPduPacket);
                    ((BerEncoder)object).putInteger(snmpPduRequestType.getErrorIndex());
                    ((BerEncoder)object).putInteger(snmpPduRequestType.getErrorStatus());
                    ((BerEncoder)object).putInteger(snmpScopedPduPacket.requestId);
                    break;
                }
                case 8: {
                    SnmpPduBulkType snmpPduBulkType = (SnmpPduBulkType)((Object)snmpScopedPduPacket);
                    ((BerEncoder)object).putInteger(snmpPduBulkType.getMaxRepetitions());
                    ((BerEncoder)object).putInteger(snmpPduBulkType.getNonRepeaters());
                    ((BerEncoder)object).putInteger(snmpScopedPduPacket.requestId);
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(snmpScopedPduPacket.type));
                }
            }
            ((BerEncoder)object).closeSequence(snmpScopedPduPacket.type);
            this.dataLength = ((BerEncoder)object).trim();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        SnmpScopedPduPacket snmpScopedPduPacket = null;
        BerDecoder berDecoder = new BerDecoder(this.data);
        try {
            int n = berDecoder.getTag();
            berDecoder.openSequence(n);
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    SnmpScopedPduRequest snmpScopedPduRequest = new SnmpScopedPduRequest();
                    snmpScopedPduRequest.requestId = berDecoder.fetchInteger();
                    snmpScopedPduRequest.setErrorStatus(berDecoder.fetchInteger());
                    snmpScopedPduRequest.setErrorIndex(berDecoder.fetchInteger());
                    snmpScopedPduPacket = snmpScopedPduRequest;
                    break;
                }
                case 8: {
                    SnmpScopedPduBulk snmpScopedPduBulk = new SnmpScopedPduBulk();
                    snmpScopedPduBulk.requestId = berDecoder.fetchInteger();
                    snmpScopedPduBulk.setNonRepeaters(berDecoder.fetchInteger());
                    snmpScopedPduBulk.setMaxRepetitions(berDecoder.fetchInteger());
                    snmpScopedPduPacket = snmpScopedPduBulk;
                    break;
                }
                default: {
                    throw new SnmpStatusException(0);
                }
            }
            snmpScopedPduPacket.type = n;
            snmpScopedPduPacket.varBindList = this.decodeVarBindList(berDecoder);
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpV3Message.class.getName(), "decodeSnmpPdu", "BerException", berException);
            }
            throw new SnmpStatusException(0);
        }
        snmpScopedPduPacket.address = this.address;
        snmpScopedPduPacket.port = this.port;
        snmpScopedPduPacket.msgFlags = this.msgFlags;
        snmpScopedPduPacket.version = this.version;
        snmpScopedPduPacket.msgId = this.msgId;
        snmpScopedPduPacket.msgMaxSize = this.msgMaxSize;
        snmpScopedPduPacket.msgSecurityModel = this.msgSecurityModel;
        snmpScopedPduPacket.contextEngineId = this.contextEngineId;
        snmpScopedPduPacket.contextName = this.contextName;
        snmpScopedPduPacket.securityParameters = this.securityParameters;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder().append("Unmarshalled PDU : \n").append("type : ").append(snmpScopedPduPacket.type).append("\n").append("version : ").append(snmpScopedPduPacket.version).append("\n").append("requestId : ").append(snmpScopedPduPacket.requestId).append("\n").append("msgId : ").append(snmpScopedPduPacket.msgId).append("\n").append("msgMaxSize : ").append(snmpScopedPduPacket.msgMaxSize).append("\n").append("msgFlags : ").append(snmpScopedPduPacket.msgFlags).append("\n").append("msgSecurityModel : ").append(snmpScopedPduPacket.msgSecurityModel).append("\n").append("contextEngineId : ").append(snmpScopedPduPacket.contextEngineId).append("\n").append("contextName : ").append(snmpScopedPduPacket.contextName).append("\n");
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "decodeSnmpPdu", stringBuilder.toString());
        }
        return snmpScopedPduPacket;
    }

    public String printMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("msgId : " + this.msgId + "\n");
        stringBuffer.append("msgMaxSize : " + this.msgMaxSize + "\n");
        stringBuffer.append("msgFlags : " + this.msgFlags + "\n");
        stringBuffer.append("msgSecurityModel : " + this.msgSecurityModel + "\n");
        if (this.contextEngineId == null) {
            stringBuffer.append("contextEngineId : null");
        } else {
            stringBuffer.append("contextEngineId : {\n");
            stringBuffer.append(SnmpV3Message.dumpHexBuffer(this.contextEngineId, 0, this.contextEngineId.length));
            stringBuffer.append("\n}\n");
        }
        if (this.contextName == null) {
            stringBuffer.append("contextName : null");
        } else {
            stringBuffer.append("contextName : {\n");
            stringBuffer.append(SnmpV3Message.dumpHexBuffer(this.contextName, 0, this.contextName.length));
            stringBuffer.append("\n}\n");
        }
        return stringBuffer.append(super.printMessage()).toString();
    }
}

