/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;

public class SoftLimiter
implements SoftAudioProcessor {
    float lastmax = 0.0f;
    float gain = 1.0f;
    float[] temp_bufferL;
    float[] temp_bufferR;
    boolean mix = false;
    SoftAudioBuffer bufferL;
    SoftAudioBuffer bufferR;
    SoftAudioBuffer bufferLout;
    SoftAudioBuffer bufferRout;
    float controlrate;
    double silentcounter = 0.0;

    public void init(float f, float f2) {
        this.controlrate = f2;
    }

    public void setInput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.bufferL = softAudioBuffer;
        }
        if (n == 1) {
            this.bufferR = softAudioBuffer;
        }
    }

    public void setOutput(int n, SoftAudioBuffer softAudioBuffer) {
        if (n == 0) {
            this.bufferLout = softAudioBuffer;
        }
        if (n == 1) {
            this.bufferRout = softAudioBuffer;
        }
    }

    public void setMixMode(boolean bl) {
        this.mix = bl;
    }

    public void globalParameterControlChange(int[] nArray, long l, long l2) {
    }

    public void processAudio() {
        int n;
        float[] fArray;
        if (this.bufferL.isSilent() && (this.bufferR == null || this.bufferR.isSilent())) {
            this.silentcounter += (double)(1.0f / this.controlrate);
            if (this.silentcounter > 60.0) {
                if (!this.mix) {
                    this.bufferLout.clear();
                    this.bufferRout.clear();
                }
                return;
            }
        } else {
            this.silentcounter = 0.0;
        }
        float[] fArray2 = this.bufferL.array();
        float[] fArray3 = this.bufferR == null ? null : this.bufferR.array();
        float[] fArray4 = this.bufferLout.array();
        float[] fArray5 = fArray = this.bufferRout == null ? null : this.bufferRout.array();
        if (this.temp_bufferL == null || this.temp_bufferL.length < fArray2.length) {
            this.temp_bufferL = new float[fArray2.length];
        }
        if (fArray3 != null && (this.temp_bufferR == null || this.temp_bufferR.length < fArray3.length)) {
            this.temp_bufferR = new float[fArray3.length];
        }
        float f = 0.0f;
        int n2 = fArray2.length;
        if (fArray3 == null) {
            for (n = 0; n < n2; ++n) {
                if (fArray2[n] > f) {
                    f = fArray2[n];
                }
                if (!(-fArray2[n] > f)) continue;
                f = -fArray2[n];
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (fArray2[n] > f) {
                    f = fArray2[n];
                }
                if (fArray3[n] > f) {
                    f = fArray3[n];
                }
                if (-fArray2[n] > f) {
                    f = -fArray2[n];
                }
                if (!(-fArray3[n] > f)) continue;
                f = -fArray3[n];
            }
        }
        float f2 = this.lastmax;
        this.lastmax = f;
        if (f2 > f) {
            f = f2;
        }
        float f3 = 1.0f;
        f3 = f > 0.99f ? 0.99f / f : 1.0f;
        if (f3 > this.gain) {
            f3 = (f3 + this.gain * 9.0f) / 10.0f;
        }
        float f4 = (f3 - this.gain) / (float)n2;
        if (this.mix) {
            if (fArray3 == null) {
                int n3 = 0;
                while (n3 < n2) {
                    this.gain += f4;
                    float f5 = fArray2[n3];
                    float f6 = this.temp_bufferL[n3];
                    this.temp_bufferL[n3] = f5;
                    int n4 = n3++;
                    fArray4[n4] = fArray4[n4] + f6 * this.gain;
                }
            } else {
                int n5 = 0;
                while (n5 < n2) {
                    this.gain += f4;
                    float f7 = fArray2[n5];
                    float f8 = fArray3[n5];
                    float f9 = this.temp_bufferL[n5];
                    float f10 = this.temp_bufferR[n5];
                    this.temp_bufferL[n5] = f7;
                    this.temp_bufferR[n5] = f8;
                    int n6 = n5;
                    fArray4[n6] = fArray4[n6] + f9 * this.gain;
                    int n7 = n5++;
                    fArray[n7] = fArray[n7] + f10 * this.gain;
                }
            }
        } else if (fArray3 == null) {
            for (int i = 0; i < n2; ++i) {
                this.gain += f4;
                float f11 = fArray2[i];
                float f12 = this.temp_bufferL[i];
                this.temp_bufferL[i] = f11;
                fArray4[i] = f12 * this.gain;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.gain += f4;
                float f13 = fArray2[i];
                float f14 = fArray3[i];
                float f15 = this.temp_bufferL[i];
                float f16 = this.temp_bufferR[i];
                this.temp_bufferL[i] = f13;
                this.temp_bufferR[i] = f14;
                fArray4[i] = f15 * this.gain;
                fArray[i] = f16 * this.gain;
            }
        }
        this.gain = f3;
    }

    public void processControlLogic() {
    }
}

