/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.bytecode;

import com.sun.xml.internal.bind.Util;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClassTailor {
    private static final Logger logger = Util.getClassLogger();

    private ClassTailor() {
    }

    public static final String toVMClassName(Class clazz) {
        assert (!clazz.isPrimitive());
        if (clazz.isArray()) {
            return ClassTailor.toVMTypeName(clazz);
        }
        return clazz.getName().replace('.', '/');
    }

    public static final String toVMTypeName(Class clazz) {
        if (clazz.isArray()) {
            return '[' + ClassTailor.toVMTypeName(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            throw new IllegalArgumentException(clazz.getName());
        }
        return 'L' + clazz.getName().replace('.', '/') + ';';
    }

    public static final byte[] tailor(Class clazz, String string, String ... stringArray) {
        String string2 = ClassTailor.toVMClassName(clazz);
        return ClassTailor.tailor(clazz.getClassLoader().getResourceAsStream(string2 + ".class"), string2, string, stringArray);
    }

    public static final byte[] tailor(InputStream inputStream, String string, String string2, String ... stringArray) {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            long l = dataInputStream.readLong();
            dataOutputStream.writeLong(l);
            int n2 = dataInputStream.readShort();
            dataOutputStream.writeShort(n2);
            block10: for (int i = 0; i < n2; ++i) {
                n = dataInputStream.readByte();
                dataOutputStream.writeByte(n);
                switch (n) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        String string3 = dataInputStream.readUTF();
                        if (string3.equals(string)) {
                            string3 = string2;
                        } else {
                            for (int j = 0; j < stringArray.length; j += 2) {
                                if (!string3.equals(stringArray[j])) continue;
                                string3 = stringArray[j + 1];
                                break;
                            }
                        }
                        dataOutputStream.writeUTF(string3);
                        continue block10;
                    }
                    case 3: 
                    case 4: {
                        dataOutputStream.writeInt(dataInputStream.readInt());
                        continue block10;
                    }
                    case 5: 
                    case 6: {
                        ++i;
                        dataOutputStream.writeLong(dataInputStream.readLong());
                        continue block10;
                    }
                    case 7: 
                    case 8: {
                        dataOutputStream.writeShort(dataInputStream.readShort());
                        continue block10;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        dataOutputStream.writeInt(dataInputStream.readInt());
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown constant type " + n);
                    }
                }
            }
            byte[] byArray = new byte[512];
            while ((n = dataInputStream.read(byArray)) > 0) {
                dataOutputStream.write(byArray, 0, n);
            }
            dataInputStream.close();
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "failed to tailor", iOException);
            return null;
        }
    }
}

