/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.xml.internal.ws.encoding.soap.message.SOAPMsgCreateException;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPMsgFactoryCreateException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class SOAPUtil {
    private static final MessageFactory soap11messageFactory = SOAPUtil.createMessageFactory("SOAP 1.1 Protocol");
    private static final MessageFactory soap12messageFactory = SOAPUtil.createMessageFactory("SOAP 1.2 Protocol");
    private static final SOAPFactory soap11Factory = SOAPUtil.createSOAPFactory("SOAP 1.1 Protocol");
    private static final SOAPFactory soap12Factory = SOAPUtil.createSOAPFactory("SOAP 1.2 Protocol");

    private static SOAPFactory createSOAPFactory(String string) {
        try {
            return SOAPFactory.newInstance(string);
        }
        catch (SOAPException sOAPException) {
            throw new SOAPMsgFactoryCreateException("soap.factory.create.err", new Object[]{sOAPException});
        }
    }

    public static SOAPFactory getSOAPFactory(String string) {
        if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            return soap12Factory;
        }
        return soap11Factory;
    }

    public static SOAPFault createSOAPFault(String string) {
        if (string == null) {
            string = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        try {
            if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                return soap12Factory.createFault();
            }
            return soap11Factory.createFault();
        }
        catch (SOAPException sOAPException) {
            throw new SOAPMsgFactoryCreateException("soap.fault.create.err", new Object[]{sOAPException});
        }
    }

    public static SOAPFault createSOAPFault(String string, QName qName, String string2, Detail detail, String string3) {
        if (string3 == null) {
            string3 = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        try {
            SOAPFault sOAPFault = null;
            if (string3.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                sOAPFault = soap12Factory.createFault(string, qName);
            } else if (string3.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                sOAPFault = soap11Factory.createFault(string, qName);
            }
            if (string2 != null) {
                sOAPFault.setFaultActor(string2);
            }
            if (detail != null) {
                Node node = sOAPFault.getOwnerDocument().importNode(detail, true);
                sOAPFault.appendChild(node);
            }
            return sOAPFault;
        }
        catch (SOAPException sOAPException) {
            throw new SOAPMsgFactoryCreateException("soap.fault.create.err", new Object[]{sOAPException});
        }
    }

    public static SOAPMessage createMessage() {
        return SOAPUtil.createMessage("http://schemas.xmlsoap.org/wsdl/soap/http");
    }

    public static SOAPMessage createMessage(String string) {
        try {
            return SOAPUtil.getMessageFactory(string).createMessage();
        }
        catch (SOAPException sOAPException) {
            throw new SOAPMsgCreateException("soap.msg.create.err", new Object[]{sOAPException});
        }
    }

    public static SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream, String string) throws IOException {
        try {
            return SOAPUtil.getMessageFactory(string).createMessage(mimeHeaders, inputStream);
        }
        catch (SOAPException sOAPException) {
            throw new SOAPMsgCreateException("soap.msg.create.err", new Object[]{sOAPException});
        }
    }

    public static SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws IOException {
        return SOAPUtil.createMessage(mimeHeaders, inputStream, "http://schemas.xmlsoap.org/wsdl/soap/http");
    }

    public static MessageFactory getMessageFactory(String string) {
        if (string.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
            return soap11messageFactory;
        }
        if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            return soap12messageFactory;
        }
        return soap11messageFactory;
    }

    private static MessageFactory createMessageFactory(String string) {
        try {
            return MessageFactory.newInstance(string);
        }
        catch (SOAPException sOAPException) {
            throw new SOAPMsgFactoryCreateException("soap.msg.factory.create.err", new Object[]{sOAPException});
        }
    }
}

