/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.CharacterIterator;
import java.text.DictionaryBasedBreakIterator;
import java.text.RuleBasedBreakIterator;
import java.text.StringCharacterIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.util.LocaleServiceProviderPool;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    private static final int CHARACTER_INDEX = 0;
    private static final int WORD_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int SENTENCE_INDEX = 3;
    private static final SoftReference[] iterCache = new SoftReference[4];

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    public int preceding(int n) {
        int n2 = this.following(n);
        while (n2 >= n && n2 != -1) {
            n2 = this.previous();
        }
        return n2;
    }

    public boolean isBoundary(int n) {
        if (n == 0) {
            return true;
        }
        int n2 = this.following(n - 1);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return n2 == n;
    }

    public abstract int current();

    public abstract CharacterIterator getText();

    public void setText(String string) {
        this.setText(new StringCharacterIterator(string));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 1, "WordData", "WordDictionary");
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 2, "LineData", "LineDictionary");
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 0, "CharacterData", "CharacterDictionary");
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        return BreakIterator.getBreakInstance(locale, 3, "SentenceData", "SentenceDictionary");
    }

    private static BreakIterator getBreakInstance(Locale locale, int n, String string, String string2) {
        Object object;
        if (iterCache[n] != null && (object = (BreakIteratorCache)iterCache[n].get()) != null && ((BreakIteratorCache)object).getLocale().equals(locale)) {
            return ((BreakIteratorCache)object).createBreakInstance();
        }
        object = BreakIterator.createBreakInstance(locale, n, string, string2);
        BreakIteratorCache breakIteratorCache = new BreakIteratorCache(locale, (BreakIterator)object);
        BreakIterator.iterCache[n] = new SoftReference<BreakIteratorCache>(breakIteratorCache);
        return object;
    }

    private static ResourceBundle getBundle(final String string, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(string, locale);
            }
        });
    }

    private static BreakIterator createBreakInstance(Locale locale, int n, String string, String string2) {
        Object object;
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(BreakIteratorProvider.class);
        if (localeServiceProviderPool.hasProviders() && (object = localeServiceProviderPool.getLocalizedObject(BreakIteratorGetter.INSTANCE, locale, n)) != null) {
            return object;
        }
        object = BreakIterator.getBundle("sun.text.resources.BreakIteratorInfo", locale);
        String[] stringArray = ((ResourceBundle)object).getStringArray("BreakIteratorClasses");
        String string3 = ((ResourceBundle)object).getString(string);
        try {
            if (stringArray[n].equals("RuleBasedBreakIterator")) {
                return new RuleBasedBreakIterator(string3);
            }
            if (stringArray[n].equals("DictionaryBasedBreakIterator")) {
                String string4 = ((ResourceBundle)object).getString(string2);
                return new DictionaryBasedBreakIterator(string3, string4);
            }
            throw new IllegalArgumentException("Invalid break iterator class \"" + stringArray[n] + "\"");
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(BreakIteratorProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    static long getLong(byte[] byArray, int n) {
        long l = byArray[n] & 0xFF;
        for (int i = 1; i < 8; ++i) {
            l = l << 8 | (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    static int getInt(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        for (int i = 1; i < 4; ++i) {
            n2 = n2 << 8 | byArray[n + i] & 0xFF;
        }
        return n2;
    }

    static short getShort(byte[] byArray, int n) {
        short s = (short)(byArray[n] & 0xFF);
        s = (short)(s << 8 | byArray[n + 1] & 0xFF);
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BreakIteratorGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<BreakIteratorProvider, BreakIterator> {
        private static final BreakIteratorGetter INSTANCE = new BreakIteratorGetter();

        private BreakIteratorGetter() {
        }

        @Override
        public BreakIterator getObject(BreakIteratorProvider breakIteratorProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 1);
            switch ((Integer)objectArray[0]) {
                case 0: {
                    return breakIteratorProvider.getCharacterInstance(locale);
                }
                case 1: {
                    return breakIteratorProvider.getWordInstance(locale);
                }
                case 2: {
                    return breakIteratorProvider.getLineInstance(locale);
                }
                case 3: {
                    return breakIteratorProvider.getSentenceInstance(locale);
                }
            }
            assert (false) : "should not happen";
            return null;
        }
    }

    private static final class BreakIteratorCache {
        private BreakIterator iter;
        private Locale locale;

        BreakIteratorCache(Locale locale, BreakIterator breakIterator) {
            this.locale = locale;
            this.iter = (BreakIterator)breakIterator.clone();
        }

        Locale getLocale() {
            return this.locale;
        }

        BreakIterator createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }
    }
}

