/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.MBeanInjector;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import javax.management.JMX;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.SendNotification;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardEmitterMBean
extends StandardMBean
implements NotificationEmitter,
SendNotification {
    private final NotificationEmitter emitter;
    private final MBeanNotificationInfo[] notificationInfo;

    public <T> StandardEmitterMBean(T t, Class<T> clazz, NotificationEmitter notificationEmitter) {
        this(t, clazz, false, notificationEmitter);
    }

    public <T> StandardEmitterMBean(T t, Class<T> clazz, boolean bl, NotificationEmitter notificationEmitter) {
        this(t, clazz, bl ? JMX.MBeanOptions.MXBEAN : null, notificationEmitter);
    }

    public <T> StandardEmitterMBean(T t, Class<T> clazz, JMX.MBeanOptions mBeanOptions, NotificationEmitter notificationEmitter) {
        super(t, clazz, mBeanOptions);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = StandardEmitterMBean.defaultMBNIs(t);
        if (notificationEmitter == null) {
            notificationEmitter = this.defaultEmitter(mBeanNotificationInfoArray);
        }
        this.emitter = notificationEmitter;
        this.notificationInfo = StandardEmitterMBean.firstNonEmpty(notificationEmitter.getNotificationInfo(), mBeanNotificationInfoArray);
        this.injectEmitter();
    }

    protected StandardEmitterMBean(Class<?> clazz, NotificationEmitter notificationEmitter) {
        this(clazz, false, notificationEmitter);
    }

    protected StandardEmitterMBean(Class<?> clazz, boolean bl, NotificationEmitter notificationEmitter) {
        this(clazz, bl ? JMX.MBeanOptions.MXBEAN : null, notificationEmitter);
    }

    protected StandardEmitterMBean(Class<?> clazz, JMX.MBeanOptions mBeanOptions, NotificationEmitter notificationEmitter) {
        super(clazz, mBeanOptions);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = StandardEmitterMBean.defaultMBNIs(this);
        if (notificationEmitter == null) {
            notificationEmitter = this.defaultEmitter(mBeanNotificationInfoArray);
        }
        this.emitter = notificationEmitter;
        this.notificationInfo = StandardEmitterMBean.firstNonEmpty(notificationEmitter.getNotificationInfo(), mBeanNotificationInfoArray);
        this.injectEmitter();
    }

    private static MBeanNotificationInfo[] defaultMBNIs(Object object) {
        return MBeanIntrospector.findNotificationsFromAnnotations(object.getClass());
    }

    private NotificationEmitter defaultEmitter(MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = StandardEmitterMBean.firstNonEmpty(this.getNotificationInfo(), mBeanNotificationInfoArray);
        if (mBeanNotificationInfoArray2 == null) {
            mBeanNotificationInfoArray2 = this.getMBeanInfo().getNotifications();
        }
        return new NotificationBroadcasterSupport(mBeanNotificationInfoArray2);
    }

    private static <T> T[] firstNonEmpty(T[] ... TArray) {
        for (T[] TArray2 : TArray) {
            if (TArray2 == null || TArray2.length == 0) continue;
            return TArray2;
        }
        return null;
    }

    private void injectEmitter() {
        if (this.emitter instanceof SendNotification) {
            try {
                Object object = this.getImplementation();
                SendNotification sendNotification = (SendNotification)((Object)this.emitter);
                MBeanInjector.injectSendNotification(object, sendNotification);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notificationInfo;
    }

    @Override
    public void sendNotification(Notification notification) {
        if (!(this.emitter instanceof SendNotification)) {
            String string = "Cannot sendNotification when emitter is not an instance of SendNotification: " + this.emitter.getClass().getName();
            throw new ClassCastException(string);
        }
        ((SendNotification)((Object)this.emitter)).sendNotification(notification);
    }

    @Override
    MBeanNotificationInfo[] getNotifications(MBeanInfo mBeanInfo) {
        return this.getNotificationInfo();
    }
}

