/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.namespace.JMXNamespace;
import javax.management.namespace.JMXNamespaces;

public class JMXDomain
extends JMXNamespace {
    public static final String TYPE = "JMXDomain";
    public static final String TYPE_ASSIGNMENT = "type=JMXDomain";

    public JMXDomain(MBeanServer mBeanServer) {
        super(mBeanServer);
    }

    public final String getDefaultDomain() {
        ObjectName objectName = this.getObjectName();
        if (objectName == null) {
            throw new IllegalStateException("DefaultDomain is not yet known");
        }
        String string = objectName.getDomain();
        return string;
    }

    public final String[] getDomains() {
        return new String[]{this.getDefaultDomain()};
    }

    public Integer getMBeanCount() {
        ObjectName objectName = this.getObjectName();
        if (objectName == null) {
            return 0;
        }
        try {
            return this.getSourceServer().queryNames(ObjectName.WILDCARD.withDomain(objectName.getDomain()), null).size();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception: " + exception, exception);
        }
    }

    public static ObjectName getDomainObjectName(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("//")) {
            throw new IllegalArgumentException("domain contains //: " + string);
        }
        return ObjectName.valueOf(string, "type", TYPE);
    }

    ObjectName validateHandlerName(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("Must supply a valid name");
        }
        String string = JMXNamespaces.normalizeNamespaceName(objectName.getDomain());
        ObjectName objectName2 = JMXDomain.getDomainObjectName(string);
        if (!objectName.equals(objectName2)) {
            throw new IllegalArgumentException("invalid name space name: " + objectName);
        }
        return objectName;
    }

    public void addMBeanServerNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter) {
        try {
            this.getSourceServer().addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener, notificationFilter, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new UnsupportedOperationException("Unexpected exception: Emission of MBeanServerNotification disabled.", instanceNotFoundException);
        }
    }

    public void removeMBeanServerNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        try {
            this.getSourceServer().removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new UnsupportedOperationException("Unexpected exception: Emission of MBeanServerNotification disabled.", instanceNotFoundException);
        }
    }
}

