/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataSupport
implements CompositeData,
Serializable {
    static final long serialVersionUID = 8003518976613702244L;
    private final SortedMap<String, Object> contents;
    private final CompositeType compositeType;

    public CompositeDataSupport(CompositeType compositeType, String[] stringArray, Object[] objectArray) throws OpenDataException {
        this(CompositeDataSupport.makeMap(stringArray, objectArray), compositeType);
    }

    private static SortedMap<String, Object> makeMap(String[] stringArray, Object[] objectArray) throws OpenDataException {
        if (stringArray == null || objectArray == null) {
            throw new IllegalArgumentException("Null itemNames or itemValues");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Different lengths: itemNames[" + stringArray.length + "], itemValues[" + objectArray.length + "]");
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || string.equals("")) {
                throw new IllegalArgumentException("Null or empty item name");
            }
            if (treeMap.containsKey(string)) {
                throw new OpenDataException("Duplicate item name " + string);
            }
            treeMap.put(stringArray[i], objectArray[i]);
        }
        return treeMap;
    }

    public CompositeDataSupport(CompositeType compositeType, Map<String, ?> map) throws OpenDataException {
        this(CompositeDataSupport.makeMap(map), compositeType);
    }

    private static SortedMap<String, Object> makeMap(Map<String, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException("Null items map");
        }
        if (map.containsKey(null) || map.containsKey("")) {
            throw new IllegalArgumentException("Null or empty item name");
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (String string : map.keySet()) {
            if (!(string instanceof String)) {
                throw new ArrayStoreException("Item name is not string: " + string);
            }
            treeMap.put(string, map.get(string));
        }
        return treeMap;
    }

    private CompositeDataSupport(SortedMap<String, Object> sortedMap, CompositeType compositeType) throws OpenDataException {
        Set<String> set;
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument compositeType cannot be null.");
        }
        Set<String> set2 = compositeType.keySet();
        if (!((Object)set2).equals(set = sortedMap.keySet())) {
            TreeSet<String> treeSet = new TreeSet<String>(set2);
            treeSet.removeAll(set);
            TreeSet<String> object = new TreeSet<String>(set);
            object.removeAll(set2);
            if (!treeSet.isEmpty() || !object.isEmpty()) {
                throw new OpenDataException("Item names do not match CompositeType: names in items but not in CompositeType: " + object + "; names in CompositeType but not in items: " + treeSet);
            }
        }
        for (String string : set2) {
            OpenType<?> openType;
            Object v = sortedMap.get(string);
            if (v == null || (openType = compositeType.getType(string)).isValue(v)) continue;
            throw new OpenDataException("Argument value of wrong type for item " + string + ": value " + v + ", type " + openType);
        }
        this.compositeType = compositeType;
        this.contents = sortedMap;
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    @Override
    public Object get(String string) {
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Argument key cannot be a null or empty String.");
        }
        if (!this.contents.containsKey(string.trim())) {
            throw new InvalidKeyException("Argument key=\"" + string.trim() + "\" is not an existing item name for this CompositeData instance.");
        }
        return this.contents.get(string.trim());
    }

    @Override
    public Object[] getAll(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public boolean containsKey(String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        return this.contents.containsKey(string);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contents.containsValue(object);
    }

    @Override
    public Collection<?> values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    public static Map<String, Object> toMap(CompositeData compositeData) {
        if (compositeData == null) {
            throw new IllegalArgumentException("Null argument");
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        CompositeType compositeType = compositeData.getCompositeType();
        for (String string : compositeType.keySet()) {
            Object object = compositeData.get(string);
            linkedHashMap.put(string, object);
        }
        return linkedHashMap;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompositeData)) {
            return false;
        }
        CompositeData compositeData = (CompositeData)object;
        if (!this.getCompositeType().equals(compositeData.getCompositeType())) {
            return false;
        }
        if (this.contents.size() != compositeData.values().size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
            Object object2;
            Object object3 = entry.getValue();
            if (object3 == (object2 = compositeData.get(entry.getKey()))) continue;
            if (object3 == null) {
                return false;
            }
            boolean bl = object3.getClass().isArray() ? Arrays.deepEquals(new Object[]{object3}, new Object[]{object2}) : object3.equals(object2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.compositeType.hashCode();
        for (Object object : this.contents.values()) {
            if (object instanceof Object[]) {
                n += Arrays.deepHashCode((Object[])object);
                continue;
            }
            if (object instanceof byte[]) {
                n += Arrays.hashCode((byte[])object);
                continue;
            }
            if (object instanceof short[]) {
                n += Arrays.hashCode((short[])object);
                continue;
            }
            if (object instanceof int[]) {
                n += Arrays.hashCode((int[])object);
                continue;
            }
            if (object instanceof long[]) {
                n += Arrays.hashCode((long[])object);
                continue;
            }
            if (object instanceof char[]) {
                n += Arrays.hashCode((char[])object);
                continue;
            }
            if (object instanceof float[]) {
                n += Arrays.hashCode((float[])object);
                continue;
            }
            if (object instanceof double[]) {
                n += Arrays.hashCode((double[])object);
                continue;
            }
            if (object instanceof boolean[]) {
                n += Arrays.hashCode((boolean[])object);
                continue;
            }
            if (object == null) continue;
            n += object.hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(compositeType=" + this.compositeType.toString() + ",contents=" + this.contentString() + ")";
    }

    private String contentString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        String string = "";
        for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
            stringBuilder.append(string).append(entry.getKey()).append("=");
            String string2 = Arrays.deepToString(new Object[]{entry.getValue()});
            stringBuilder.append(string2.substring(1, string2.length() - 1));
            string = ", ";
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

