/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import sun.applet.AppletClassLoader;
import sun.awt.AWTSecurityManager;
import sun.awt.AppContext;
import sun.security.util.SecurityConstants;

public class AppletSecurity
extends AWTSecurityManager {
    private AppContext mainAppContext;
    private static Field facc = null;
    private static Field fcontext = null;
    private HashSet restrictedPackages = new HashSet();
    private boolean inThreadGroupCheck = false;

    public AppletSecurity() {
        this.reset();
        this.mainAppContext = AppContext.getAppContext();
    }

    public void reset() {
        this.restrictedPackages.clear();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.startsWith("package.restrict.access.") || (string = System.getProperty(string2)) == null || !string.equalsIgnoreCase("true")) continue;
                    String string3 = string2.substring(24);
                    AppletSecurity.this.restrictedPackages.add(string3);
                }
                return null;
            }
        });
    }

    private AppletClassLoader currentAppletClassLoader() {
        int n;
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null || classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        Class[] classArray = this.getClassContext();
        for (n = 0; n < classArray.length; ++n) {
            classLoader = classArray[n].getClassLoader();
            if (!(classLoader instanceof AppletClassLoader)) continue;
            return (AppletClassLoader)classLoader;
        }
        for (n = 0; n < classArray.length; ++n) {
            final ClassLoader classLoader2 = classArray[n].getClassLoader();
            if (!(classLoader2 instanceof URLClassLoader) || (classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessControlContext accessControlContext = null;
                    ProtectionDomain[] protectionDomainArray = null;
                    try {
                        accessControlContext = (AccessControlContext)facc.get(classLoader2);
                        if (accessControlContext == null) {
                            return null;
                        }
                        protectionDomainArray = (ProtectionDomain[])fcontext.get(accessControlContext);
                        if (protectionDomainArray == null) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        throw new UnsupportedOperationException(exception);
                    }
                    for (int i = 0; i < protectionDomainArray.length; ++i) {
                        ClassLoader classLoader = protectionDomainArray[i].getClassLoader();
                        if (!(classLoader instanceof AppletClassLoader)) continue;
                        return classLoader;
                    }
                    return null;
                }
            })) == null) continue;
            return (AppletClassLoader)classLoader;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof AppletClassLoader) {
            return (AppletClassLoader)classLoader;
        }
        return null;
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        if (this.currentAppletClassLoader() == null) {
            return false;
        }
        return this.getThreadGroup().parentOf(threadGroup);
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    public void checkAccess(Thread thread) {
        if (thread.getState() != Thread.State.TERMINATED && !this.inThreadGroup(thread)) {
            this.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.inThreadGroupCheck) {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                this.inThreadGroupCheck = true;
                if (!this.inThreadGroup(threadGroup)) {
                    this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
                Object var3_2 = null;
                this.inThreadGroupCheck = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.inThreadGroupCheck = false;
                throw throwable;
            }
        }
    }

    public void checkPackageAccess(String string) {
        super.checkPackageAccess(string);
        for (String string2 : this.restrictedPackages) {
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    public void checkAwtEventQueueAccess() {
        AppContext appContext = AppContext.getAppContext();
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appContext == this.mainAppContext && appletClassLoader != null) {
            super.checkAwtEventQueueAccess();
        }
    }

    public ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup;
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        ThreadGroup threadGroup2 = threadGroup = appletClassLoader == null ? null : appletClassLoader.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup;
        }
        return super.getThreadGroup();
    }

    public AppContext getAppContext() {
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appletClassLoader == null) {
            return null;
        }
        AppContext appContext = appletClassLoader.getAppContext();
        if (appContext == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return appContext;
    }

    static {
        try {
            facc = URLClassLoader.class.getDeclaredField("acc");
            facc.setAccessible(true);
            fcontext = AccessControlContext.class.getDeclaredField("context");
            fcontext.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new UnsupportedOperationException(noSuchFieldException);
        }
    }
}

