/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.namespace.HandlerInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanPermission;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.namespace.JMXDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainInterceptor
extends HandlerInterceptor<JMXDomain> {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    private final String domainName;
    private volatile ObjectName ALL;
    private final String serverName;
    private volatile NotificationListener mbsListener;

    public DomainInterceptor(String string, JMXDomain jMXDomain, String string2) {
        super(jMXDomain);
        this.domainName = string2;
        this.serverName = string;
        this.ALL = ObjectName.valueOf(string2 + ":*");
    }

    public String toString() {
        return this.getClass().getName() + "(parent=" + this.serverName + ", domain=" + this.domainName + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectDelegate(final MBeanServerDelegate mBeanServerDelegate) throws InstanceNotFoundException {
        final PatternNotificationFilter patternNotificationFilter = new PatternNotificationFilter(this.getPatternFor(null));
        DomainInterceptor domainInterceptor = this;
        synchronized (domainInterceptor) {
            if (this.mbsListener == null) {
                this.mbsListener = new NotificationListener(){

                    public void handleNotification(Notification notification, Object object) {
                        if (patternNotificationFilter.isNotificationEnabled(notification)) {
                            mBeanServerDelegate.sendNotification(notification);
                        }
                    }
                };
            }
        }
        ((JMXDomain)this.getHandlerInterceptorMBean()).addMBeanServerNotificationListener(this.mbsListener, patternNotificationFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disconnectDelegate() throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener notificationListener;
        DomainInterceptor domainInterceptor = this;
        synchronized (domainInterceptor) {
            notificationListener = this.mbsListener;
            if (notificationListener == null) {
                return;
            }
            this.mbsListener = null;
        }
        ((JMXDomain)this.getHandlerInterceptorMBean()).removeMBeanServerNotificationListener(notificationListener);
    }

    public final void addPostRegisterTask(Queue<Runnable> queue, final MBeanServerDelegate mBeanServerDelegate) {
        if (queue == null) {
            throw new IllegalArgumentException("task queue must not be null");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    DomainInterceptor.this.connectDelegate(mBeanServerDelegate);
                }
                catch (Exception exception) {
                    throw new UnsupportedOperationException("notification forwarding", exception);
                }
            }
        };
        queue.add(runnable);
    }

    public final void addPostDeregisterTask(Queue<Runnable> queue, MBeanServerDelegate mBeanServerDelegate) {
        if (queue == null) {
            throw new IllegalArgumentException("task queue must not be null");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    DomainInterceptor.this.disconnectDelegate();
                }
                catch (Exception exception) {
                    throw new UnsupportedOperationException("notification forwarding", exception);
                }
            }
        };
        queue.add(runnable);
    }

    @Override
    protected ObjectName toSource(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        if (objectName.isDomainPattern()) {
            return objectName;
        }
        String string = objectName.getDomain();
        if (!string.equals(this.domainName)) {
            throw new IllegalArgumentException(objectName.toString());
        }
        return objectName;
    }

    @Override
    protected ObjectName toTarget(ObjectName objectName) {
        return objectName;
    }

    @Override
    Set<ObjectInstance> processOutputInstances(Set<ObjectInstance> set) {
        if (set == null || set.isEmpty() || !this.checkOn()) {
            return set;
        }
        Set<ObjectInstance> set2 = Util.equivalentEmptySet(set);
        for (ObjectInstance objectInstance : set) {
            if (!this.checkQuery(objectInstance.getObjectName(), "queryMBeans")) continue;
            set2.add(objectInstance);
        }
        return set2;
    }

    @Override
    Set<ObjectName> processOutputNames(Set<ObjectName> set) {
        if (set == null || set.isEmpty() || !this.checkOn()) {
            return set;
        }
        Set<ObjectName> set2 = Util.equivalentEmptySet(set);
        for (ObjectName objectName : set) {
            if (!this.checkQuery(objectName, "queryNames")) continue;
            set2.add(objectName);
        }
        return set2;
    }

    @Override
    ObjectInstance processOutputInstance(ObjectInstance objectInstance) {
        return objectInstance;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        try {
            ObjectName objectName2 = this.getPatternFor(objectName);
            Set<ObjectName> set = super.queryNames(objectName2, queryExp);
            return Util.filterMatchingNames(objectName2, set);
        }
        catch (Exception exception) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unexpected exception raised in queryNames: " + exception);
            }
            LOG.log(Level.FINEST, "Unexpected exception raised in queryNames", exception);
            return Collections.emptySet();
        }
    }

    private ObjectName getPatternFor(ObjectName objectName) {
        if (objectName == null) {
            return this.ALL;
        }
        if (objectName.getDomain().equals(this.domainName)) {
            return objectName;
        }
        return objectName.withDomain(this.domainName);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        try {
            ObjectName objectName2 = this.getPatternFor(objectName);
            Set<ObjectInstance> set = super.queryMBeans(objectName2, queryExp);
            return Util.filterMatchingInstances(objectName2, set);
        }
        catch (Exception exception) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unexpected exception raised in queryNames: " + exception);
            }
            LOG.log(Level.FINEST, "Unexpected exception raised in queryNames", exception);
            return Collections.emptySet();
        }
    }

    @Override
    public String getDefaultDomain() {
        return this.domainName;
    }

    @Override
    public String[] getDomains() {
        return new String[]{this.domainName};
    }

    @Override
    public Integer getMBeanCount() {
        return ((JMXDomain)this.getHandlerInterceptorMBean()).getMBeanCount();
    }

    private boolean checkOn() {
        SecurityManager securityManager = System.getSecurityManager();
        return securityManager != null;
    }

    @Override
    void check(ObjectName objectName, String string, String string2) {
        String string3;
        if (!this.checkOn()) {
            return;
        }
        String string4 = string3 = string2 == null ? "-" : string2;
        if ("queryMBeans".equals(string3) || "queryNames".equals(string3)) {
            this.check(objectName, "-", "-", string3);
        } else {
            this.check(objectName, null, string, string3);
        }
    }

    @Override
    void checkCreate(ObjectName objectName, String string, String string2) {
        if (!this.checkOn()) {
            return;
        }
        this.check(objectName, string, "-", string2);
    }

    void check(ObjectName objectName, String string, String string2, String string3) {
        Object object;
        MBeanPermission mBeanPermission;
        String string4;
        if (!this.checkOn()) {
            return;
        }
        String string5 = string4 = string3 == null ? "-" : string3;
        if ("getDomains".equals(string4)) {
            mBeanPermission = new MBeanPermission(this.serverName, "-", string2, objectName, string4);
        } else {
            object = string == null ? this.getClassName(objectName) : string;
            mBeanPermission = new MBeanPermission(this.serverName, (String)object, string2, objectName, string4);
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(mBeanPermission);
        }
    }

    String getClassName(ObjectName objectName) {
        if (objectName == null || objectName.isPattern()) {
            return "-";
        }
        try {
            return ((JMXDomain)this.getHandlerInterceptorMBean()).getSourceServer().getObjectInstance(objectName).getClassName();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            LOG.finest("Can't get class name for " + objectName + ", using \"-\". Cause is: " + instanceNotFoundException);
            return "-";
        }
    }

    @Override
    AttributeList checkAttributes(ObjectName objectName, AttributeList attributeList, String string) {
        if (!this.checkOn()) {
            return attributeList;
        }
        String string2 = this.getClassName(objectName);
        this.check(objectName, string2, "-", string);
        if (attributeList == null || attributeList.isEmpty()) {
            return attributeList;
        }
        AttributeList attributeList2 = new AttributeList();
        for (Attribute attribute : attributeList.asList()) {
            try {
                this.check(objectName, string2, attribute.getName(), string);
                attributeList2.add(attribute);
            }
            catch (SecurityException securityException) {}
        }
        return attributeList2;
    }

    @Override
    String[] checkAttributes(ObjectName objectName, String[] stringArray, String string) {
        if (!this.checkOn()) {
            return stringArray;
        }
        String string2 = this.getClassName(objectName);
        this.check(objectName, string2, "-", string);
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string3 : stringArray) {
            try {
                this.check(objectName, string2, string3, string);
                arrayList.add(string3);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    String[] checkDomains(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || !this.checkOn()) {
            return stringArray;
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.check(ObjectName.valueOf(stringArray[i] + ":x=x"), "-", "-", "getDomains");
                continue;
            }
            catch (SecurityException securityException) {
                ++n;
                stringArray[i] = null;
            }
        }
        if (n == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length - n];
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArray2[n++] = stringArray[i];
        }
        return stringArray2;
    }

    @Override
    boolean checkQuery(ObjectName objectName, String string) {
        try {
            String string2 = this.getClassName(objectName);
            this.check(objectName, string2, "-", string);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static class PatternNotificationFilter
    implements NotificationFilter {
        final ObjectName pattern;
        static final long serialVersionUID = 7409950927025262111L;

        public PatternNotificationFilter(ObjectName objectName) {
            this.pattern = objectName == null ? ObjectName.WILDCARD : objectName;
        }

        public boolean isNotificationEnabled(Notification notification) {
            if (!(notification instanceof MBeanServerNotification)) {
                return false;
            }
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            return this.pattern.apply(mBeanServerNotification.getMBeanName());
        }
    }
}

