/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftMainMixer;
import com.sun.media.sound.SoftSynthesizer;
import java.util.TreeMap;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public class SoftReceiver
implements Receiver {
    protected boolean open = true;
    private Object control_mutex;
    private SoftSynthesizer synth;
    protected TreeMap<Long, Object> midimessages;
    protected SoftMainMixer mainmixer;

    public SoftReceiver(SoftSynthesizer softSynthesizer) {
        this.control_mutex = softSynthesizer.control_mutex;
        this.synth = softSynthesizer;
        this.mainmixer = softSynthesizer.getMainMixer();
        if (this.mainmixer != null) {
            this.midimessages = this.mainmixer.midimessages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MidiMessage midiMessage, long l) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.open) {
                throw new IllegalStateException("Receiver is not open");
            }
        }
        if (l != -1L) {
            object = this.control_mutex;
            synchronized (object) {
                while (this.midimessages.get(l) != null) {
                    ++l;
                }
                if (midiMessage instanceof ShortMessage && ((ShortMessage)midiMessage).getChannel() > 15) {
                    this.midimessages.put(l, midiMessage.clone());
                } else {
                    this.midimessages.put(l, midiMessage.getMessage());
                }
            }
        } else {
            this.mainmixer.processMessage(midiMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.control_mutex;
        synchronized (object) {
            this.open = false;
        }
        this.synth.removeReceiver(this);
    }
}

