/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.ModalEventFilter;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.peer.DialogPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.util.IdentityArrayList;
import sun.awt.util.IdentityLinkedList;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dialog
extends Window {
    boolean resizable = true;
    boolean undecorated = false;
    public static final ModalityType DEFAULT_MODALITY_TYPE;
    boolean modal;
    ModalityType modalityType;
    private static final ModalExclusionType DEFAULT_MODAL_EXCLUSION_TYPE;
    static transient IdentityArrayList<Dialog> modalDialogs;
    transient IdentityArrayList<Window> blockedWindows = new IdentityArrayList();
    String title;
    private volatile transient boolean keepBlockingEDT = false;
    private volatile transient boolean keepBlockingCT = false;
    private transient ModalEventFilter modalFilter;
    volatile transient boolean isInHide = false;
    volatile transient boolean isInDispose = false;
    private static final String base = "dialog";
    private static int nameCounter;
    private static final long serialVersionUID = 5920926903803293709L;
    private transient AppContext showAppContext;

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        this((Window)frame, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS);
    }

    public Dialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        this((Window)frame, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS, graphicsConfiguration);
    }

    public Dialog(Dialog dialog) {
        this(dialog, "", false);
    }

    public Dialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public Dialog(Dialog dialog, String string, boolean bl) {
        this((Window)dialog, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS);
    }

    public Dialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        this((Window)dialog, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS, graphicsConfiguration);
    }

    public Dialog(Window window) {
        this(window, null, ModalityType.MODELESS);
    }

    public Dialog(Window window, String string) {
        this(window, string, ModalityType.MODELESS);
    }

    public Dialog(Window window, ModalityType modalityType) {
        this(window, null, modalityType);
    }

    public Dialog(Window window, String string, ModalityType modalityType) {
        super(window);
        if (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            throw new IllegalArgumentException("Wrong parent window");
        }
        this.title = string;
        this.setModalityType(modalityType);
        SunToolkit.checkAndSetPolicy(this, false);
    }

    public Dialog(Window window, String string, ModalityType modalityType, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        if (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            throw new IllegalArgumentException("wrong owner window");
        }
        this.title = string;
        this.setModalityType(modalityType);
        SunToolkit.checkAndSetPolicy(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Dialog> clazz = Dialog.class;
        synchronized (Dialog.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createDialog(this);
            }
            super.addNotify();
        }
    }

    public boolean isModal() {
        return this.isModal_NoClientCode();
    }

    final boolean isModal_NoClientCode() {
        return this.modalityType != ModalityType.MODELESS;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
        this.setModalityType(bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS);
    }

    public ModalityType getModalityType() {
        return this.modalityType;
    }

    public void setModalityType(ModalityType modalityType) {
        SecurityManager securityManager;
        if (modalityType == null) {
            modalityType = ModalityType.MODELESS;
        }
        if (!Toolkit.getDefaultToolkit().isModalityTypeSupported(modalityType)) {
            modalityType = ModalityType.MODELESS;
        }
        if (this.modalityType == modalityType) {
            return;
        }
        if (modalityType == ModalityType.TOOLKIT_MODAL && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SecurityConstants.TOOLKIT_MODALITY_PERMISSION);
        }
        this.modalityType = modalityType;
        this.modal = this.modalityType != ModalityType.MODELESS;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String string) {
        String string2 = this.title;
        Dialog dialog = this;
        synchronized (dialog) {
            this.title = string;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setTitle(string);
            }
        }
        this.firePropertyChange("title", string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean conditionalShow(Component component, AtomicLong atomicLong) {
        boolean bl;
        this.closeSplashScreen();
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.addNotify();
            }
            this.validate();
            if (this.visible) {
                this.toFront();
                bl = false;
            } else {
                bl = true;
                this.visible = true;
                if (!this.isModal()) {
                    Dialog.checkShouldBeBlocked(this);
                } else {
                    modalDialogs.add(this);
                    this.modalShow();
                }
                if (component != null && atomicLong != null && this.isFocusable() && this.isEnabled() && !this.isModalBlocked()) {
                    atomicLong.set(Toolkit.getEventQueue().getMostRecentEventTimeEx());
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().enqueueKeyEvents(atomicLong.get(), component);
                }
                this.mixOnShowing();
                this.peer.setVisible(true);
                if (this.isModalBlocked()) {
                    this.modalBlocker.toFront();
                }
                this.setLocationByPlatform(false);
                for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                    Window window = (Window)((WeakReference)this.ownedWindowList.elementAt(i)).get();
                    if (window == null || !window.showWithParent) continue;
                    window.show();
                    window.showWithParent = false;
                }
                Window.updateChildFocusableWindowState(this);
                this.createHierarchyEvents(1400, this, this.parent, 4L, Toolkit.enabledOnToolkit(32768L));
                if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 102);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
        }
        if (bl && (this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
        return bl;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void show() {
        this.beforeFirstShow = false;
        if (!this.isModal()) {
            this.conditionalShow(null, null);
        } else {
            this.keepBlockingEDT = true;
            this.keepBlockingCT = true;
            this.showAppContext = AppContext.getAppContext();
            AtomicLong atomicLong = new AtomicLong();
            Component component = null;
            try {
                component = this.getMostRecentFocusOwner();
                if (this.conditionalShow(component, atomicLong)) {
                    Runnable runnable;
                    EventQueue eventQueue;
                    this.modalFilter = ModalEventFilter.createFilterForDialog(this);
                    final Runnable runnable2 = new Runnable(){

                        public void run() {
                            EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                            eventDispatchThread.pumpEventsForFilter(new Conditional(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public boolean evaluate() {
                                    Object object = Dialog.this.getTreeLock();
                                    synchronized (object) {
                                        return Dialog.this.keepBlockingEDT && Dialog.this.windowClosingException == null;
                                    }
                                }
                            }, Dialog.this.modalFilter);
                        }
                    };
                    if (this.modalityType == ModalityType.TOOLKIT_MODAL) {
                        for (AppContext appContext : AppContext.getAppContexts()) {
                            if (appContext == this.showAppContext) continue;
                            eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
                            runnable = new Runnable(){

                                public void run() {
                                }
                            };
                            eventQueue.postEvent(new InvocationEvent((Object)this, runnable));
                            EventDispatchThread eventDispatchThread = eventQueue.getDispatchThread();
                            eventDispatchThread.addEventFilter(this.modalFilter);
                        }
                    }
                    this.modalityPushed();
                    try {
                        Object object;
                        if (EventQueue.isDispatchThread()) {
                            object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentSequencedEvent();
                            if (object != null) {
                                ((SequencedEvent)object).dispose();
                            }
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    runnable2.run();
                                    return null;
                                }
                            });
                        } else {
                            object = this.getTreeLock();
                            synchronized (object) {
                                Toolkit.getEventQueue().postEvent(new PeerEvent(this, runnable2, 1L));
                                while (this.keepBlockingCT && this.windowClosingException == null) {
                                    try {
                                        this.getTreeLock().wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                        break;
                                    }
                                }
                            }
                        }
                        Object var11_11 = null;
                        this.modalityPopped();
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        this.modalityPopped();
                        throw throwable;
                    }
                    if (this.modalityType == ModalityType.TOOLKIT_MODAL) {
                        for (AppContext appContext : AppContext.getAppContexts()) {
                            if (appContext == this.showAppContext) continue;
                            eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
                            runnable = eventQueue.getDispatchThread();
                            ((EventDispatchThread)runnable).removeEventFilter(this.modalFilter);
                        }
                    }
                    if (this.windowClosingException != null) {
                        this.windowClosingException.fillInStackTrace();
                        throw this.windowClosingException;
                    }
                }
                Object var13_14 = null;
                if (component != null) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().dequeueKeyEvents(atomicLong.get(), component);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (component != null) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().dequeueKeyEvents(atomicLong.get(), component);
                }
                throw throwable;
            }
        }
    }

    final void modalityPushed() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            SunToolkit sunToolkit = (SunToolkit)toolkit;
            sunToolkit.notifyModalityPushed(this);
        }
    }

    final void modalityPopped() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            SunToolkit sunToolkit = (SunToolkit)toolkit;
            sunToolkit.notifyModalityPopped(this);
        }
    }

    void interruptBlocking() {
        if (this.isModal()) {
            this.disposeImpl();
        } else if (this.windowClosingException != null) {
            this.windowClosingException.fillInStackTrace();
            this.windowClosingException.printStackTrace();
            this.windowClosingException = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideAndDisposePreHandler() {
        this.isInHide = true;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.keepBlockingEDT) {
                this.modalHide();
                if (this.modalFilter != null) {
                    this.modalFilter.disable();
                }
                modalDialogs.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideAndDisposeHandler() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.keepBlockingEDT) {
                this.keepBlockingEDT = false;
                PeerEvent peerEvent = new PeerEvent(this, new WakingRunnable(), 1L);
                AppContext appContext = AppContext.getAppContext();
                if (this.showAppContext != appContext) {
                    SunToolkit.postEvent(this.showAppContext, peerEvent);
                    this.showAppContext = null;
                } else {
                    Toolkit.getEventQueue().postEvent(peerEvent);
                }
            }
        }
        this.isInHide = false;
    }

    @Override
    @Deprecated
    public void hide() {
        this.hideAndDisposePreHandler();
        super.hide();
        if (!this.isInDispose) {
            this.hideAndDisposeHandler();
        }
    }

    @Override
    void doDispose() {
        this.isInDispose = true;
        super.doDispose();
        this.hideAndDisposeHandler();
        this.isInDispose = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBack() {
        super.toBack();
        if (this.visible) {
            Object object = this.getTreeLock();
            synchronized (object) {
                for (Window window : this.blockedWindows) {
                    window.toBack_NoClientCode();
                }
            }
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResizable(boolean bl) {
        boolean bl2 = false;
        Dialog dialog = this;
        synchronized (dialog) {
            this.resizable = bl;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setResizable(bl);
                bl2 = true;
            }
        }
        if (bl2) {
            this.invalidateIfValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUndecorated(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisplayable()) {
                throw new IllegalComponentStateException("The dialog is displayable.");
            }
            this.undecorated = bl;
        }
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    @Override
    protected String paramString() {
        String string = super.paramString() + "," + (Object)((Object)this.modalityType);
        if (this.title != null) {
            string = string + ",title=" + this.title;
        }
        return string;
    }

    private static native void initIDs();

    void modalShow() {
        Window[] windowArray;
        Object object;
        IdentityArrayList<Object> identityArrayList = new IdentityArrayList<Object>();
        for (Dialog dialog : modalDialogs) {
            if (!dialog.shouldBlock(this)) continue;
            for (object = dialog; object != null && object != this; object = ((Window)object).getOwner_NoClientCode()) {
            }
            if (object != this && this.shouldBlock(dialog) && this.modalityType.compareTo(dialog.getModalityType()) >= 0) continue;
            identityArrayList.add(dialog);
        }
        for (int i = 0; i < identityArrayList.size(); ++i) {
            Dialog dialog;
            dialog = (Dialog)identityArrayList.get(i);
            if (!dialog.isModalBlocked() || identityArrayList.contains(object = dialog.getModalBlocker())) continue;
            identityArrayList.add(i + 1, object);
        }
        if (identityArrayList.size() > 0) {
            ((Dialog)identityArrayList.get(0)).blockWindow(this);
        }
        IdentityArrayList<Window> identityArrayList2 = new IdentityArrayList<Window>(identityArrayList);
        for (int i = 0; i < identityArrayList2.size(); ++i) {
            object = (Window)identityArrayList2.get(i);
            for (Window window : windowArray = ((Window)object).getOwnedWindows_NoClientCode()) {
                identityArrayList2.add(window);
            }
        }
        object = new IdentityLinkedList();
        windowArray = Window.getAllUnblockedWindows();
        for (Window window : windowArray) {
            Dialog dialog;
            if (!this.shouldBlock(window) || identityArrayList2.contains(window) || window instanceof Dialog && ((Dialog)window).isModal_NoClientCode() && (dialog = (Dialog)window).shouldBlock(this) && modalDialogs.indexOf(dialog) > modalDialogs.indexOf(this)) continue;
            object.add(window);
        }
        this.blockWindows((List<Window>)object);
        if (!this.isModalBlocked()) {
            this.updateChildrenBlocking();
        }
    }

    void modalHide() {
        Window window;
        int n;
        IdentityArrayList<Window> identityArrayList = new IdentityArrayList<Window>();
        int n2 = this.blockedWindows.size();
        for (n = 0; n < n2; ++n) {
            window = this.blockedWindows.get(0);
            identityArrayList.add(window);
            this.unblockWindow(window);
        }
        for (n = 0; n < n2; ++n) {
            window = (Window)identityArrayList.get(n);
            if (window instanceof Dialog && ((Dialog)window).isModal_NoClientCode()) {
                Dialog dialog = (Dialog)window;
                dialog.modalShow();
                continue;
            }
            Dialog.checkShouldBeBlocked(window);
        }
    }

    boolean shouldBlock(Window window) {
        Container container;
        if (!this.isVisible_NoClientCode() || !window.isVisible_NoClientCode() && !window.isInShow || this.isInHide || window == this || !this.isModal_NoClientCode()) {
            return false;
        }
        if (window instanceof Dialog && ((Dialog)window).isInHide) {
            return false;
        }
        for (Dialog dialog = this; dialog != null; dialog = dialog.getModalBlocker()) {
            for (container = window; container != null && container != dialog; container = container.getParent_NoClientCode()) {
            }
            if (container != dialog) continue;
            return false;
        }
        switch (this.modalityType) {
            case MODELESS: {
                return false;
            }
            case DOCUMENT_MODAL: {
                if (window.isModalExcluded(ModalExclusionType.APPLICATION_EXCLUDE)) {
                    for (container = this; container != null && container != window; container = container.getParent_NoClientCode()) {
                    }
                    return container == window;
                }
                return this.getDocumentRoot() == window.getDocumentRoot();
            }
            case APPLICATION_MODAL: {
                return !window.isModalExcluded(ModalExclusionType.APPLICATION_EXCLUDE) && this.appContext == window.appContext;
            }
            case TOOLKIT_MODAL: {
                return !window.isModalExcluded(ModalExclusionType.TOOLKIT_EXCLUDE);
            }
        }
        return false;
    }

    void blockWindow(Window window) {
        if (!window.isModalBlocked()) {
            window.setModalBlocked(this, true, true);
            this.blockedWindows.add(window);
        }
    }

    void blockWindows(List<Window> list) {
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer == null) {
            return;
        }
        Iterator<Window> iterator = list.iterator();
        while (iterator.hasNext()) {
            Window window = iterator.next();
            if (!window.isModalBlocked()) {
                window.setModalBlocked(this, true, false);
                continue;
            }
            iterator.remove();
        }
        dialogPeer.blockWindows(list);
        this.blockedWindows.addAll(list);
    }

    void unblockWindow(Window window) {
        if (window.isModalBlocked() && this.blockedWindows.contains(window)) {
            this.blockedWindows.remove(window);
            window.setModalBlocked(this, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkShouldBeBlocked(Window window) {
        Object object = window.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < modalDialogs.size(); ++i) {
                Dialog dialog = modalDialogs.get(i);
                if (!dialog.shouldBlock(window)) continue;
                dialog.blockWindow(window);
                break;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        if (this.modalityType == null) {
            this.setModal(this.modal);
        }
        this.blockedWindows = new IdentityArrayList();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTDialog();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Dialog.initIDs();
        }
        DEFAULT_MODALITY_TYPE = ModalityType.APPLICATION_MODAL;
        DEFAULT_MODAL_EXCLUSION_TYPE = ModalExclusionType.APPLICATION_EXCLUDE;
        modalDialogs = new IdentityArrayList();
        nameCounter = 0;
    }

    protected class AccessibleAWTDialog
    extends Window.AccessibleAWTWindow {
        private static final long serialVersionUID = 4837230331833941201L;

        protected AccessibleAWTDialog() {
            super(Dialog.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DIALOG;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Dialog.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (Dialog.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            if (Dialog.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            return accessibleStateSet;
        }
    }

    final class WakingRunnable
    implements Runnable {
        WakingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = Dialog.this.getTreeLock();
            synchronized (object) {
                Dialog.this.keepBlockingCT = false;
                Dialog.this.getTreeLock().notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModalExclusionType {
        NO_EXCLUDE,
        APPLICATION_EXCLUDE,
        TOOLKIT_EXCLUDE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModalityType {
        MODELESS,
        DOCUMENT_MODAL,
        APPLICATION_MODAL,
        TOOLKIT_MODAL;

    }
}

