/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.text.BreakDictionary;
import java.text.CharacterIterator;
import java.text.RuleBasedBreakIterator;
import java.util.Stack;
import java.util.Vector;

class DictionaryBasedBreakIterator
extends RuleBasedBreakIterator {
    private BreakDictionary dictionary;
    private boolean[] categoryFlags;
    private int dictionaryCharCount;
    private int[] cachedBreakPositions;
    private int positionInCache;

    public DictionaryBasedBreakIterator(String string, String string2) throws IOException {
        super(string);
        byte[] byArray = super.getAdditionalData();
        if (byArray != null) {
            this.prepareCategoryFlags(byArray);
            super.setAdditionalData(null);
        }
        this.dictionary = new BreakDictionary(string2);
    }

    private void prepareCategoryFlags(byte[] byArray) {
        this.categoryFlags = new boolean[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.categoryFlags[i] = byArray[i] == 1;
        }
    }

    public void setText(CharacterIterator characterIterator) {
        super.setText(characterIterator);
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
    }

    public int first() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.first();
    }

    public int last() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.last();
    }

    public int previous() {
        CharacterIterator characterIterator = this.getText();
        if (this.cachedBreakPositions != null && this.positionInCache > 0) {
            --this.positionInCache;
            characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        this.cachedBreakPositions = null;
        int n = super.previous();
        if (this.cachedBreakPositions != null) {
            this.positionInCache = this.cachedBreakPositions.length - 2;
        }
        return n;
    }

    public int preceding(int n) {
        CharacterIterator characterIterator = this.getText();
        DictionaryBasedBreakIterator.checkOffset(n, characterIterator);
        if (this.cachedBreakPositions == null || n <= this.cachedBreakPositions[0] || n > this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.preceding(n);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && n > this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        --this.positionInCache;
        characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return characterIterator.getIndex();
    }

    public int following(int n) {
        CharacterIterator characterIterator = this.getText();
        DictionaryBasedBreakIterator.checkOffset(n, characterIterator);
        if (this.cachedBreakPositions == null || n < this.cachedBreakPositions[0] || n >= this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.following(n);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && n >= this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return characterIterator.getIndex();
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (this.cachedBreakPositions == null || this.positionInCache == this.cachedBreakPositions.length - 1) {
            int n = characterIterator.getIndex();
            this.dictionaryCharCount = 0;
            int n2 = super.handleNext();
            if (this.dictionaryCharCount > 1 && n2 - n > 1) {
                this.divideUpDictionaryRange(n, n2);
            } else {
                this.cachedBreakPositions = null;
                return n2;
            }
        }
        if (this.cachedBreakPositions != null) {
            ++this.positionInCache;
            characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        return -9999;
    }

    protected int lookupCategory(int n) {
        int n2 = super.lookupCategory(n);
        if (n2 != -1 && this.categoryFlags[n2]) {
            ++this.dictionaryCharCount;
        }
        return n2;
    }

    private void divideUpDictionaryRange(int n, int n2) {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(n);
        int n3 = this.getCurrent();
        int n4 = this.lookupCategory(n3);
        while (n4 == -1 || !this.categoryFlags[n4]) {
            n3 = this.getNext();
            n4 = this.lookupCategory(n3);
        }
        Stack stack = new Stack();
        Stack<Integer> stack2 = new Stack<Integer>();
        Vector vector = new Vector();
        int n5 = 0;
        int n6 = characterIterator.getIndex();
        Stack stack3 = null;
        n3 = this.getCurrent();
        while (true) {
            if (this.dictionary.getNextState(n5, 0) == -1) {
                stack2.push(characterIterator.getIndex());
            }
            if ((n5 = (int)this.dictionary.getNextStateFromCharacter(n5, n3)) == -1) {
                stack.push(characterIterator.getIndex());
                break;
            }
            if (n5 == 0 || characterIterator.getIndex() >= n2) {
                if (characterIterator.getIndex() > n6) {
                    n6 = characterIterator.getIndex();
                    stack3 = (Stack)stack.clone();
                }
                Object var12_12 = null;
                while (!stack2.isEmpty() && vector.contains(stack2.peek())) {
                    stack2.pop();
                }
                if (stack2.isEmpty()) {
                    if (stack3 != null) {
                        stack = stack3;
                        if (n6 >= n2) break;
                        characterIterator.setIndex(n6 + 1);
                    } else {
                        if ((stack.size() == 0 || ((Integer)stack.peek()).intValue() != characterIterator.getIndex()) && characterIterator.getIndex() != n) {
                            stack.push(new Integer(characterIterator.getIndex()));
                        }
                        this.getNext();
                        stack.push(new Integer(characterIterator.getIndex()));
                    }
                } else {
                    Integer n7 = (Integer)stack2.pop();
                    Object e = null;
                    while (!stack.isEmpty() && n7 < (Integer)stack.peek()) {
                        e = stack.pop();
                        vector.addElement(e);
                    }
                    stack.push(n7);
                    characterIterator.setIndex((Integer)stack.peek());
                }
                n3 = this.getCurrent();
                if (characterIterator.getIndex() < n2) continue;
                break;
            }
            n3 = this.getNext();
        }
        if (!stack.isEmpty()) {
            stack.pop();
        }
        stack.push(n2);
        this.cachedBreakPositions = new int[stack.size() + 1];
        this.cachedBreakPositions[0] = n;
        for (int i = 0; i < stack.size(); ++i) {
            this.cachedBreakPositions[i + 1] = (Integer)stack.elementAt(i);
        }
        this.positionInCache = 0;
    }
}

