/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.peer.ComponentPeer;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XEmbedCanvasPeer;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.awt.dnd.SunDropTargetEvent;
import sun.misc.Unsafe;

final class XDropTargetContextPeer
extends SunDropTargetContextPeer {
    private static final Logger logger = Logger.getLogger("sun.awt.X11.xembed.xdnd.XDropTargetContextPeer");
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private static final Object DTCP_KEY = "DropTargetContextPeer";

    private XDropTargetContextPeer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XDropTargetContextPeer getPeer(AppContext appContext) {
        Object object = _globalLock;
        synchronized (object) {
            XDropTargetContextPeer xDropTargetContextPeer = (XDropTargetContextPeer)appContext.get(DTCP_KEY);
            if (xDropTargetContextPeer == null) {
                xDropTargetContextPeer = new XDropTargetContextPeer();
                appContext.put(DTCP_KEY, xDropTargetContextPeer);
            }
            return xDropTargetContextPeer;
        }
    }

    static XDropTargetProtocolListener getXDropTargetProtocolListener() {
        return XDropTargetProtocolListenerImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventProcessed(SunDropTargetEvent sunDropTargetEvent, int n, boolean bl) {
        long l = this.getNativeDragContext();
        try {
            if (l != 0L && !sunDropTargetEvent.isConsumed()) {
                XDropTargetProtocol xDropTargetProtocol;
                Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
                while (iterator.hasNext() && !(xDropTargetProtocol = (XDropTargetProtocol)iterator.next()).sendResponse(l, sunDropTargetEvent.getID(), n)) {
                }
            }
            Object var9_7 = null;
            if (bl && l != 0L) {
                unsafe.freeMemory(l);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (bl && l != 0L) {
                unsafe.freeMemory(l);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDropDone(boolean bl, int n, boolean bl2) {
        long l = this.getNativeDragContext();
        if (l != 0L) {
            try {
                XDropTargetProtocol xDropTargetProtocol;
                Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
                while (iterator.hasNext() && !(xDropTargetProtocol = (XDropTargetProtocol)iterator.next()).sendDropDone(l, bl, n)) {
                }
                Object var9_7 = null;
                unsafe.freeMemory(l);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                unsafe.freeMemory(l);
                throw throwable;
            }
        }
    }

    protected Object getNativeData(long l) throws IOException {
        long l2 = this.getNativeDragContext();
        if (l2 != 0L) {
            Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                try {
                    return xDropTargetProtocol.getData(l2, l);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    private void cleanup() {
    }

    protected void processEnterMessage(SunDropTargetEvent sunDropTargetEvent) {
        if (!this.processSunDropTargetEvent(sunDropTargetEvent)) {
            super.processEnterMessage(sunDropTargetEvent);
        }
    }

    protected void processExitMessage(SunDropTargetEvent sunDropTargetEvent) {
        if (!this.processSunDropTargetEvent(sunDropTargetEvent)) {
            super.processExitMessage(sunDropTargetEvent);
        }
    }

    protected void processMotionMessage(SunDropTargetEvent sunDropTargetEvent, boolean bl) {
        if (!this.processSunDropTargetEvent(sunDropTargetEvent)) {
            super.processMotionMessage(sunDropTargetEvent, bl);
        }
    }

    protected void processDropMessage(SunDropTargetEvent sunDropTargetEvent) {
        if (!this.processSunDropTargetEvent(sunDropTargetEvent)) {
            super.processDropMessage(sunDropTargetEvent);
        }
    }

    private boolean processSunDropTargetEvent(SunDropTargetEvent sunDropTargetEvent) {
        ComponentPeer componentPeer;
        Object object = sunDropTargetEvent.getSource();
        if (object instanceof Component && (componentPeer = ((Component)object).getPeer()) instanceof XEmbedCanvasPeer) {
            XEmbedCanvasPeer xEmbedCanvasPeer = (XEmbedCanvasPeer)componentPeer;
            long l = this.getNativeDragContext();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("        processing " + sunDropTargetEvent + " ctxt=" + l + " consumed=" + sunDropTargetEvent.isConsumed());
            }
            if (!sunDropTargetEvent.isConsumed() && xEmbedCanvasPeer.processXEmbedDnDEvent(l, sunDropTargetEvent.getID())) {
                sunDropTargetEvent.consume();
                return true;
            }
        }
        return false;
    }

    public void forwardEventToEmbedded(long l, long l2, int n) {
        XDropTargetProtocol xDropTargetProtocol;
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        while (iterator.hasNext() && !(xDropTargetProtocol = (XDropTargetProtocol)iterator.next()).forwardEventToEmbedded(l, l2, n)) {
        }
    }

    static final class XDropTargetProtocolListenerImpl
    implements XDropTargetProtocolListener {
        private static final XDropTargetProtocolListener theInstance = new XDropTargetProtocolListenerImpl();

        private XDropTargetProtocolListenerImpl() {
        }

        static XDropTargetProtocolListener getInstance() {
            return theInstance;
        }

        public void handleDropTargetNotification(XWindow xWindow, int n, int n2, int n3, int n4, long[] lArray, long l, int n5) {
            Object object = xWindow.getTarget();
            assert (object instanceof Component);
            Component component = (Component)object;
            AppContext appContext = SunToolkit.targetToAppContext(object);
            assert (appContext != null);
            XDropTargetContextPeer xDropTargetContextPeer = XDropTargetContextPeer.getPeer(appContext);
            xDropTargetContextPeer.postDropTargetEvent(component, n, n2, n3, n4, lArray, l, n5, false);
        }
    }
}

