/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmClassesVerboseLevel;
import sun.management.snmp.jvmmib.JvmClassLoadingMBean;

public class JvmClassLoadingMeta
extends SnmpMibGroup
implements Serializable,
SnmpStandardMetaServer {
    protected JvmClassLoadingMBean node;
    protected SnmpStandardObjectServer objectserver = null;

    public JvmClassLoadingMeta(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        this.objectserver = snmpStandardObjectServer;
        try {
            this.registerObject(4L);
            this.registerObject(3L);
            this.registerObject(2L);
            this.registerObject(1L);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public SnmpValue get(long l, Object object) throws SnmpStatusException {
        switch ((int)l) {
            case 4: {
                return new SnmpInt(this.node.getJvmClassesVerboseLevel());
            }
            case 3: {
                return new SnmpCounter64(this.node.getJvmClassesUnloadedCount());
            }
            case 2: {
                return new SnmpCounter64(this.node.getJvmClassesTotalLoadedCount());
            }
            case 1: {
                return new SnmpGauge(this.node.getJvmClassesLoadedCount());
            }
        }
        throw new SnmpStatusException(225);
    }

    public SnmpValue set(SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        switch ((int)l) {
            case 4: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.setJvmClassesVerboseLevel(new EnumJvmClassesVerboseLevel(((SnmpInt)snmpValue).toInteger()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(50);
                    }
                    return new SnmpInt(this.node.getJvmClassesVerboseLevel());
                }
                throw new SnmpStatusException(90);
            }
            case 3: {
                throw new SnmpStatusException(0);
            }
            case 2: {
                throw new SnmpStatusException(0);
            }
            case 1: {
                throw new SnmpStatusException(0);
            }
        }
        throw new SnmpStatusException(0);
    }

    public void check(SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        switch ((int)l) {
            case 4: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.checkJvmClassesVerboseLevel(new EnumJvmClassesVerboseLevel(((SnmpInt)snmpValue).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(50);
                    }
                }
                throw new SnmpStatusException(90);
            }
            case 3: {
                throw new SnmpStatusException(0);
            }
            case 2: {
                throw new SnmpStatusException(0);
            }
            case 1: {
                throw new SnmpStatusException(0);
            }
            default: {
                throw new SnmpStatusException(0);
            }
        }
    }

    protected void setInstance(JvmClassLoadingMBean jvmClassLoadingMBean) {
        this.node = jvmClassLoadingMBean;
    }

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        this.objectserver.get(this, snmpMibSubRequest, n);
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        this.objectserver.set(this, snmpMibSubRequest, n);
    }

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        this.objectserver.check(this, snmpMibSubRequest, n);
    }

    public boolean isVariable(long l) {
        switch ((int)l) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isReadable(long l) {
        switch ((int)l) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean skipVariable(long l, Object object, int n) {
        switch ((int)l) {
            case 2: 
            case 3: {
                if (n != 330) break;
                return true;
            }
        }
        return super.skipVariable(l, object, n);
    }

    public String getAttributeName(long l) throws SnmpStatusException {
        switch ((int)l) {
            case 4: {
                return "JvmClassesVerboseLevel";
            }
            case 3: {
                return "JvmClassesUnloadedCount";
            }
            case 2: {
                return "JvmClassesTotalLoadedCount";
            }
            case 1: {
                return "JvmClassesLoadedCount";
            }
        }
        throw new SnmpStatusException(225);
    }

    public boolean isTable(long l) {
        switch ((int)l) {
            default: 
        }
        return false;
    }

    public SnmpMibTable getTable(long l) {
        return null;
    }

    public void registerTableNodes(SnmpMib snmpMib, MBeanServer mBeanServer) {
    }
}

