/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JAnnotationWriter;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JClassContainer;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDeclaration;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JGenerable;
import com.sun.codemodel.internal.JResourceFile;
import com.sun.codemodel.internal.TypedAnnotationWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPackage
implements JDeclaration,
JGenerable,
JClassContainer,
JAnnotatable,
Comparable<JPackage> {
    private String name;
    private final JCodeModel owner;
    private final Map<String, JDefinedClass> classes = new TreeMap<String, JDefinedClass>();
    private final Set<JResourceFile> resources = new HashSet<JResourceFile>();
    private final Map<String, JDefinedClass> upperCaseClassMap;
    private List<JAnnotationUse> annotations = null;
    private JDocComment jdoc = null;

    JPackage(String string, JCodeModel jCodeModel) {
        this.owner = jCodeModel;
        if (string.equals(".")) {
            String string2 = "JPackage name . is not allowed";
            throw new IllegalArgumentException(string2);
        }
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                ++n;
                continue;
            }
            if (n > 1) {
                String string3 = "JPackage name " + string + " missing identifier";
                throw new IllegalArgumentException(string3);
            }
            if (n == 1 && !Character.isJavaIdentifierStart(c)) {
                String string4 = "JPackage name " + string + " contains illegal " + "character for beginning of identifier: " + c;
                throw new IllegalArgumentException(string4);
            }
            if (!Character.isJavaIdentifierPart(c)) {
                String string5 = "JPackage name " + string + "contains illegal " + "character: " + c;
                throw new IllegalArgumentException(string5);
            }
            n = 0;
        }
        if (!string.trim().equals("") && n != 0) {
            String string6 = "JPackage name not allowed to end with .";
            throw new IllegalArgumentException(string6);
        }
        this.upperCaseClassMap = JCodeModel.isCaseSensitiveFileSystem ? null : new HashMap<String, JDefinedClass>();
        this.name = string;
    }

    @Override
    public JClassContainer parentContainer() {
        return this.parent();
    }

    public JPackage parent() {
        if (this.name.length() == 0) {
            return null;
        }
        int n = this.name.lastIndexOf(46);
        return this.owner._package(this.name.substring(0, n));
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    public JPackage getPackage() {
        return this;
    }

    @Override
    public JDefinedClass _class(int n, String string) throws JClassAlreadyExistsException {
        return this._class(n, string, ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int n, String string, boolean bl) throws JClassAlreadyExistsException {
        return this._class(n, string, bl ? ClassType.INTERFACE : ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int n, String string, ClassType classType) throws JClassAlreadyExistsException {
        if (this.classes.containsKey(string)) {
            throw new JClassAlreadyExistsException(this.classes.get(string));
        }
        JDefinedClass jDefinedClass = new JDefinedClass(this, n, string, classType);
        if (this.upperCaseClassMap != null) {
            JDefinedClass jDefinedClass2 = this.upperCaseClassMap.get(string.toUpperCase());
            if (jDefinedClass2 != null) {
                throw new JClassAlreadyExistsException(jDefinedClass2);
            }
            this.upperCaseClassMap.put(string.toUpperCase(), jDefinedClass);
        }
        this.classes.put(string, jDefinedClass);
        return jDefinedClass;
    }

    @Override
    public JDefinedClass _class(String string) throws JClassAlreadyExistsException {
        return this._class(1, string);
    }

    public JDefinedClass _getClass(String string) {
        if (this.classes.containsKey(string)) {
            return this.classes.get(string);
        }
        return null;
    }

    @Override
    public int compareTo(JPackage jPackage) {
        return this.name.compareTo(jPackage.name);
    }

    @Override
    public JDefinedClass _interface(int n, String string) throws JClassAlreadyExistsException {
        return this._class(n, string, ClassType.INTERFACE);
    }

    @Override
    public JDefinedClass _interface(String string) throws JClassAlreadyExistsException {
        return this._interface(1, string);
    }

    @Override
    public JDefinedClass _annotationTypeDeclaration(String string) throws JClassAlreadyExistsException {
        return this._class(1, string, ClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public JDefinedClass _enum(String string) throws JClassAlreadyExistsException {
        return this._class(1, string, ClassType.ENUM);
    }

    public JResourceFile addResourceFile(JResourceFile jResourceFile) {
        this.resources.add(jResourceFile);
        return jResourceFile;
    }

    public boolean hasResourceFile(String string) {
        for (JResourceFile jResourceFile : this.resources) {
            if (!jResourceFile.name().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Iterator propertyFiles() {
        return this.resources.iterator();
    }

    public JDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new JDocComment(this.owner());
        }
        return this.jdoc;
    }

    public void remove(JClass jClass) {
        if (jClass._package() != this) {
            throw new IllegalArgumentException("the specified class is not a member of this package, or it is a referenced class");
        }
        this.classes.remove(jClass.name());
        if (this.upperCaseClassMap != null) {
            this.upperCaseClassMap.remove(jClass.name().toUpperCase());
        }
    }

    public JClass ref(String string) throws ClassNotFoundException {
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("JClass name contains '.': " + string);
        }
        String string2 = "";
        if (!this.isUnnamed()) {
            string2 = this.name + '.';
        }
        string2 = string2 + string;
        return this.owner.ref(Class.forName(string2));
    }

    public JPackage subPackage(String string) {
        if (this.isUnnamed()) {
            return this.owner()._package(string);
        }
        return this.owner()._package(this.name + '.' + string);
    }

    @Override
    public Iterator<JDefinedClass> classes() {
        return this.classes.values().iterator();
    }

    public boolean isDefined(String string) {
        Iterator<JDefinedClass> iterator = this.classes();
        while (iterator.hasNext()) {
            if (!((JClass)iterator.next()).name().equals(string)) continue;
            return true;
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.name.length() == 0;
    }

    public String name() {
        return this.name;
    }

    @Override
    public final JCodeModel owner() {
        return this.owner;
    }

    @Override
    public JAnnotationUse annotate(JClass jClass) {
        if (this.isUnnamed()) {
            throw new IllegalArgumentException("the root package cannot be annotated");
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(jClass);
        this.annotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public <W extends JAnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    File toPath(File file) {
        if (this.name == null) {
            return file;
        }
        return new File(file, this.name.replace('.', File.separatorChar));
    }

    @Override
    public void declare(JFormatter jFormatter) {
        if (this.name.length() != 0) {
            jFormatter.p("package").p(this.name).p(';').nl();
        }
    }

    @Override
    public void generate(JFormatter jFormatter) {
        jFormatter.p(this.name);
    }

    void build(CodeWriter codeWriter, CodeWriter codeWriter2) throws IOException {
        for (JDefinedClass object2 : this.classes.values()) {
            if (object2.isHidden()) continue;
            JFormatter jFormatter = this.createJavaSourceFileWriter(codeWriter, object2.name());
            jFormatter.write(object2);
            jFormatter.close();
        }
        if (this.annotations != null || this.jdoc != null) {
            Iterator<JResourceFile> iterator = this.createJavaSourceFileWriter(codeWriter, "package-info");
            if (this.jdoc != null) {
                ((JFormatter)((Object)iterator)).g(this.jdoc);
            }
            if (this.annotations != null) {
                for (JAnnotationUse jAnnotationUse : this.annotations) {
                    ((JFormatter)((Object)iterator)).g(jAnnotationUse).nl();
                }
            }
            ((JFormatter)((Object)iterator)).d(this);
            ((JFormatter)((Object)iterator)).close();
        }
        for (JResourceFile jResourceFile : this.resources) {
            CodeWriter codeWriter3 = jResourceFile.isResource() ? codeWriter2 : codeWriter;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(codeWriter3.openBinary(this, jResourceFile.name()));
            jResourceFile.build(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    int countArtifacts() {
        int n = 0;
        for (JDefinedClass jDefinedClass : this.classes.values()) {
            if (jDefinedClass.isHidden()) continue;
            ++n;
        }
        if (this.annotations != null || this.jdoc != null) {
            ++n;
        }
        return n += this.resources.size();
    }

    private JFormatter createJavaSourceFileWriter(CodeWriter codeWriter, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(codeWriter.openSource(this, string + ".java"));
        return new JFormatter(new PrintWriter(bufferedWriter));
    }
}

