/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    protected Type() {
    }

    protected static void append(StringBuilder stringBuilder, String string, List<? extends Type> list, String string2) {
        stringBuilder.append(string);
        String string3 = "";
        for (Type type : list) {
            stringBuilder.append(string3);
            stringBuilder.append(type);
            string3 = ", ";
        }
        stringBuilder.append(string2);
    }

    protected static void appendIfNotEmpty(StringBuilder stringBuilder, String string, List<? extends Type> list, String string2) {
        if (list != null && list.size() > 0) {
            Type.append(stringBuilder, string, list, string2);
        }
    }

    public static class WildcardType
    extends Type {
        public final String kind;
        public final Type boundType;

        public WildcardType() {
            this(null, null);
        }

        public WildcardType(String string, Type type) {
            this.kind = string;
            this.boundType = type;
        }

        public String toString() {
            if (this.kind == null) {
                return "?";
            }
            return "? " + this.kind + " " + this.boundType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeArgType
    extends Type {
        public final String name;
        public final Type classBound;
        public final List<Type> interfaceBounds;

        public TypeArgType(String string, Type type, List<Type> list) {
            this.name = string;
            this.classBound = type;
            this.interfaceBounds = list;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            String string = " extends ";
            if (this.classBound != null) {
                stringBuilder.append(string);
                stringBuilder.append(this.classBound);
                string = " & ";
            }
            if (this.interfaceBounds != null) {
                for (Type type : this.interfaceBounds) {
                    stringBuilder.append(string);
                    stringBuilder.append(type);
                    string = " & ";
                }
            }
            return stringBuilder.toString();
        }
    }

    public static class InnerClassType
    extends Type {
        public final Type outerType;
        public final Type innerType;

        public InnerClassType(Type type, Type type2) {
            this.outerType = type;
            this.innerType = type2;
        }

        public String toString() {
            return this.outerType + "." + this.innerType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type {
        public final String name;
        public final List<Type> typeArgs;

        public ClassType(String string, List<Type> list) {
            this.name = string;
            this.typeArgs = list;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            ClassType.appendIfNotEmpty(stringBuilder, "<", this.typeArgs, ">");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSigType
    extends Type {
        public final List<Type> typeArgTypes;
        public final Type superclassType;
        public final List<Type> superinterfaceTypes;

        public ClassSigType(List<Type> list, Type type, List<Type> list2) {
            this.typeArgTypes = list;
            this.superclassType = type;
            this.superinterfaceTypes = list2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            ClassSigType.appendIfNotEmpty(stringBuilder, "<", this.typeArgTypes, ">");
            if (this.superclassType != null) {
                stringBuilder.append(" extends ");
                stringBuilder.append(this.superclassType);
            }
            ClassSigType.appendIfNotEmpty(stringBuilder, " implements ", this.superinterfaceTypes, "");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    extends Type {
        public final List<? extends Type> typeArgTypes;
        public final List<? extends Type> argTypes;
        public final Type returnType;
        public final List<? extends Type> throwsTypes;

        public MethodType(List<? extends Type> list, Type type) {
            this(null, list, type, null);
        }

        public MethodType(List<? extends Type> list, List<? extends Type> list2, Type type, List<? extends Type> list3) {
            this.typeArgTypes = list;
            this.argTypes = list2;
            this.returnType = type;
            this.throwsTypes = list3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            MethodType.appendIfNotEmpty(stringBuilder, "<", this.typeArgTypes, "> ");
            stringBuilder.append(this.returnType);
            MethodType.append(stringBuilder, " (", this.argTypes, ")");
            MethodType.appendIfNotEmpty(stringBuilder, " throws ", this.throwsTypes, "");
            return stringBuilder.toString();
        }
    }

    public static class ArrayType
    extends Type {
        public final Type elemType;

        public ArrayType(Type type) {
            this.elemType = type;
        }

        public String toString() {
            return this.elemType + "[]";
        }
    }

    public static class SimpleType
    extends Type {
        public final String name;

        public SimpleType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

