/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.internal.jxc.NGCCRuntimeEx;
import com.sun.tools.internal.jxc.gen.config.Config;
import com.sun.tools.internal.jxc.gen.config.NGCCRuntime;
import com.sun.tools.internal.jxc.gen.config.Schema;
import com.sun.tools.internal.xjc.SchemaCache;
import com.sun.tools.internal.xjc.api.Reference;
import com.sun.tools.internal.xjc.util.ForkContentHandler;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigReader {
    private final Set<Reference> classesToBeIncluded = new HashSet<Reference>();
    private final SchemaOutputResolver schemaOutputResolver;
    private final AnnotationProcessorEnvironment env;
    private static SchemaCache configSchema = new SchemaCache(Config.class.getResource("config.xsd"));

    public ConfigReader(AnnotationProcessorEnvironment annotationProcessorEnvironment, Collection<? extends TypeDeclaration> collection, File file, ErrorHandler errorHandler) throws SAXException, IOException {
        this.env = annotationProcessorEnvironment;
        Config config = this.parseAndGetConfig(file, errorHandler);
        this.checkAllClasses(config, collection);
        String string = file.getAbsolutePath();
        String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
        this.schemaOutputResolver = this.createSchemaOutputResolver(config, string2);
    }

    public Collection<Reference> getClassesToBeIncluded() {
        return this.classesToBeIncluded;
    }

    private void checkAllClasses(Config config, Collection<? extends TypeDeclaration> collection) {
        List list = config.getClasses().getIncludes();
        List list2 = config.getClasses().getExcludes();
        block0: for (TypeDeclaration typeDeclaration : collection) {
            boolean bl;
            String string = typeDeclaration.getQualifiedName();
            for (Pattern pattern : list2) {
                bl = this.checkPatternMatch(string, pattern);
                if (!bl) continue;
                continue block0;
            }
            for (Pattern pattern : list) {
                bl = this.checkPatternMatch(string, pattern);
                if (!bl) continue;
                this.classesToBeIncluded.add(new Reference(typeDeclaration, this.env));
                continue block0;
            }
        }
    }

    public SchemaOutputResolver getSchemaOutputResolver() {
        return this.schemaOutputResolver;
    }

    private SchemaOutputResolver createSchemaOutputResolver(Config config, String string) {
        File file = new File(string, config.getBaseDir().getPath());
        SchemaOutputResolverImpl schemaOutputResolverImpl = new SchemaOutputResolverImpl(file);
        for (Schema schema : config.getSchema()) {
            String string2 = schema.getNamespace();
            File file2 = schema.getLocation();
            schemaOutputResolverImpl.addSchemaInfo(string2, file2);
        }
        return schemaOutputResolverImpl;
    }

    private boolean checkPatternMatch(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private Config parseAndGetConfig(File file, ErrorHandler errorHandler) throws SAXException, IOException {
        XMLReader xMLReader;
        Object object;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error(parserConfigurationException);
        }
        object = new NGCCRuntimeEx(errorHandler);
        ValidatorHandler validatorHandler = configSchema.newValidator();
        validatorHandler.setErrorHandler(errorHandler);
        xMLReader.setContentHandler(new ForkContentHandler(validatorHandler, (ContentHandler)object));
        xMLReader.setErrorHandler(errorHandler);
        Config config = new Config((NGCCRuntimeEx)object);
        ((NGCCRuntime)object).setRootHandler(config);
        xMLReader.parse(new InputSource(file.toURL().toExternalForm()));
        ((NGCCRuntime)object).reset();
        return config;
    }

    private static final class SchemaOutputResolverImpl
    extends SchemaOutputResolver {
        private final File baseDir;
        private final Map<String, File> schemas = new HashMap<String, File>();

        public Result createOutput(String string, String string2) {
            if (this.schemas.containsKey(string)) {
                File file = this.schemas.get(string);
                if (file == null) {
                    return null;
                }
                file.getParentFile().mkdirs();
                return new StreamResult(file);
            }
            File file = new File(this.baseDir, string2);
            return new StreamResult(file);
        }

        public SchemaOutputResolverImpl(File file) {
            assert (file != null);
            this.baseDir = file;
        }

        public void addSchemaInfo(String string, File file) {
            if (string == null) {
                string = "";
            }
            this.schemas.put(string, file);
        }
    }
}

