/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.config.parser;

import com.sun.tools.internal.ws.processor.config.Configuration;
import com.sun.tools.internal.ws.processor.config.WSDLModelInfo;
import com.sun.tools.internal.ws.processor.config.parser.InputParser;
import com.sun.tools.internal.ws.processor.config.parser.JAXWSBindingInfoParser;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationParser
extends InputParser {
    private WSDLModelInfo wsdlModelInfo;
    private JAXWSBindingInfoParser modelInfoParser;
    private Set<InputSource> jaxwsBindings = new HashSet<InputSource>();
    private Set<InputSource> jaxbBindings = new HashSet<InputSource>();
    private EntityResolver entityResolver;

    public CustomizationParser(EntityResolver entityResolver, ProcessorEnvironment processorEnvironment, Properties properties) {
        super(processorEnvironment, properties);
        this.entityResolver = entityResolver;
    }

    @Override
    protected Configuration parse(List<String> list) throws Exception {
        Configuration configuration = new Configuration(this.getEnv());
        this.wsdlModelInfo = new WSDLModelInfo();
        this.wsdlModelInfo.setLocation(list.get(0));
        if (this._options.get("wsdllocation") == null) {
            this._options.setProperty("wsdllocation", list.get(0));
        }
        this.modelInfoParser = new JAXWSBindingInfoParser(this.getEnv());
        Set set = (Set)this._options.get("bindingFiles");
        for (String object : set) {
            this.addBinding(object);
        }
        for (InputSource inputSource : this.jaxwsBindings) {
            Document document = this.modelInfoParser.parse(inputSource);
            if (document == null) continue;
            this.wsdlModelInfo.putJAXWSBindings(inputSource.getSystemId(), document);
        }
        for (InputSource inputSource : this.jaxbBindings) {
            this.wsdlModelInfo.addJAXBBIndings(inputSource);
        }
        this.addHandlerChainInfo();
        configuration.setModelInfo(this.wsdlModelInfo);
        return configuration;
    }

    private void addBinding(String string) throws Exception {
        JAXWSUtils.checkAbsoluteness((String)string);
        InputSource inputSource = null;
        if (this.entityResolver != null) {
            inputSource = this.entityResolver.resolveEntity(null, string);
        }
        if (inputSource == null) {
            inputSource = new InputSource(string);
        }
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.createFreshXMLStreamReader(inputSource, (boolean)true);
        XMLStreamReaderUtil.nextElementContent((XMLStreamReader)xMLStreamReader);
        if (xMLStreamReader.getName().equals(JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            this.jaxwsBindings.add(inputSource);
        } else if (xMLStreamReader.getName().equals(JAXWSBindingsConstants.JAXB_BINDINGS)) {
            this.jaxbBindings.add(inputSource);
        } else {
            this.warn("configuration.notBindingFile");
        }
    }

    private void addHandlerChainInfo() throws Exception {
        for (Map.Entry<String, Document> entry : this.wsdlModelInfo.getJAXWSBindings().entrySet()) {
            Element element = entry.getValue().getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chains");
            if (nodeList.getLength() == 0) continue;
            Element element2 = (Element)nodeList.item(0);
            this.wsdlModelInfo.setHandlerConfig(element2);
            return;
        }
    }
}

