/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.parse.xml;

import com.sun.xml.internal.rngom.ast.builder.BuildException;
import com.sun.xml.internal.rngom.ast.builder.IncludedGrammar;
import com.sun.xml.internal.rngom.ast.builder.SchemaBuilder;
import com.sun.xml.internal.rngom.ast.builder.Scope;
import com.sun.xml.internal.rngom.ast.om.ParsedPattern;
import com.sun.xml.internal.rngom.parse.IllegalSchemaException;
import com.sun.xml.internal.rngom.parse.Parseable;
import com.sun.xml.internal.rngom.parse.xml.SchemaParser;
import com.sun.xml.internal.rngom.xml.sax.JAXPXMLReaderCreator;
import com.sun.xml.internal.rngom.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXParseable
implements Parseable {
    private final InputSource in;
    final XMLReaderCreator xrc;
    final ErrorHandler eh;

    public SAXParseable(InputSource inputSource, ErrorHandler errorHandler, XMLReaderCreator xMLReaderCreator) {
        this.xrc = xMLReaderCreator;
        this.eh = errorHandler;
        this.in = inputSource;
    }

    public SAXParseable(InputSource inputSource, ErrorHandler errorHandler) {
        this(inputSource, errorHandler, new JAXPXMLReaderCreator());
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(this, xMLReader, this.eh, schemaBuilder, null, null, "");
            xMLReader.parse(this.in);
            ParsedPattern parsedPattern = schemaParser.getParsedPattern();
            return schemaBuilder.expandPattern(parsedPattern);
        }
        catch (SAXException sAXException) {
            throw SAXParseable.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public ParsedPattern parseInclude(String string, SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar, String string2) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(this, xMLReader, this.eh, schemaBuilder, includedGrammar, includedGrammar, string2);
            xMLReader.parse(SAXParseable.makeInputSource(xMLReader, string));
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw SAXParseable.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public ParsedPattern parseExternal(String string, SchemaBuilder schemaBuilder, Scope scope, String string2) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(this, xMLReader, this.eh, schemaBuilder, null, scope, string2);
            xMLReader.parse(SAXParseable.makeInputSource(xMLReader, string));
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw SAXParseable.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private static InputSource makeInputSource(XMLReader xMLReader, String string) throws IOException, SAXException {
        InputSource inputSource;
        EntityResolver entityResolver = xMLReader.getEntityResolver();
        if (entityResolver != null && (inputSource = entityResolver.resolveEntity(null, string)) != null) {
            return inputSource;
        }
        return new InputSource(string);
    }

    static BuildException toBuildException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception instanceof BuildException) {
            throw (BuildException)exception;
        }
        throw new BuildException(sAXException);
    }
}

