/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.sun.jarsigner.ContentSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import sun.security.tools.JarBASE64Encoder;
import sun.security.tools.JarSignerParameters;
import sun.security.tools.TimestampedSigner;
import sun.security.util.ManifestDigester;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

class SignatureFile {
    Manifest sf;
    String baseName;

    public SignatureFile(MessageDigest[] messageDigestArray, Manifest manifest, ManifestDigester manifestDigester, String string, boolean bl) {
        ManifestDigester.Entry entry;
        this.baseName = string;
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("java.vendor");
        this.sf = new Manifest();
        Attributes attributes = this.sf.getMainAttributes();
        JarBASE64Encoder jarBASE64Encoder = new JarBASE64Encoder();
        attributes.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
        attributes.putValue("Created-By", string2 + " (" + string3 + ")");
        if (bl) {
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest-Manifest", jarBASE64Encoder.encode(manifestDigester.manifestDigest(messageDigestArray[i])));
            }
        }
        if ((entry = manifestDigester.get("Manifest-Main-Attributes", false)) != null) {
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest-" + "Manifest-Main-Attributes", jarBASE64Encoder.encode(entry.digest(messageDigestArray[i])));
            }
        } else {
            throw new IllegalStateException("ManifestDigester failed to create Manifest-Main-Attribute entry");
        }
        Map<String, Attributes> map = this.sf.getEntries();
        for (Map.Entry<String, Attributes> entry2 : manifest.getEntries().entrySet()) {
            String string4 = entry2.getKey();
            entry = manifestDigester.get(string4, false);
            if (entry == null) continue;
            Attributes attributes2 = new Attributes();
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes2.putValue(messageDigestArray[i].getAlgorithm() + "-Digest", jarBASE64Encoder.encode(entry.digest(messageDigestArray[i])));
            }
            map.put(string4, attributes2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.sf.write(outputStream);
    }

    public String getMetaName() {
        return "META-INF/" + this.baseName + ".SF";
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Block generateBlock(PrivateKey privateKey, String string, X509Certificate[] x509CertificateArray, boolean bl, String string2, X509Certificate x509Certificate, ContentSigner contentSigner, String[] stringArray, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
        return new Block(this, privateKey, string, x509CertificateArray, bl, string2, x509Certificate, contentSigner, stringArray, zipFile);
    }

    public static class Block {
        private byte[] block;
        private String blockFileName;

        Block(SignatureFile signatureFile, PrivateKey privateKey, String string, X509Certificate[] x509CertificateArray, boolean bl, String string2, X509Certificate x509Certificate, ContentSigner contentSigner, String[] stringArray, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
            String string3;
            Object object;
            Principal principal = x509CertificateArray[0].getIssuerDN();
            if (!(principal instanceof X500Name)) {
                object = new X509CertInfo(x509CertificateArray[0].getTBSCertificate());
                principal = (Principal)object.get("issuer.dname");
            }
            object = x509CertificateArray[0].getSerialNumber();
            String string4 = privateKey.getAlgorithm();
            if (string == null) {
                String string5;
                if (string4.equalsIgnoreCase("DSA")) {
                    string5 = "SHA1";
                } else if (string4.equalsIgnoreCase("RSA")) {
                    string5 = "SHA1";
                } else {
                    throw new RuntimeException("private key is not a DSA or RSA key");
                }
                string3 = string5 + "with" + string4;
            } else {
                string3 = string;
            }
            String string6 = string3.toUpperCase();
            if (string6.endsWith("WITHRSA") && !string4.equalsIgnoreCase("RSA") || string6.endsWith("WITHDSA") && !string4.equalsIgnoreCase("DSA")) {
                throw new SignatureException("private key algorithm is not compatible with signature algorithm");
            }
            this.blockFileName = "META-INF/" + signatureFile.getBaseName() + "." + string4;
            AlgorithmId algorithmId = AlgorithmId.get(string3);
            AlgorithmId algorithmId2 = AlgorithmId.get(string4);
            Signature signature = Signature.getInstance(string3);
            signature.initSign(privateKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            signatureFile.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            if (contentSigner == null) {
                contentSigner = new TimestampedSigner();
            }
            URI uRI = null;
            try {
                if (string2 != null) {
                    uRI = new URI(string2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException();
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
            JarSignerParameters jarSignerParameters = new JarSignerParameters(stringArray, uRI, x509Certificate, byArray2, string3, x509CertificateArray, byArray, zipFile);
            this.block = contentSigner.generateSignedData(jarSignerParameters, bl, string2 != null || x509Certificate != null);
        }

        public String getMetaName() {
            return this.blockFileName;
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this.block);
        }
    }
}

