/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.soap;

import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.message.FaultCode;
import com.sun.xml.internal.ws.encoding.soap.message.FaultCodeEnum;
import com.sun.xml.internal.ws.encoding.soap.message.FaultReason;
import com.sun.xml.internal.ws.encoding.soap.message.FaultReasonText;
import com.sun.xml.internal.ws.encoding.soap.message.FaultSubcode;
import com.sun.xml.internal.ws.encoding.soap.message.SOAP12FaultInfo;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.model.CheckedException;
import com.sun.xml.internal.ws.model.JavaMethod;
import com.sun.xml.internal.ws.model.Mode;
import com.sun.xml.internal.ws.model.Parameter;
import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPRuntimeModel
extends RuntimeModel {
    @Override
    protected void createDecoderInfo() {
        Collection<JavaMethod> collection = this.getJavaMethods();
        for (JavaMethod javaMethod : collection) {
            if (javaMethod.isAsync()) continue;
            SOAPBinding sOAPBinding = (SOAPBinding)javaMethod.getBinding();
            this.setDecoderInfo(javaMethod.getRequestParameters(), sOAPBinding, Mode.IN);
            this.setDecoderInfo(javaMethod.getResponseParameters(), sOAPBinding, Mode.OUT);
            for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
                JAXBBridgeInfo jAXBBridgeInfo = new JAXBBridgeInfo(this.getBridge(checkedException.getDetailType()));
                this.addDecoderInfo(checkedException.getDetailType().tagName, jAXBBridgeInfo);
            }
        }
    }

    private void setDecoderInfo(List<Parameter> list, SOAPBinding sOAPBinding, Mode mode) {
        for (Parameter parameter : list) {
            Object object;
            ParameterBinding parameterBinding;
            ParameterBinding parameterBinding2 = parameterBinding = mode == Mode.IN ? parameter.getInBinding() : parameter.getOutBinding();
            if (parameterBinding.isBody() && sOAPBinding.isRpcLit()) {
                object = new RpcLitPayload(parameter.getName());
                WrapperParameter wrapperParameter = (WrapperParameter)parameter;
                for (Parameter parameter2 : wrapperParameter.getWrapperChildren()) {
                    if (parameter2.getBinding().isUnbound()) continue;
                    JAXBBridgeInfo jAXBBridgeInfo = new JAXBBridgeInfo(this.getBridge(parameter2.getTypeReference()), null);
                    ((RpcLitPayload)object).addParameter(jAXBBridgeInfo);
                }
                this.addDecoderInfo(parameter.getName(), object);
                continue;
            }
            object = new JAXBBridgeInfo(this.getBridge(parameter.getTypeReference()), null);
            this.addDecoderInfo(parameter.getName(), object);
        }
    }

    @Override
    protected void populateMaps() {
        int n = 0;
        for (JavaMethod javaMethod : this.getJavaMethods()) {
            this.put(javaMethod.getMethod(), javaMethod);
            boolean bl = false;
            for (Parameter parameter : javaMethod.getRequestParameters()) {
                ParameterBinding parameterBinding = parameter.getBinding();
                if (!parameterBinding.isBody()) continue;
                this.put(parameter.getName(), javaMethod);
                bl = true;
            }
            if (bl) continue;
            this.put(this.emptyBodyName, javaMethod);
            ++n;
        }
        if (n > 1) {
            // empty if block
        }
    }

    @Override
    protected void fillTypes(JavaMethod javaMethod, List<TypeReference> list) {
        if (!(javaMethod.getBinding() instanceof SOAPBinding)) {
            System.out.println("Error: Wrong Binding!");
            return;
        }
        if (((SOAPBinding)javaMethod.getBinding()).isDocLit()) {
            super.fillTypes(javaMethod, list);
            return;
        }
        this.addTypes(javaMethod.getRequestParameters(), list, Mode.IN);
        this.addTypes(javaMethod.getResponseParameters(), list, Mode.OUT);
    }

    private void addTypes(List<Parameter> list, List<TypeReference> list2, Mode mode) {
        for (Parameter parameter : list) {
            ParameterBinding parameterBinding;
            ParameterBinding parameterBinding2 = parameterBinding = mode == Mode.IN ? parameter.getInBinding() : parameter.getOutBinding();
            if (!parameter.isWrapperStyle()) {
                list2.add(parameter.getTypeReference());
                continue;
            }
            if (!parameterBinding.isBody()) continue;
            List<Parameter> list3 = ((WrapperParameter)parameter).getWrapperChildren();
            for (Parameter parameter2 : list3) {
                list2.add(parameter2.getTypeReference());
            }
        }
    }

    public Set<QName> getKnownHeaders() {
        HashSet<QName> hashSet = new HashSet<QName>();
        for (JavaMethod javaMethod : this.getJavaMethods()) {
            Iterator<Parameter> iterator = javaMethod.getRequestParameters().iterator();
            this.fillHeaders(iterator, hashSet, Mode.IN);
            iterator = javaMethod.getResponseParameters().iterator();
            this.fillHeaders(iterator, hashSet, Mode.OUT);
        }
        return hashSet;
    }

    private void fillHeaders(Iterator<Parameter> iterator, Set<QName> set, Mode mode) {
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            ParameterBinding parameterBinding = mode == Mode.IN ? parameter.getInBinding() : parameter.getOutBinding();
            QName qName = parameter.getName();
            if (!parameterBinding.isHeader() || set.contains(qName)) continue;
            set.add(qName);
        }
    }

    public static InternalMessage createFaultInBody(Object object, String string, Object object2, InternalMessage internalMessage) {
        Object object3;
        SOAPFaultInfo sOAPFaultInfo;
        if (object instanceof SOAPFaultInfo) {
            sOAPFaultInfo = (SOAPFaultInfo)object;
        } else if (object instanceof ServerRtException) {
            object3 = ((ServerRtException)object).getCause();
            Object object4 = object3 == null ? (ServerRtException)object : object3;
            sOAPFaultInfo = SOAPRuntimeModel.createSOAPFaultInfo((Throwable)object4, string, object2);
        } else if (object instanceof SOAPFaultException) {
            object3 = (SOAPFaultException)object;
            sOAPFaultInfo = new SOAPFaultInfo(((SOAPFaultException)object3).getFault());
        } else if (object instanceof SOAPVersionMismatchException) {
            object3 = SOAPConstants.FAULT_CODE_VERSION_MISMATCH;
            String string2 = "SOAP envelope version mismatch";
            sOAPFaultInfo = new SOAPFaultInfo(string2, (QName)object3, string, null, "http://schemas.xmlsoap.org/wsdl/soap/http");
        } else if (object instanceof Exception) {
            sOAPFaultInfo = SOAPRuntimeModel.createSOAPFaultInfo((Exception)object, string, object2);
        } else {
            object3 = SOAPConstants.FAULT_CODE_SERVER;
            String string3 = "Unknown fault type:" + object.getClass();
            sOAPFaultInfo = new SOAPFaultInfo(string3, (QName)object3, string, null, "http://schemas.xmlsoap.org/wsdl/soap/http");
        }
        if (internalMessage == null) {
            internalMessage = new InternalMessage();
        }
        if ((object3 = internalMessage.getBody()) == null) {
            object3 = new BodyBlock(sOAPFaultInfo);
            internalMessage.setBody((BodyBlock)object3);
        } else {
            ((BodyBlock)object3).setFaultInfo(sOAPFaultInfo);
        }
        return internalMessage;
    }

    public static InternalMessage createSOAP12FaultInBody(Object object, String string, String string2, Object object2, InternalMessage internalMessage) {
        Object object3;
        SOAP12FaultInfo sOAP12FaultInfo;
        if (object instanceof SOAP12FaultInfo) {
            sOAP12FaultInfo = (SOAP12FaultInfo)object;
        } else if (object instanceof ServerRtException) {
            object3 = ((ServerRtException)object).getCause();
            Object object4 = object3 == null ? (ServerRtException)object : object3;
            sOAP12FaultInfo = SOAPRuntimeModel.createSOAP12FaultInfo((Throwable)object4, string, string2, object2);
        } else if (object instanceof SOAPFaultException) {
            object3 = (SOAPFaultException)object;
            sOAP12FaultInfo = new SOAP12FaultInfo(((SOAPFaultException)object3).getFault());
        } else if (object instanceof SOAPVersionMismatchException) {
            object3 = "SOAP envelope version mismatch";
            FaultCode faultCode = new FaultCode(FaultCodeEnum.VersionMismatch, (FaultSubcode)null);
            FaultReason faultReason = new FaultReason(new FaultReasonText((String)object3, Locale.getDefault()));
            sOAP12FaultInfo = new SOAP12FaultInfo(faultCode, faultReason, null, null, null);
        } else if (object instanceof Exception) {
            sOAP12FaultInfo = SOAPRuntimeModel.createSOAP12FaultInfo((Exception)object, string, string2, object2);
        } else {
            object3 = "Unknown fault type:" + object.getClass();
            FaultCode faultCode = new FaultCode(FaultCodeEnum.Receiver, (FaultSubcode)null);
            FaultReason faultReason = new FaultReason(new FaultReasonText((String)object3, Locale.getDefault()));
            sOAP12FaultInfo = new SOAP12FaultInfo(faultCode, faultReason, null, null, null);
        }
        if (internalMessage == null) {
            internalMessage = new InternalMessage();
        }
        if ((object3 = internalMessage.getBody()) == null) {
            object3 = new BodyBlock(sOAP12FaultInfo);
            internalMessage.setBody((BodyBlock)object3);
        } else {
            ((BodyBlock)object3).setValue(sOAP12FaultInfo);
        }
        return internalMessage;
    }

    public static void addHeaders(InternalMessage internalMessage, MessageInfo messageInfo) {
        Set<HeaderBlock> set = MessageInfoUtil.getNotUnderstoodHeaders(messageInfo);
        if (set != null) {
            for (HeaderBlock headerBlock : set) {
                internalMessage.addHeader(headerBlock);
            }
        }
    }

    private static SOAP12FaultInfo createSOAP12FaultInfo(Throwable throwable, String string, String string2, Object object) {
        Object object2;
        SOAPFaultException sOAPFaultException = null;
        FaultCode faultCode = null;
        FaultReason faultReason = null;
        String string3 = null;
        String string4 = null;
        Throwable throwable2 = throwable.getCause();
        if (throwable instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable;
        } else if (throwable2 != null && throwable2 instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable.getCause();
        }
        if (sOAPFaultException != null) {
            object2 = sOAPFaultException.getFault();
            faultCode = new FaultCode(FaultCodeEnum.get(object2.getFaultCodeAsQName()), (FaultSubcode)null);
            faultReason = new FaultReason(new FaultReasonText(object2.getFaultString(), object2.getFaultStringLocale()));
            string3 = object2.getFaultRole();
            if (string3 == null) {
                string3 = string;
            }
            if ((string4 = object2.getFaultNode()) == null) {
                string4 = string2;
            }
        }
        if (faultCode == null || faultCode != null && faultCode.getValue() == null) {
            faultCode = new FaultCode(FaultCodeEnum.Receiver, (FaultSubcode)null);
        }
        if (faultReason == null) {
            object2 = throwable.getMessage();
            if (object2 == null) {
                object2 = throwable.toString();
            }
            faultReason = new FaultReason(new FaultReasonText((String)object2, Locale.getDefault()));
        }
        if (object == null && sOAPFaultException != null) {
            object = sOAPFaultException.getFault().getDetail();
        }
        return new SOAP12FaultInfo(faultCode, faultReason, string3, string4, object);
    }

    public static InternalMessage createHeaderFault(Object object, String string, JAXBBridgeInfo jAXBBridgeInfo, InternalMessage internalMessage) {
        internalMessage = SOAPRuntimeModel.createFaultInBody(object, string, null, internalMessage);
        HeaderBlock headerBlock = new HeaderBlock(jAXBBridgeInfo);
        internalMessage.addHeader(headerBlock);
        return internalMessage;
    }

    private static SOAPFaultInfo createSOAPFaultInfo(Throwable throwable, String string, Object object) {
        SOAPFaultException sOAPFaultException = null;
        QName qName = null;
        String string2 = null;
        String string3 = null;
        Throwable throwable2 = throwable.getCause();
        if (throwable instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable;
        } else if (throwable2 != null && throwable2 instanceof SOAPFaultException) {
            sOAPFaultException = (SOAPFaultException)throwable.getCause();
        }
        if (sOAPFaultException != null) {
            qName = sOAPFaultException.getFault().getFaultCodeAsQName();
            string2 = sOAPFaultException.getFault().getFaultString();
            string3 = sOAPFaultException.getFault().getFaultActor();
        }
        if (qName == null) {
            qName = SOAPConstants.FAULT_CODE_SERVER;
        }
        if (string2 == null && (string2 = throwable.getMessage()) == null) {
            string2 = throwable.toString();
        }
        if (string3 == null) {
            string3 = string;
        }
        if (object == null && sOAPFaultException != null) {
            object = sOAPFaultException.getFault().getDetail();
        }
        return new SOAPFaultInfo(string2, qName, string3, object, "http://schemas.xmlsoap.org/wsdl/soap/http");
    }
}

