/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.ParameterDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodDescriptor
extends FeatureDescriptor {
    private Reference<Method> methodRef;
    private String[] paramNames;
    private List params;
    private ParameterDescriptor[] parameterDescriptors;

    public MethodDescriptor(Method method) {
        this(method, null);
    }

    public MethodDescriptor(Method method, ParameterDescriptor[] parameterDescriptorArray) {
        this.setName(method.getName());
        this.setMethod(method);
        this.parameterDescriptors = parameterDescriptorArray;
    }

    public synchronized Method getMethod() {
        Class clazz;
        Method method = this.getMethod0();
        if (method == null && (clazz = this.getClass0()) != null) {
            Class[] classArray = this.getParams();
            if (classArray == null) {
                for (int i = 0; i < 3 && (method = Introspector.findMethod(clazz, this.getName(), i, null)) == null; ++i) {
                }
            } else {
                method = Introspector.findMethod(clazz, this.getName(), classArray.length, classArray);
            }
            this.setMethod(method);
        }
        return method;
    }

    private synchronized void setMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.setParams(MethodDescriptor.getParameterTypes(this.getClass0(), method));
        this.methodRef = MethodDescriptor.getSoftReference(method);
    }

    private Method getMethod0() {
        return this.methodRef != null ? this.methodRef.get() : null;
    }

    private synchronized void setParams(Class[] classArray) {
        if (classArray == null) {
            return;
        }
        this.paramNames = new String[classArray.length];
        this.params = new ArrayList(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            this.paramNames[i] = classArray[i].getName();
            this.params.add(new WeakReference<Class>(classArray[i]));
        }
    }

    String[] getParamNames() {
        return this.paramNames;
    }

    private synchronized Class[] getParams() {
        Class[] classArray = new Class[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            Reference reference = (Reference)this.params.get(i);
            Class clazz = (Class)reference.get();
            if (clazz == null) {
                return null;
            }
            classArray[i] = clazz;
        }
        return classArray;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    MethodDescriptor(MethodDescriptor methodDescriptor, MethodDescriptor methodDescriptor2) {
        super(methodDescriptor, methodDescriptor2);
        this.methodRef = methodDescriptor.methodRef;
        if (methodDescriptor2.methodRef != null) {
            this.methodRef = methodDescriptor2.methodRef;
        }
        this.params = methodDescriptor.params;
        if (methodDescriptor2.params != null) {
            this.params = methodDescriptor2.params;
        }
        this.paramNames = methodDescriptor.paramNames;
        if (methodDescriptor2.paramNames != null) {
            this.paramNames = methodDescriptor2.paramNames;
        }
        this.parameterDescriptors = methodDescriptor.parameterDescriptors;
        if (methodDescriptor2.parameterDescriptors != null) {
            this.parameterDescriptors = methodDescriptor2.parameterDescriptors;
        }
    }

    MethodDescriptor(MethodDescriptor methodDescriptor) {
        super(methodDescriptor);
        this.methodRef = methodDescriptor.methodRef;
        this.params = methodDescriptor.params;
        this.paramNames = methodDescriptor.paramNames;
        if (methodDescriptor.parameterDescriptors != null) {
            int n = methodDescriptor.parameterDescriptors.length;
            this.parameterDescriptors = new ParameterDescriptor[n];
            for (int i = 0; i < n; ++i) {
                this.parameterDescriptors[i] = new ParameterDescriptor(methodDescriptor.parameterDescriptors[i]);
            }
        }
    }
}

