/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.PNGFilterInputStream;

public class PNGImageDecoder
extends ImageDecoder {
    private static final int GRAY = 0;
    private static final int PALETTE = 1;
    private static final int COLOR = 2;
    private static final int ALPHA = 4;
    private static final int bKGDChunk = 1649100612;
    private static final int cHRMChunk = 1665684045;
    private static final int gAMAChunk = 1732332865;
    private static final int hISTChunk = 1749635924;
    private static final int IDATChunk = 1229209940;
    private static final int IENDChunk = 1229278788;
    private static final int IHDRChunk = 1229472850;
    private static final int PLTEChunk = 1347179589;
    private static final int pHYsChunk = 1883789683;
    private static final int sBITChunk = 1933723988;
    private static final int tEXtChunk = 1950701684;
    private static final int tIMEChunk = 1950960965;
    private static final int tRNSChunk = 1951551059;
    private static final int zTXtChunk = 2052348020;
    private int width;
    private int height;
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int gamma = 100000;
    private Hashtable properties;
    private ColorModel cm;
    private byte[] red_map;
    private byte[] green_map;
    private byte[] blue_map;
    private byte[] alpha_map;
    private int transparentPixel = -1;
    private byte[] transparentPixel_16 = null;
    private static ColorModel[] greyModels = new ColorModel[4];
    private static final byte[] startingRow = new byte[]{0, 0, 0, 4, 0, 2, 0, 1};
    private static final byte[] startingCol = new byte[]{0, 0, 4, 0, 2, 0, 1, 0};
    private static final byte[] rowIncrement = new byte[]{1, 8, 8, 8, 4, 4, 2, 2};
    private static final byte[] colIncrement = new byte[]{1, 8, 8, 4, 4, 2, 2, 1};
    private static final byte[] blockHeight = new byte[]{1, 8, 8, 4, 4, 2, 2, 1};
    private static final byte[] blockWidth = new byte[]{1, 8, 4, 4, 2, 2, 1, 1};
    int pos;
    int limit;
    int chunkStart;
    int chunkKey;
    int chunkLength;
    int chunkCRC;
    boolean seenEOF;
    private static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    PNGFilterInputStream inputStream;
    InputStream underlyingInputStream;
    byte[] inbuf = new byte[4096];
    private static boolean checkCRC = true;
    private static final int[] crc_table = new int[256];

    private void property(String string, Object object) {
        if (object == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, object);
    }

    private void property(String string, float f) {
        this.property(string, new Float(f));
    }

    private final void pngassert(boolean bl) throws IOException {
        if (!bl) {
            PNGException pNGException = new PNGException("Broken file");
            pNGException.printStackTrace();
            throw pNGException;
        }
    }

    protected boolean handleChunk(int n, byte[] byArray, int n2, int n3) throws IOException {
        block33: {
            block0 : switch (n) {
                case 1649100612: {
                    Color color = null;
                    switch (this.colorType) {
                        case 2: 
                        case 6: {
                            this.pngassert(n3 == 6);
                            color = new Color(byArray[n2] & 0xFF, byArray[n2 + 2] & 0xFF, byArray[n2 + 4] & 0xFF);
                            break;
                        }
                        case 3: 
                        case 7: {
                            this.pngassert(n3 == 1);
                            int n4 = byArray[n2] & 0xFF;
                            this.pngassert(this.red_map != null && n4 < this.red_map.length);
                            color = new Color(this.red_map[n4] & 0xFF, this.green_map[n4] & 0xFF, this.blue_map[n4] & 0xFF);
                            break;
                        }
                        case 0: 
                        case 4: {
                            this.pngassert(n3 == 2);
                            int n5 = byArray[n2] & 0xFF;
                            color = new Color(n5, n5, n5);
                        }
                    }
                    if (color == null) break;
                    this.property("background", color);
                    break;
                }
                case 1665684045: {
                    this.property("chromaticities", new Chromaticities(this.getInt(n2), this.getInt(n2 + 4), this.getInt(n2 + 8), this.getInt(n2 + 12), this.getInt(n2 + 16), this.getInt(n2 + 20), this.getInt(n2 + 24), this.getInt(n2 + 28)));
                    break;
                }
                case 1732332865: {
                    if (n3 != 4) {
                        throw new PNGException("bogus gAMA");
                    }
                    this.gamma = this.getInt(n2);
                    if (this.gamma == 100000) break;
                    this.property("gamma", (float)this.gamma / 100000.0f);
                    break;
                }
                case 1749635924: {
                    break;
                }
                case 1229209940: {
                    return false;
                }
                case 1229278788: {
                    break;
                }
                case 1229472850: {
                    if (n3 != 13 || (this.width = this.getInt(n2)) == 0 || (this.height = this.getInt(n2 + 4)) == 0) {
                        throw new PNGException("bogus IHDR");
                    }
                    this.bitDepth = this.getByte(n2 + 8);
                    this.colorType = this.getByte(n2 + 9);
                    this.compressionMethod = this.getByte(n2 + 10);
                    this.filterMethod = this.getByte(n2 + 11);
                    this.interlaceMethod = this.getByte(n2 + 12);
                    break;
                }
                case 1347179589: {
                    int n6 = n3 / 3;
                    this.red_map = new byte[n6];
                    this.green_map = new byte[n6];
                    this.blue_map = new byte[n6];
                    int n7 = 0;
                    int n8 = n2;
                    while (n7 < n6) {
                        this.red_map[n7] = byArray[n8];
                        this.green_map[n7] = byArray[n8 + 1];
                        this.blue_map[n7] = byArray[n8 + 2];
                        ++n7;
                        n8 += 3;
                    }
                    break;
                }
                case 1883789683: {
                    break;
                }
                case 1933723988: {
                    break;
                }
                case 1950701684: {
                    int n9;
                    for (n9 = 0; n9 < n3 && byArray[n2 + n9] != 0; ++n9) {
                    }
                    if (n9 >= n3) break;
                    String string = new String(byArray, n2, n9);
                    String string2 = new String(byArray, n2 + n9 + 1, n3 - n9 - 1);
                    this.property(string, string2);
                    break;
                }
                case 1950960965: {
                    this.property("modtime", new GregorianCalendar(this.getShort(n2 + 0), this.getByte(n2 + 2) - 1, this.getByte(n2 + 3), this.getByte(n2 + 4), this.getByte(n2 + 5), this.getByte(n2 + 6)).getTime());
                    break;
                }
                case 1951551059: {
                    switch (this.colorType) {
                        case 3: 
                        case 7: {
                            int n10 = n3;
                            if (this.red_map != null) {
                                n10 = this.red_map.length;
                            }
                            this.alpha_map = new byte[n10];
                            System.arraycopy(byArray, n2, this.alpha_map, 0, n3 < n10 ? n3 : n10);
                            while (--n10 >= n3) {
                                this.alpha_map[n10] = -1;
                            }
                            break block33;
                        }
                        case 2: 
                        case 6: {
                            this.pngassert(n3 == 6);
                            if (this.bitDepth == 16) {
                                this.transparentPixel_16 = new byte[6];
                                for (int i = 0; i < 6; ++i) {
                                    this.transparentPixel_16[i] = (byte)this.getByte(n2 + i);
                                }
                                break block0;
                            }
                            this.transparentPixel = (this.getShort(n2 + 0) & 0xFF) << 16 | (this.getShort(n2 + 2) & 0xFF) << 8 | this.getShort(n2 + 4) & 0xFF;
                            break;
                        }
                        case 0: 
                        case 4: {
                            this.pngassert(n3 == 2);
                            int n11 = this.getShort(n2);
                            n11 = 0xFF & (this.bitDepth == 16 ? n11 >> 8 : n11);
                            this.transparentPixel = n11 << 16 | n11 << 8 | n11;
                        }
                    }
                    break;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void produceImage() throws IOException, ImageFormatException {
        block56: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            for (int i = 0; i < signature.length; ++i) {
                if ((signature[i] & 0xFF) == this.underlyingInputStream.read()) continue;
                throw new PNGException("Chunk signature mismatch");
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(this.inputStream, new Inflater()));
            this.getData();
            byte[] byArray = null;
            int[] nArray = null;
            int n7 = this.width;
            int n8 = 0;
            switch (this.bitDepth) {
                case 1: {
                    n8 = 0;
                    break;
                }
                case 2: {
                    n8 = 1;
                    break;
                }
                case 4: {
                    n8 = 2;
                    break;
                }
                case 8: {
                    n8 = 3;
                    break;
                }
                case 16: {
                    n8 = 4;
                    break;
                }
                default: {
                    throw new PNGException("invalid depth");
                }
            }
            if (this.interlaceMethod != 0) {
                n7 *= this.height;
                n6 = this.width;
            } else {
                n6 = 0;
            }
            int n9 = this.colorType | this.bitDepth << 3;
            int n10 = (1 << (this.bitDepth >= 8 ? 8 : this.bitDepth)) - 1;
            switch (this.colorType) {
                case 3: 
                case 7: {
                    if (this.red_map == null) {
                        throw new PNGException("palette expected");
                    }
                    this.cm = this.alpha_map == null ? new IndexColorModel(this.bitDepth, this.red_map.length, this.red_map, this.green_map, this.blue_map) : new IndexColorModel(this.bitDepth, this.red_map.length, this.red_map, this.green_map, this.blue_map, this.alpha_map);
                    byArray = new byte[n7];
                    break;
                }
                case 0: {
                    n5 = n8 >= 4 ? 3 : n8;
                    this.cm = greyModels[n5];
                    if (this.cm == null) {
                        n4 = 1 << (1 << n5);
                        byte[] byArray2 = new byte[n4];
                        for (n3 = 0; n3 < n4; ++n3) {
                            byArray2[n3] = (byte)(255 * n3 / (n4 - 1));
                        }
                        this.cm = this.transparentPixel == -1 ? new IndexColorModel(this.bitDepth, byArray2.length, byArray2, byArray2, byArray2) : new IndexColorModel(this.bitDepth, byArray2.length, byArray2, byArray2, byArray2, this.transparentPixel & 0xFF);
                        PNGImageDecoder.greyModels[n5] = this.cm;
                    }
                    byArray = new byte[n7];
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.cm = ColorModel.getRGBdefault();
                    nArray = new int[n7];
                    break;
                }
                default: {
                    throw new PNGException("invalid color type");
                }
            }
            this.setDimensions(this.width, this.height);
            this.setColorModel(this.cm);
            n5 = this.interlaceMethod != 0 ? 6 : 30;
            this.setHints(n5);
            this.headerComplete();
            n4 = (this.colorType & 1) != 0 ? 1 : ((this.colorType & 2) != 0 ? 3 : 1) + ((this.colorType & 4) != 0 ? 1 : 0);
            int n11 = n4 * this.bitDepth;
            n3 = n11 + 7 >> 3;
            if (this.interlaceMethod == 0) {
                n2 = -1;
                n = 0;
            } else {
                n2 = 0;
                n = 7;
            }
            while (++n2 <= n) {
                int n12 = startingRow[n2];
                byte by = rowIncrement[n2];
                byte by2 = colIncrement[n2];
                byte by3 = blockWidth[n2];
                byte by4 = blockHeight[n2];
                int n13 = startingCol[n2];
                int n14 = (this.width - n13 + (by2 - 1)) / by2;
                int n15 = n14 * n11 + 7 >> 3;
                if (n15 == 0) continue;
                int n16 = this.interlaceMethod == 0 ? by * this.width : 0;
                int n17 = n6 * n12;
                boolean bl = true;
                byte[] byArray3 = new byte[n15];
                byte[] byArray4 = new byte[n15];
                while (n12 < this.height) {
                    int n18;
                    int n19;
                    int n20 = ((InputStream)bufferedInputStream).read();
                    for (n18 = 0; n18 < n15; n18 += n19) {
                        n19 = ((InputStream)bufferedInputStream).read(byArray3, n18, n15 - n18);
                        if (n19 > 0) continue;
                        throw new PNGException("missing data");
                    }
                    this.filterRow(byArray3, bl ? null : byArray4, n20, n15, n3);
                    n19 = 0;
                    int n21 = 0;
                    block40: for (n18 = n13; n18 < this.width; n18 += by2) {
                        if (nArray != null) {
                            switch (n9) {
                                case 70: {
                                    nArray[n18 + n17] = (byArray3[n19] & 0xFF) << 16 | (byArray3[n19 + 1] & 0xFF) << 8 | byArray3[n19 + 2] & 0xFF | (byArray3[n19 + 3] & 0xFF) << 24;
                                    n19 += 4;
                                    break;
                                }
                                case 134: {
                                    nArray[n18 + n17] = (byArray3[n19] & 0xFF) << 16 | (byArray3[n19 + 2] & 0xFF) << 8 | byArray3[n19 + 4] & 0xFF | (byArray3[n19 + 6] & 0xFF) << 24;
                                    n19 += 8;
                                    break;
                                }
                                case 66: {
                                    n21 = (byArray3[n19] & 0xFF) << 16 | (byArray3[n19 + 1] & 0xFF) << 8 | byArray3[n19 + 2] & 0xFF;
                                    if (n21 != this.transparentPixel) {
                                        n21 |= 0xFF000000;
                                    }
                                    nArray[n18 + n17] = n21;
                                    n19 += 3;
                                    break;
                                }
                                case 130: {
                                    int n22;
                                    n21 = (byArray3[n19] & 0xFF) << 16 | (byArray3[n19 + 2] & 0xFF) << 8 | byArray3[n19 + 4] & 0xFF;
                                    boolean bl2 = this.transparentPixel_16 != null;
                                    for (n22 = 0; bl2 && n22 < 6; bl2 &= (byArray3[n19 + n22] & 0xFF) == (this.transparentPixel_16[n22] & 0xFF), ++n22) {
                                    }
                                    if (!bl2) {
                                        n21 |= 0xFF000000;
                                    }
                                    nArray[n18 + n17] = n21;
                                    n19 += 6;
                                    break;
                                }
                                case 68: {
                                    int n22 = byArray3[n19] & 0xFF;
                                    nArray[n18 + n17] = n22 << 16 | n22 << 8 | n22 | (byArray3[n19 + 1] & 0xFF) << 24;
                                    n19 += 2;
                                    break;
                                }
                                case 132: {
                                    int n22 = byArray3[n19] & 0xFF;
                                    nArray[n18 + n17] = n22 << 16 | n22 << 8 | n22 | (byArray3[n19 + 2] & 0xFF) << 24;
                                    n19 += 4;
                                    break;
                                }
                                default: {
                                    throw new PNGException("illegal type/depth");
                                }
                            }
                            continue;
                        }
                        switch (this.bitDepth) {
                            case 1: {
                                byArray[n18 + n17] = (byte)(byArray3[n19 >> 3] >> 7 - (n19 & 7) & 1);
                                ++n19;
                                continue block40;
                            }
                            case 2: {
                                byArray[n18 + n17] = (byte)(byArray3[n19 >> 2] >> (3 - (n19 & 3)) * 2 & 3);
                                ++n19;
                                continue block40;
                            }
                            case 4: {
                                byArray[n18 + n17] = (byte)(byArray3[n19 >> 1] >> (1 - (n19 & 1)) * 4 & 0xF);
                                ++n19;
                                continue block40;
                            }
                            case 8: {
                                byArray[n18 + n17] = byArray3[n19++];
                                continue block40;
                            }
                            case 16: {
                                byArray[n18 + n17] = byArray3[n19];
                                n19 += 2;
                                continue block40;
                            }
                            default: {
                                throw new PNGException("illegal type/depth");
                            }
                        }
                    }
                    if (this.interlaceMethod == 0) {
                        if (nArray != null) {
                            this.sendPixels(0, n12, this.width, 1, nArray, 0, this.width);
                        } else {
                            this.sendPixels(0, n12, this.width, 1, byArray, 0, this.width);
                        }
                    }
                    n12 += by;
                    n17 += by * n6;
                    byte[] byArray5 = byArray3;
                    byArray3 = byArray4;
                    byArray4 = byArray5;
                    bl = false;
                }
                if (this.interlaceMethod == 0) continue;
                if (nArray != null) {
                    this.sendPixels(0, 0, this.width, this.height, nArray, 0, this.width);
                    continue;
                }
                this.sendPixels(0, 0, this.width, this.height, byArray, 0, this.width);
            }
            this.imageComplete(3, true);
            Object var35_38 = null;
            try {
                this.close();
            }
            catch (Throwable throwable) {}
            break block56;
            {
                catch (IOException iOException) {
                    if (!this.aborted) {
                        this.property("error", iOException);
                        this.imageComplete(3, true);
                        throw iOException;
                    }
                    Object var35_39 = null;
                    try {
                        this.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                Object var35_40 = null;
                try {
                    this.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private boolean sendPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = this.setPixels(n, n2, n3, n4, this.cm, nArray, n5, n6);
        if (n7 <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    private boolean sendPixels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        int n7 = this.setPixels(n, n2, n3, n4, this.cm, byArray, n5, n6);
        if (n7 <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    private void filterRow(byte[] byArray, byte[] byArray2, int n, int n2, int n3) throws IOException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                int n4;
                for (n4 = n3; n4 < n2; ++n4) {
                    int n5 = n4;
                    byArray[n5] = (byte)(byArray[n5] + byArray[n4 - n3]);
                }
                break;
            }
            case 2: {
                int n4;
                if (byArray2 == null) break;
                for (n4 = 0; n4 < n2; ++n4) {
                    int n6 = n4;
                    byArray[n6] = (byte)(byArray[n6] + byArray2[n4]);
                }
                break;
            }
            case 3: {
                int n4;
                if (byArray2 != null) {
                    while (n4 < n3) {
                        int n7 = n4;
                        byArray[n7] = (byte)(byArray[n7] + ((0xFF & byArray2[n4]) >> 1));
                        ++n4;
                    }
                    while (n4 < n2) {
                        int n8 = n4;
                        byArray[n8] = (byte)(byArray[n8] + ((byArray2[n4] & 0xFF) + (byArray[n4 - n3] & 0xFF) >> 1));
                        ++n4;
                    }
                } else {
                    for (n4 = n3; n4 < n2; ++n4) {
                        int n9 = n4;
                        byArray[n9] = (byte)(byArray[n9] + ((byArray[n4 - n3] & 0xFF) >> 1));
                    }
                }
                break;
            }
            case 4: {
                int n4;
                if (byArray2 != null) {
                    while (n4 < n3) {
                        int n10 = n4;
                        byArray[n10] = (byte)(byArray[n10] + byArray2[n4]);
                        ++n4;
                    }
                    while (n4 < n2) {
                        int n11 = byArray[n4 - n3] & 0xFF;
                        int n12 = byArray2[n4] & 0xFF;
                        int n13 = byArray2[n4 - n3] & 0xFF;
                        int n14 = n11 + n12 - n13;
                        int n15 = n14 > n11 ? n14 - n11 : n11 - n14;
                        int n16 = n14 > n12 ? n14 - n12 : n12 - n14;
                        int n17 = n14 > n13 ? n14 - n13 : n13 - n14;
                        int n18 = n4;
                        byArray[n18] = (byte)(byArray[n18] + (n15 <= n16 && n15 <= n17 ? n11 : (n16 <= n17 ? n12 : n13)));
                        ++n4;
                    }
                } else {
                    for (n4 = n3; n4 < n2; ++n4) {
                        int n19 = n4;
                        byArray[n19] = (byte)(byArray[n19] + byArray[n4 - n3]);
                    }
                }
                break;
            }
            default: {
                throw new PNGException("Illegal filter");
            }
        }
    }

    public PNGImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) throws IOException {
        super(inputStreamImageSource, inputStream);
        this.inputStream = new PNGFilterInputStream(this, inputStream);
        this.underlyingInputStream = this.inputStream.underlyingInputStream;
    }

    private void fill() throws IOException {
        if (!this.seenEOF) {
            if (this.pos > 0 && this.pos < this.limit) {
                System.arraycopy(this.inbuf, this.pos, this.inbuf, 0, this.limit - this.pos);
                this.limit -= this.pos;
                this.pos = 0;
            } else if (this.pos >= this.limit) {
                this.pos = 0;
                this.limit = 0;
            }
            int n = this.inbuf.length;
            while (this.limit < n) {
                int n2 = this.underlyingInputStream.read(this.inbuf, this.limit, n - this.limit);
                if (n2 <= 0) {
                    this.seenEOF = true;
                    break;
                }
                this.limit += n2;
            }
        }
    }

    private boolean need(int n) throws IOException {
        if (this.limit - this.pos >= n) {
            return true;
        }
        this.fill();
        if (this.limit - this.pos >= n) {
            return true;
        }
        if (this.seenEOF) {
            return false;
        }
        byte[] byArray = new byte[n + 100];
        System.arraycopy(this.inbuf, this.pos, byArray, 0, this.limit - this.pos);
        this.limit -= this.pos;
        this.pos = 0;
        this.inbuf = byArray;
        this.fill();
        return this.limit - this.pos >= n;
    }

    private final int getInt(int n) {
        return (this.inbuf[n] & 0xFF) << 24 | (this.inbuf[n + 1] & 0xFF) << 16 | (this.inbuf[n + 2] & 0xFF) << 8 | this.inbuf[n + 3] & 0xFF;
    }

    private final int getShort(int n) {
        return (short)((this.inbuf[n] & 0xFF) << 8 | this.inbuf[n + 1] & 0xFF);
    }

    private final int getByte(int n) {
        return this.inbuf[n] & 0xFF;
    }

    private final boolean getChunk() throws IOException {
        this.chunkLength = 0;
        if (!this.need(8)) {
            return false;
        }
        this.chunkLength = this.getInt(this.pos);
        this.chunkKey = this.getInt(this.pos + 4);
        if (this.chunkLength < 0) {
            throw new PNGException("bogus length: " + this.chunkLength);
        }
        if (!this.need(this.chunkLength + 12)) {
            return false;
        }
        this.chunkCRC = this.getInt(this.pos + 8 + this.chunkLength);
        this.chunkStart = this.pos + 8;
        int n = PNGImageDecoder.crc(this.inbuf, this.pos + 4, this.chunkLength + 4);
        if (this.chunkCRC != n && checkCRC) {
            throw new PNGException("crc corruption");
        }
        this.pos += this.chunkLength + 12;
        return true;
    }

    private void readAll() throws IOException {
        while (this.getChunk()) {
            this.handleChunk(this.chunkKey, this.inbuf, this.chunkStart, this.chunkLength);
        }
    }

    boolean getData() throws IOException {
        while (this.chunkLength == 0 && this.getChunk()) {
            if (!this.handleChunk(this.chunkKey, this.inbuf, this.chunkStart, this.chunkLength)) continue;
            this.chunkLength = 0;
        }
        return this.chunkLength > 0;
    }

    public static boolean getCheckCRC() {
        return checkCRC;
    }

    public static void setCheckCRC(boolean bl) {
        checkCRC = bl;
    }

    protected void wrc(int n) {
        if ((n &= 0xFF) <= 32 || n > 122) {
            n = 63;
        }
        System.out.write(n);
    }

    protected void wrk(int n) {
        this.wrc(n >> 24);
        this.wrc(n >> 16);
        this.wrc(n >> 8);
        this.wrc(n);
    }

    public void print() {
        this.wrk(this.chunkKey);
        System.out.print(" " + this.chunkLength + "\n");
    }

    private static int update_crc(int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        while (--n3 >= 0) {
            n4 = crc_table[(n4 ^ byArray[n2++]) & 0xFF] ^ n4 >>> 8;
        }
        return n4;
    }

    private static int crc(byte[] byArray, int n, int n2) {
        return ~PNGImageDecoder.update_crc(-1, byArray, n, n2);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            PNGImageDecoder.crc_table[i] = n;
        }
    }

    public static class Chromaticities {
        public float whiteX;
        public float whiteY;
        public float redX;
        public float redY;
        public float greenX;
        public float greenY;
        public float blueX;
        public float blueY;

        Chromaticities(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.whiteX = (float)n / 100000.0f;
            this.whiteY = (float)n2 / 100000.0f;
            this.redX = (float)n3 / 100000.0f;
            this.redY = (float)n4 / 100000.0f;
            this.greenX = (float)n5 / 100000.0f;
            this.greenY = (float)n6 / 100000.0f;
            this.blueX = (float)n7 / 100000.0f;
            this.blueY = (float)n8 / 100000.0f;
        }

        public String toString() {
            return "Chromaticities(white=" + this.whiteX + "," + this.whiteY + ";red=" + this.redX + "," + this.redY + ";green=" + this.greenX + "," + this.greenY + ";blue=" + this.blueX + "," + this.blueY + ")";
        }
    }

    public class PNGException
    extends IOException {
        PNGException(String string) {
            super(string);
        }
    }
}

