/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.security.AccessController;
import sun.awt.DisplayChangedListener;
import sun.awt.image.SurfaceManager;
import sun.java2d.StateTrackable;
import sun.java2d.StateTracker;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;
import sun.security.action.GetPropertyAction;

public abstract class SurfaceDataProxy
implements DisplayChangedListener,
SurfaceManager.FlushableCacheData {
    private static boolean cachingAllowed = true;
    private static int defaultThreshold;
    public static SurfaceDataProxy UNCACHED;
    private int threshold;
    private StateTracker srcTracker;
    private int numtries;
    private SurfaceData cachedSD;
    private StateTracker cacheTracker;
    private boolean valid;

    public static boolean isCachingAllowed() {
        return cachingAllowed;
    }

    public abstract boolean isSupportedOperation(SurfaceData var1, int var2, CompositeType var3, Color var4);

    public abstract SurfaceData validateSurfaceData(SurfaceData var1, SurfaceData var2, int var3, int var4);

    public StateTracker getRetryTracker(SurfaceData surfaceData) {
        return new CountdownTracker(this.threshold);
    }

    public SurfaceDataProxy() {
        this(defaultThreshold);
    }

    public SurfaceDataProxy(int n) {
        this.threshold = n;
        this.srcTracker = StateTracker.NEVER_CURRENT;
        this.cacheTracker = StateTracker.NEVER_CURRENT;
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean flush(boolean bl) {
        if (bl) {
            this.invalidate();
        }
        this.flush();
        return !this.isValid();
    }

    public synchronized void flush() {
        SurfaceData surfaceData = this.cachedSD;
        this.cachedSD = null;
        this.cacheTracker = StateTracker.NEVER_CURRENT;
        if (surfaceData != null) {
            surfaceData.flush();
        }
    }

    public boolean isAccelerated() {
        return this.isValid() && this.srcTracker.isCurrent() && this.cacheTracker.isCurrent();
    }

    protected void activateDisplayListener() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof SunGraphicsEnvironment) {
            ((SunGraphicsEnvironment)graphicsEnvironment).addDisplayChangedListener(this);
        }
    }

    public void displayChanged() {
        this.flush();
    }

    public void paletteChanged() {
        this.srcTracker = StateTracker.NEVER_CURRENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceData replaceData(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
        if (this.isSupportedOperation(surfaceData, n, compositeType, color)) {
            Object object;
            if (!this.srcTracker.isCurrent()) {
                object = this;
                synchronized (object) {
                    this.numtries = this.threshold;
                    this.srcTracker = surfaceData.getStateTracker();
                    this.cacheTracker = StateTracker.NEVER_CURRENT;
                }
                if (!this.srcTracker.isCurrent()) {
                    if (surfaceData.getState() == StateTrackable.State.UNTRACKABLE) {
                        this.invalidate();
                        this.flush();
                    }
                    return surfaceData;
                }
            }
            object = this.cachedSD;
            if (!this.cacheTracker.isCurrent()) {
                Object object2 = this;
                synchronized (object2) {
                    if (this.numtries > 0) {
                        --this.numtries;
                        return surfaceData;
                    }
                }
                object2 = surfaceData.getBounds();
                int n2 = ((Rectangle)object2).width;
                int n3 = ((Rectangle)object2).height;
                StateTracker stateTracker = this.srcTracker;
                object = this.validateSurfaceData(surfaceData, (SurfaceData)object, n2, n3);
                if (object == null) {
                    SurfaceDataProxy surfaceDataProxy = this;
                    synchronized (surfaceDataProxy) {
                        if (stateTracker == this.srcTracker) {
                            this.cacheTracker = this.getRetryTracker(surfaceData);
                            this.cachedSD = null;
                        }
                    }
                    return surfaceData;
                }
                this.updateSurfaceData(surfaceData, (SurfaceData)object, n2, n3);
                if (!((SurfaceData)object).isValid()) {
                    return surfaceData;
                }
                SurfaceDataProxy surfaceDataProxy = this;
                synchronized (surfaceDataProxy) {
                    if (stateTracker == this.srcTracker && stateTracker.isCurrent()) {
                        this.cacheTracker = ((SurfaceData)object).getStateTracker();
                        this.cachedSD = object;
                    }
                }
            }
            if (object != null) {
                return object;
            }
        }
        return surfaceData;
    }

    public void updateSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2) {
        SurfaceType surfaceType = surfaceData.getSurfaceType();
        SurfaceType surfaceType2 = surfaceData2.getSurfaceType();
        Blit blit = Blit.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
        blit.Blit(surfaceData, surfaceData2, AlphaComposite.Src, null, 0, 0, 0, 0, n, n2);
        surfaceData2.markDirty();
    }

    public void updateSurfaceDataBg(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2, Color color) {
        SurfaceType surfaceType = surfaceData.getSurfaceType();
        SurfaceType surfaceType2 = surfaceData2.getSurfaceType();
        BlitBg blitBg = BlitBg.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
        blitBg.BlitBg(surfaceData, surfaceData2, AlphaComposite.Src, null, color.getRGB(), 0, 0, 0, 0, n, n2);
        surfaceData2.markDirty();
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.managedimages"));
        if (string != null && string.equals("false")) {
            cachingAllowed = false;
            System.out.println("Disabling managed images");
        }
        defaultThreshold = 1;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.accthreshold"));
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0) {
                    defaultThreshold = n;
                    System.out.println("New Default Acceleration Threshold: " + defaultThreshold);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error setting new threshold:" + numberFormatException);
            }
        }
        UNCACHED = new SurfaceDataProxy(0){

            public boolean isAccelerated() {
                return false;
            }

            public boolean isSupportedOperation(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
                return false;
            }

            public SurfaceData validateSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2) {
                throw new InternalError("UNCACHED should never validate SDs");
            }

            public SurfaceData replaceData(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
                return surfaceData;
            }
        };
    }

    public static class CountdownTracker
    implements StateTracker {
        private int countdown;

        public CountdownTracker(int n) {
            this.countdown = n;
        }

        public synchronized boolean isCurrent() {
            return --this.countdown >= 0;
        }
    }
}

