/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

public class PiscesMath {
    private static final int SINTAB_LG_ENTRIES = 10;
    private static final int SINTAB_ENTRIES = 1024;
    private static int[] sintab;
    public static final int PI = 205887;
    public static final int TWO_PI = 411774;
    public static final int PI_OVER_TWO = 102943;
    public static final int SQRT_TWO;

    private PiscesMath() {
    }

    public static int sin(int n) {
        int n2 = 1;
        if (n < 0) {
            n = -n;
            n2 = -1;
        }
        while (n >= 411774) {
            n -= 411774;
        }
        if (n >= 205887) {
            n = 411774 - n;
            n2 = -n2;
        }
        if (n > 102943) {
            n = 205887 - n;
        }
        int n3 = (int)((long)n * 1024L / 102943L);
        return n2 * sintab[n3];
    }

    public static int cos(int n) {
        return PiscesMath.sin(102943 - n);
    }

    public static int isqrt(int n) {
        int n2 = 16;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = 15 + n2 / 2;
        do {
            n4 = n4 << 2 | n5 >>> 30;
            n5 <<= 2;
            int n7 = ((n3 <<= 1) << 1) + 1;
            if (n4 < n7) continue;
            n4 -= n7;
            ++n3;
        } while (n6-- != 0);
        return n3;
    }

    public static long lsqrt(long l) {
        int n = 16;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l;
        int n2 = 31 + n / 2;
        do {
            l3 = l3 << 2 | l4 >>> 62;
            l4 <<= 2;
            long l5 = ((l2 <<= 1) << 1) + 1L;
            if (l3 < l5) continue;
            l3 -= l5;
            ++l2;
        } while (n2-- != 0);
        return l2;
    }

    public static double hypot(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public static int hypot(int n, int n2) {
        return (int)(PiscesMath.lsqrt((long)n * (long)n + (long)n2 * (long)n2) + 128L >> 8);
    }

    public static long hypot(long l, long l2) {
        return PiscesMath.lsqrt(l * l + l2 * l2) + 128L >> 8;
    }

    static {
        SQRT_TWO = (int)(Math.sqrt(2.0) * 65536.0);
        sintab = new int[1025];
        for (int i = 0; i < 1025; ++i) {
            double d = (double)i * 1.5707963267948966 / 1024.0;
            PiscesMath.sintab[i] = (int)(Math.sin(d) * 65536.0);
        }
    }
}

