/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpUnknownModelException;
import com.sun.jmx.snmp.agent.LongList;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpAccessControlModel;
import com.sun.jmx.snmp.internal.SnmpEngineImpl;
import java.util.logging.Level;

class AcmChecker {
    SnmpAccessControlModel model;
    String principal;
    int securityLevel;
    int version;
    int pduType;
    int securityModel;
    byte[] contextName;
    SnmpEngineImpl engine;
    LongList l;

    AcmChecker(SnmpMibRequest snmpMibRequest) {
        block5: {
            this.model = null;
            this.principal = null;
            this.securityLevel = -1;
            this.version = -1;
            this.pduType = -1;
            this.securityModel = -1;
            this.contextName = null;
            this.engine = null;
            this.l = null;
            this.engine = (SnmpEngineImpl)snmpMibRequest.getEngine();
            if (this.engine != null && this.engine.isCheckOidActivated()) {
                try {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "AcmChecker(SnmpMibRequest)", "SNMP V3 Access Control to be done");
                    }
                    this.model = (SnmpAccessControlModel)this.engine.getAccessControlSubSystem().getModel(4430);
                    this.principal = snmpMibRequest.getPrincipal();
                    this.securityLevel = snmpMibRequest.getSecurityLevel();
                    this.pduType = snmpMibRequest.getPdu().type;
                    this.version = snmpMibRequest.getRequestPduVersion();
                    this.securityModel = snmpMibRequest.getSecurityModel();
                    this.contextName = snmpMibRequest.getAccessContextName();
                    this.l = new LongList();
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Will check oid for : principal : ").append(this.principal).append("; securityLevel : ").append(this.securityLevel).append("; pduType : ").append(this.pduType).append("; version : ").append(this.version).append("; securityModel : ").append(this.securityModel).append("; contextName : ").append(this.contextName);
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "AcmChecker(SnmpMibRequest)", stringBuilder.toString());
                    }
                }
                catch (SnmpUnknownModelException snmpUnknownModelException) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block5;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "AcmChecker(SnmpMibRequest)", "Unknown Model, no ACM check.");
                }
            }
        }
    }

    void add(int n, long l) {
        if (this.model != null) {
            this.l.add(n, l);
        }
    }

    void remove(int n) {
        if (this.model != null) {
            this.l.remove(n);
        }
    }

    void add(int n, long[] lArray, int n2, int n3) {
        if (this.model != null) {
            this.l.add(n, lArray, n2, n3);
        }
    }

    void remove(int n, int n2) {
        if (this.model != null) {
            this.l.remove(n, n2);
        }
    }

    void checkCurrentOid() throws SnmpStatusException {
        if (this.model != null) {
            SnmpOid snmpOid = new SnmpOid(this.l.toArray());
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "checkCurrentOid", "Checking access for : " + snmpOid);
            }
            this.model.checkAccess(this.version, this.principal, this.securityLevel, this.pduType, this.securityModel, this.contextName, snmpOid);
        }
    }
}

