/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformComponent;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import javax.management.StandardMBean;
import sun.management.ManagementFactoryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    private static MBeanServer platformMBeanServer;
    private static final String NOTIF_EMITTER = "javax.management.NotificationEmitter";

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactoryHelper.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementFactoryHelper.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementFactoryHelper.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactoryHelper.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementFactoryHelper.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementFactoryHelper.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactoryHelper.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementFactoryHelper.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactoryHelper.getGarbageCollectorMXBeans();
    }

    public static synchronized MBeanServer getPlatformMBeanServer() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            PlatformComponent[] platformComponentArray = new MBeanServerPermission("createMBeanServer");
            securityManager.checkPermission((Permission)platformComponentArray);
        }
        if (platformMBeanServer == null) {
            platformMBeanServer = MBeanServerFactory.createMBeanServer();
            for (PlatformComponent platformComponent : PlatformComponent.values()) {
                List<? extends PlatformManagedObject> list = platformComponent.getMXBeans(platformComponent.getMXBeanInterface());
                for (PlatformManagedObject platformManagedObject : list) {
                    if (platformMBeanServer.isRegistered(platformManagedObject.getObjectName())) continue;
                    ManagementFactory.addMXBean(platformMBeanServer, platformManagedObject);
                }
            }
        }
        return platformMBeanServer;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        final Class<T> clazz2 = clazz;
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz2.getClassLoader();
            }
        });
        if (classLoader != null) {
            throw new IllegalArgumentException(string + " is not a platform MXBean");
        }
        try {
            ObjectName objectName = new ObjectName(string);
            if (!mBeanServerConnection.isInstanceOf(objectName, clazz2.getName())) {
                throw new IllegalArgumentException(string + " is not an instance of " + clazz2);
            }
            boolean bl = mBeanServerConnection.isInstanceOf(objectName, NOTIF_EMITTER);
            return JMX.newMXBeanProxy(mBeanServerConnection, objectName, clazz, bl);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string + " not found in the connection.");
            illegalArgumentException.initCause(instanceNotFoundException);
            throw illegalArgumentException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string + " is not a valid ObjectName format.");
            illegalArgumentException.initCause(malformedObjectNameException);
            throw illegalArgumentException;
        }
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> clazz) {
        String string = clazz.getName();
        for (PlatformComponent platformComponent : PlatformComponent.values()) {
            if (!string.equals(platformComponent.getMXBeanInterfaceName()) || platformComponent.getMXBeanInterface() != clazz) continue;
            return platformComponent.getMXBeans(clazz);
        }
        throw new IllegalArgumentException(clazz.getName() + " is not implemented by any of the platform MXBeans.");
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        String string = clazz.getName();
        for (PlatformComponent platformComponent : PlatformComponent.values()) {
            if (!string.equals(platformComponent.getMXBeanInterfaceName()) || platformComponent.getMXBeanInterface() != clazz) continue;
            return platformComponent.getMXBeans(mBeanServerConnection, clazz);
        }
        throw new IllegalArgumentException(clazz.getName() + " is not implemented by any of the platform MXBeans.");
    }

    public static List<Class<? extends PlatformManagedObject>> getAllPlatformMXBeanInterfaces() {
        ArrayList<Class<? extends PlatformManagedObject>> arrayList = new ArrayList<Class<? extends PlatformManagedObject>>();
        for (PlatformComponent platformComponent : PlatformComponent.values()) {
            arrayList.add(platformComponent.getMXBeanInterface());
        }
        return arrayList;
    }

    private static void addMXBean(final MBeanServer mBeanServer, final PlatformManagedObject platformManagedObject) {
        final StandardMBean standardMBean = platformManagedObject instanceof NotificationEmitter ? new StandardEmitterMBean(platformManagedObject, null, true, (NotificationEmitter)((Object)platformManagedObject)) : new StandardMBean(platformManagedObject, null, true);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    mBeanServer.registerMBean(standardMBean, platformManagedObject.getObjectName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException.getException());
        }
    }
}

