/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Util;
import java.io.InvalidObjectException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableDescriptor
implements Descriptor {
    private static final long serialVersionUID = 8853308591080540165L;
    private final String[] names;
    private final Object[] values;
    private transient int hashCode = -1;
    public static final ImmutableDescriptor EMPTY_DESCRIPTOR = new ImmutableDescriptor(new String[0]);

    public ImmutableDescriptor(String[] stringArray, Object[] objectArray) {
        this(ImmutableDescriptor.makeMap(stringArray, objectArray));
    }

    public ImmutableDescriptor(String ... stringArray) {
        this(ImmutableDescriptor.makeMap(stringArray));
    }

    public ImmutableDescriptor(Map<String, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException("Null Map");
        }
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string == null || string.equals("")) {
                throw new IllegalArgumentException("Empty or null field name");
            }
            if (treeMap.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate name: " + string);
            }
            treeMap.put(string, entry.getValue());
        }
        int n = treeMap.size();
        this.names = treeMap.keySet().toArray(new String[n]);
        this.values = treeMap.values().toArray(new Object[n]);
    }

    private Object readResolve() throws InvalidObjectException {
        boolean bl = false;
        if (this.names == null || this.values == null || this.names.length != this.values.length) {
            bl = true;
        }
        if (!bl) {
            if (this.names.length == 0 && this.getClass() == ImmutableDescriptor.class) {
                return EMPTY_DESCRIPTOR;
            }
            Comparator comparator = String.CASE_INSENSITIVE_ORDER;
            String string = "";
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] == null || comparator.compare(string, this.names[i]) >= 0) {
                    bl = true;
                    break;
                }
                string = this.names[i];
            }
        }
        if (bl) {
            throw new InvalidObjectException("Bad names or values");
        }
        return this;
    }

    private static SortedMap<String, ?> makeMap(String[] stringArray, Object[] objectArray) {
        if (stringArray == null || objectArray == null) {
            throw new IllegalArgumentException("Null array parameter");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Different size arrays");
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || string.equals("")) {
                throw new IllegalArgumentException("Empty or null field name");
            }
            Object object = treeMap.put(string, objectArray[i]);
            if (object == null) continue;
            throw new IllegalArgumentException("Duplicate field name: " + string);
        }
        return treeMap;
    }

    private static SortedMap<String, ?> makeMap(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null fields parameter");
        }
        String[] stringArray2 = new String[stringArray.length];
        Object[] objectArray = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(61);
            if (n < 0) {
                throw new IllegalArgumentException("Missing = character: " + string);
            }
            stringArray2[i] = string.substring(0, n);
            objectArray[i] = string.substring(n + 1);
        }
        return ImmutableDescriptor.makeMap(stringArray2, objectArray);
    }

    public static ImmutableDescriptor union(Descriptor ... descriptorArray) {
        int n = ImmutableDescriptor.findNonEmpty(descriptorArray, 0);
        if (n < 0) {
            return EMPTY_DESCRIPTOR;
        }
        if (descriptorArray[n] instanceof ImmutableDescriptor && ImmutableDescriptor.findNonEmpty(descriptorArray, n + 1) < 0) {
            return (ImmutableDescriptor)descriptorArray[n];
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = EMPTY_DESCRIPTOR;
        for (Descriptor descriptor : descriptorArray) {
            String[] stringArray2;
            if (descriptor == null) continue;
            if (descriptor instanceof ImmutableDescriptor) {
                String[] stringArray3 = (String[])descriptor;
                stringArray2 = stringArray3.names;
                if (stringArray3.getClass() == ImmutableDescriptor.class && stringArray2.length > stringArray.names.length) {
                    stringArray = stringArray3;
                }
            } else {
                stringArray2 = descriptor.getFieldNames();
            }
            for (String string : stringArray2) {
                boolean bl;
                Object object = descriptor.getFieldValue(string);
                Object object2 = treeMap.put(string, object);
                if (object2 == null || (bl = object2.getClass().isArray() ? Arrays.deepEquals(new Object[]{object2}, new Object[]{object}) : object2.equals(object))) continue;
                String string2 = "Inconsistent values for descriptor field " + string + ": " + object2 + " :: " + object;
                throw new IllegalArgumentException(string2);
            }
        }
        if (stringArray.names.length == treeMap.size()) {
            return stringArray;
        }
        return new ImmutableDescriptor(treeMap);
    }

    private static boolean isEmpty(Descriptor descriptor) {
        if (descriptor == null) {
            return true;
        }
        if (descriptor instanceof ImmutableDescriptor) {
            return ((ImmutableDescriptor)descriptor).names.length == 0;
        }
        return descriptor.getFieldNames().length == 0;
    }

    private static int findNonEmpty(Descriptor[] descriptorArray, int n) {
        for (int i = n; i < descriptorArray.length; ++i) {
            if (ImmutableDescriptor.isEmpty(descriptorArray[i])) continue;
            return i;
        }
        return -1;
    }

    private int fieldIndex(String string) {
        return Arrays.binarySearch(this.names, string, String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    public final Object getFieldValue(String string) {
        ImmutableDescriptor.checkIllegalFieldName(string);
        int n = this.fieldIndex(string);
        if (n < 0) {
            return null;
        }
        Object object = this.values[n];
        if (object == null || !object.getClass().isArray()) {
            return object;
        }
        if (object instanceof Object[]) {
            return ((Object[])object).clone();
        }
        int n2 = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    @Override
    public final String[] getFields() {
        String[] stringArray = new String[this.names.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.values[i];
            if (object == null) {
                object = "";
            } else if (!(object instanceof String)) {
                object = "(" + object + ")";
            }
            stringArray[i] = this.names[i] + "=" + object;
        }
        return stringArray;
    }

    @Override
    public final Object[] getFieldValues(String ... stringArray) {
        if (stringArray == null) {
            return (Object[])this.values.clone();
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || string.equals("")) continue;
            objectArray[i] = this.getFieldValue(string);
        }
        return objectArray;
    }

    @Override
    public final String[] getFieldNames() {
        return (String[])this.names.clone();
    }

    @Override
    public boolean equals(Object object) {
        String[] stringArray;
        if (object == this) {
            return true;
        }
        if (!(object instanceof Descriptor)) {
            return false;
        }
        if (object instanceof ImmutableDescriptor) {
            stringArray = ((ImmutableDescriptor)object).names;
        } else {
            stringArray = ((Descriptor)object).getFieldNames();
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        }
        if (this.names.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i].equalsIgnoreCase(stringArray[i])) continue;
            return false;
        }
        Object[] objectArray = object instanceof ImmutableDescriptor ? ((ImmutableDescriptor)object).values : ((Descriptor)object).getFieldValues(stringArray);
        return Arrays.deepEquals(this.values, objectArray);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Util.hashCode(this.names, this.values);
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.names[i]).append("=");
            Object object = this.values[i];
            if (object != null && object.getClass().isArray()) {
                String string = Arrays.deepToString(new Object[]{object});
                string = string.substring(1, string.length() - 1);
                object = string;
            }
            stringBuilder.append(String.valueOf(object));
        }
        return stringBuilder.append("}").toString();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Descriptor clone() {
        return this;
    }

    @Override
    public final void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        int n;
        if (stringArray == null || objectArray == null) {
            ImmutableDescriptor.illegal("Null argument");
        }
        if (stringArray.length != objectArray.length) {
            ImmutableDescriptor.illegal("Different array sizes");
        }
        for (n = 0; n < stringArray.length; ++n) {
            ImmutableDescriptor.checkIllegalFieldName(stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.setField(stringArray[n], objectArray[n]);
        }
    }

    @Override
    public final void setField(String string, Object object) throws RuntimeOperationsException {
        Object object2;
        ImmutableDescriptor.checkIllegalFieldName(string);
        int n = this.fieldIndex(string);
        if (n < 0) {
            ImmutableDescriptor.unsupported();
        }
        if ((object2 = this.values[n]) == null ? object != null : !object2.equals(object)) {
            ImmutableDescriptor.unsupported();
        }
    }

    @Override
    public final void removeField(String string) {
        if (string != null && this.fieldIndex(string) >= 0) {
            ImmutableDescriptor.unsupported();
        }
    }

    static Descriptor nonNullDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            return EMPTY_DESCRIPTOR;
        }
        return descriptor;
    }

    private static void checkIllegalFieldName(String string) {
        if (string == null || string.equals("")) {
            ImmutableDescriptor.illegal("Null or empty field name");
        }
    }

    private static void unsupported() {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Descriptor is read-only");
        throw new RuntimeOperationsException(unsupportedOperationException);
    }

    private static void illegal(String string) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        throw new RuntimeOperationsException(illegalArgumentException);
    }
}

