/*
 * Decompiled with CFR 0.152.
 */
package javax.management.event;

import com.sun.jmx.event.DaemonThreadFactory;
import com.sun.jmx.event.LeaseRenewer;
import com.sun.jmx.event.ReceiverBuffer;
import com.sun.jmx.event.RepeatedSingletonJob;
import com.sun.jmx.mbeanserver.PerThreadGroupPool;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.event.EventClientDelegate;
import javax.management.event.EventClientDelegateMBean;
import javax.management.event.EventClientNotFoundException;
import javax.management.event.EventConsumer;
import javax.management.event.EventReceiver;
import javax.management.event.EventRelay;
import javax.management.event.FetchingEventRelay;
import javax.management.event.ListenerInfo;
import javax.management.event.NotificationManager;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventClient
implements EventConsumer,
NotificationManager {
    public static final String FAILED = "jmx.event.service.failed";
    public static final String NONFATAL = "jmx.event.service.nonfatal";
    public static final String NOTIFS_LOST = "jmx.event.service.notifs.lost";
    public static final long DEFAULT_REQUESTED_LEASE_TIME = 300000L;
    private static final Method setRemoveOnCancelPolicy;
    private static final ClassLogger logger;
    private final Executor distributingExecutor;
    private final EventClientDelegateMBean eventClientDelegate;
    private final EventRelay eventRelay;
    private volatile String clientId = null;
    private final long requestedLeaseTime;
    private final ReceiverBuffer buffer = new ReceiverBuffer();
    private final EventReceiverImpl myReceiver = new EventReceiverImpl();
    private final DispatchingJob dispatchingJob;
    private final HashMap<Integer, ListenerInfo> listenerInfoMap = new HashMap();
    private volatile boolean closed = false;
    private volatile boolean startedListening = false;
    private final AtomicLong myNotifCounter = new AtomicLong();
    private static final MBeanNotificationInfo[] myInfo;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private static final Executor callerExecutor;
    private Callable<Long> renewLease = new Callable<Long>(){

        @Override
        public Long call() throws IOException, EventClientNotFoundException {
            return EventClient.this.eventClientDelegate.lease(EventClient.this.clientId, EventClient.this.requestedLeaseTime);
        }
    };
    private final LeaseRenewer leaseRenewer;
    private static Method newEventConn;
    private static final PerThreadGroupPool<ScheduledThreadPoolExecutor> leaseRenewerThreadPool;

    public EventClient(MBeanServerConnection mBeanServerConnection) throws IOException {
        this(EventClientDelegate.getProxy(mBeanServerConnection));
    }

    public EventClient(EventClientDelegateMBean eventClientDelegateMBean) throws IOException {
        this(eventClientDelegateMBean, null, null, null, 300000L);
    }

    public EventClient(EventClientDelegateMBean eventClientDelegateMBean, EventRelay eventRelay, Executor executor, ScheduledExecutorService scheduledExecutorService, long l) throws IOException {
        if (eventClientDelegateMBean == null) {
            throw new IllegalArgumentException("Null EventClientDelegateMBean");
        }
        if (l == 0L) {
            l = 300000L;
        } else if (l < 0L) {
            throw new IllegalArgumentException("Negative lease time: " + l);
        }
        this.eventClientDelegate = eventClientDelegateMBean;
        if (eventRelay != null) {
            this.eventRelay = eventRelay;
        } else {
            try {
                this.eventRelay = new FetchingEventRelay(eventClientDelegateMBean);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.toString());
                iOException.initCause(exception);
                throw iOException;
            }
        }
        if (executor == null) {
            executor = callerExecutor;
        }
        this.distributingExecutor = executor;
        this.dispatchingJob = new DispatchingJob();
        this.clientId = this.eventRelay.getClientId();
        this.requestedLeaseTime = l;
        if (scheduledExecutorService == null) {
            scheduledExecutorService = EventClient.defaultLeaseScheduler();
        }
        this.leaseRenewer = new LeaseRenewer(scheduledExecutorService, this.renewLease);
        if (logger.traceOn()) {
            logger.trace("init", "New EventClient: " + this.clientId);
        }
    }

    private static ScheduledExecutorService defaultLeaseScheduler() {
        PerThreadGroupPool.Create<ScheduledThreadPoolExecutor> create = new PerThreadGroupPool.Create<ScheduledThreadPoolExecutor>(){

            @Override
            public ScheduledThreadPoolExecutor createThreadPool(ThreadGroup threadGroup) {
                DaemonThreadFactory daemonThreadFactory = new DaemonThreadFactory("JMX EventClient lease renewer %d");
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(20, daemonThreadFactory);
                scheduledThreadPoolExecutor.setKeepAliveTime(1L, TimeUnit.SECONDS);
                scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
                if (setRemoveOnCancelPolicy != null) {
                    try {
                        setRemoveOnCancelPolicy.invoke(scheduledThreadPoolExecutor, true);
                    }
                    catch (Exception exception) {
                        logger.trace("setRemoveOnCancelPolicy", exception);
                    }
                }
                return scheduledThreadPoolExecutor;
            }
        };
        return leaseRenewerThreadPool.getThreadPoolExecutor(create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (logger.traceOn()) {
            logger.trace("close", this.clientId);
        }
        Serializable serializable = this.listenerInfoMap;
        synchronized (serializable) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.listenerInfoMap.clear();
        }
        if (this.leaseRenewer != null) {
            this.leaseRenewer.close();
        }
        serializable = null;
        try {
            this.eventRelay.stop();
        }
        catch (IOException iOException) {
            serializable = iOException;
            logger.debug("close", "EventRelay.stop", iOException);
        }
        try {
            this.eventClientDelegate.removeClient(this.clientId);
        }
        catch (Exception exception) {
            serializable = exception instanceof IOException ? (IOException)exception : new IOException(exception);
            logger.debug("close", "Got exception when removing " + this.clientId, exception);
        }
        if (serializable != null) {
            throw serializable;
        }
    }

    public boolean closed() {
        return this.closed;
    }

    public EventRelay getEventRelay() {
        return this.eventRelay;
    }

    public long getRequestedLeaseTime() {
        return this.requestedLeaseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
        Integer n;
        if (logger.traceOn()) {
            logger.trace("addNotificationListener", "");
        }
        this.checkState();
        try {
            n = this.eventClientDelegate.addListener(this.clientId, objectName, notificationFilter);
        }
        catch (EventClientNotFoundException eventClientNotFoundException) {
            IOException iOException = new IOException(eventClientNotFoundException.getMessage());
            iOException.initCause(eventClientNotFoundException);
            throw iOException;
        }
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            this.listenerInfoMap.put(n, new ListenerInfo(objectName, notificationListener, notificationFilter, object, false));
        }
        this.startListening();
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "");
        }
        this.checkState();
        for (Integer n : this.getListenerInfo(objectName, notificationListener, false)) {
            this.removeListener(n);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "with all arguments.");
        }
        this.checkState();
        Integer n = this.getListenerInfo(objectName, notificationListener, notificationFilter, object, false);
        this.removeListener(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("unsubscribe", "");
        }
        this.checkState();
        Integer n = this.getMatchedListenerInfo(objectName, notificationListener, true);
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            if (this.listenerInfoMap.remove(n) == null) {
                throw new ListenerNotFoundException();
            }
        }
        this.stopListening();
        try {
            this.eventClientDelegate.removeListenerOrSubscriber(this.clientId, n);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            logger.trace("unsubscribe", "removeSubscriber", instanceNotFoundException);
        }
        catch (EventClientNotFoundException eventClientNotFoundException) {
            logger.trace("unsubscribe", "removeSubscriber", eventClientNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IOException {
        Integer n;
        if (logger.traceOn()) {
            logger.trace("subscribe", "");
        }
        this.checkState();
        try {
            n = this.eventClientDelegate.addSubscriber(this.clientId, objectName, notificationFilter);
        }
        catch (EventClientNotFoundException eventClientNotFoundException) {
            IOException iOException = new IOException(eventClientNotFoundException.getMessage());
            iOException.initCause(eventClientNotFoundException);
            throw iOException;
        }
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            this.listenerInfoMap.put(n, new ListenerInfo(objectName, notificationListener, notificationFilter, object, true));
        }
        this.startListening();
    }

    public Collection<ListenerInfo> addListeners(Collection<ListenerInfo> collection) throws IOException {
        if (logger.traceOn()) {
            logger.trace("addListeners", "");
        }
        this.checkState();
        if (collection == null || collection.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>();
        for (ListenerInfo listenerInfo : collection) {
            try {
                if (listenerInfo.isSubscription()) {
                    this.subscribe(listenerInfo.getObjectName(), listenerInfo.getListener(), listenerInfo.getFilter(), listenerInfo.getHandback());
                } else {
                    this.addNotificationListener(listenerInfo.getObjectName(), listenerInfo.getListener(), listenerInfo.getFilter(), listenerInfo.getHandback());
                }
                arrayList.add(listenerInfo);
            }
            catch (Exception exception) {
                if (!logger.traceOn()) continue;
                logger.trace("addListeners", "failed to add: " + listenerInfo, exception);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ListenerInfo> getListeners() {
        if (logger.traceOn()) {
            logger.trace("getListeners", "");
        }
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            return Collections.unmodifiableCollection(this.listenerInfoMap.values());
        }
    }

    public void addEventClientListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (logger.traceOn()) {
            logger.trace("addEventClientListener", "");
        }
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeEventClientListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (logger.traceOn()) {
            logger.trace("removeEventClientListener", "");
        }
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getEventClientNotificationInfo() {
        return (MBeanNotificationInfo[])myInfo.clone();
    }

    private static boolean match(ListenerInfo listenerInfo, ObjectName objectName, NotificationListener notificationListener, boolean bl) {
        return listenerInfo.getObjectName().equals(objectName) && listenerInfo.getListener() == notificationListener && listenerInfo.isSubscription() == bl;
    }

    private static boolean match(ListenerInfo listenerInfo, ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, boolean bl) {
        return listenerInfo.getObjectName().equals(objectName) && listenerInfo.getFilter() == notificationFilter && listenerInfo.getListener() == notificationListener && listenerInfo.getHandback() == object && listenerInfo.isSubscription() == bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getListenerInfo(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, boolean bl) throws ListenerNotFoundException {
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            for (Map.Entry<Integer, ListenerInfo> entry : this.listenerInfoMap.entrySet()) {
                ListenerInfo listenerInfo = entry.getValue();
                if (!EventClient.match(listenerInfo, objectName, notificationListener, notificationFilter, object, bl)) continue;
                return entry.getKey();
            }
        }
        throw new ListenerNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getMatchedListenerInfo(ObjectName objectName, NotificationListener notificationListener, boolean bl) throws ListenerNotFoundException {
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            for (Map.Entry<Integer, ListenerInfo> entry : this.listenerInfoMap.entrySet()) {
                ListenerInfo listenerInfo = entry.getValue();
                if (!listenerInfo.getObjectName().equals(objectName) || listenerInfo.getListener() != notificationListener || listenerInfo.isSubscription() != bl) continue;
                return entry.getKey();
            }
        }
        throw new ListenerNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Integer> getListenerInfo(ObjectName objectName, NotificationListener notificationListener, boolean bl) throws ListenerNotFoundException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            for (Map.Entry<Integer, ListenerInfo> entry : this.listenerInfoMap.entrySet()) {
                ListenerInfo listenerInfo = entry.getValue();
                if (!EventClient.match(listenerInfo, objectName, notificationListener, bl)) continue;
                arrayList.add(entry.getKey());
            }
        }
        if (arrayList.isEmpty()) {
            throw new ListenerNotFoundException();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            if (this.closed) {
                throw new IOException("Ended!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListening() throws IOException {
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            if (!this.startedListening && this.listenerInfoMap.size() > 0) {
                this.eventRelay.setEventReceiver(this.myReceiver);
            }
            this.startedListening = true;
            if (logger.traceOn()) {
                logger.trace("startListening", "listening");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopListening() throws IOException {
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            if (this.listenerInfoMap.size() == 0 && this.startedListening) {
                this.eventRelay.setEventReceiver(null);
                this.startedListening = false;
                if (logger.traceOn()) {
                    logger.trace("stopListening", "non listening");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(Integer n) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        HashMap<Integer, ListenerInfo> hashMap = this.listenerInfoMap;
        synchronized (hashMap) {
            if (this.listenerInfoMap.remove(n) == null) {
                throw new ListenerNotFoundException();
            }
            this.stopListening();
        }
        try {
            this.eventClientDelegate.removeListenerOrSubscriber(this.clientId, n);
        }
        catch (EventClientNotFoundException eventClientNotFoundException) {
            logger.trace("removeListener", "ecd.removeListener", eventClientNotFoundException);
        }
    }

    private static void checkInit(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException {
        if (mBeanServerConnection == null) {
            throw new IllegalArgumentException("No connection specified");
        }
        if (objectName != null && !mBeanServerConnection.isRegistered(objectName)) {
            throw new IllegalArgumentException(objectName + ": not found");
        }
        if (objectName == null && !mBeanServerConnection.isRegistered(EventClientDelegate.OBJECT_NAME)) {
            throw new IllegalArgumentException(EventClientDelegate.OBJECT_NAME + ": not found");
        }
    }

    public static MBeanServerConnection getEventClientConnection(MBeanServerConnection mBeanServerConnection) throws IOException {
        return EventClient.getEventClientConnection(mBeanServerConnection, null);
    }

    public static MBeanServerConnection getEventClientConnection(final MBeanServerConnection mBeanServerConnection, final EventRelay eventRelay) throws IOException {
        if (newEventConn == null) {
            throw new IllegalArgumentException("Class not found: EventClientConnection");
        }
        EventClient.checkInit(mBeanServerConnection, null);
        Callable<EventClient> callable = new Callable<EventClient>(){

            @Override
            public final EventClient call() throws Exception {
                EventClientDelegateMBean eventClientDelegateMBean = EventClientDelegate.getProxy(mBeanServerConnection);
                return new EventClient(eventClientDelegateMBean, eventRelay, null, null, 300000L);
            }
        };
        try {
            return (MBeanServerConnection)newEventConn.invoke(null, mBeanServerConnection, callable);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    static {
        AnnotatedElement annotatedElement;
        try {
            annotatedElement = ScheduledThreadPoolExecutor.class.getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
        }
        catch (Exception exception) {
            annotatedElement = null;
        }
        setRemoveOnCancelPolicy = annotatedElement;
        logger = new ClassLogger("javax.management.event", "EventClient");
        myInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{FAILED, NONFATAL, NOTIFS_LOST}, Notification.class.getName(), "Notifications that can be sent to a listener added with EventClient.addEventClientListener")};
        callerExecutor = new Executor(){

            public void execute(Runnable runnable) {
                runnable.run();
            }
        };
        newEventConn = null;
        try {
            annotatedElement = Class.forName("com.sun.jmx.remote.util.EventClientConnection", false, Thread.currentThread().getContextClassLoader());
            newEventConn = ((Class)annotatedElement).getMethod("getEventConnectionFor", MBeanServerConnection.class, Callable.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        leaseRenewerThreadPool = PerThreadGroupPool.make();
    }

    private class EventReceiverImpl
    implements EventReceiver {
        private EventReceiverImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(NotificationResult notificationResult) {
            if (logger.traceOn()) {
                logger.trace("MyEventReceiver-receive", "");
            }
            ReceiverBuffer receiverBuffer = EventClient.this.buffer;
            synchronized (receiverBuffer) {
                EventClient.this.buffer.addNotifs(notificationResult);
                EventClient.this.dispatchingJob.resume();
            }
        }

        public void failed(Throwable throwable) {
            if (logger.traceOn()) {
                logger.trace("MyEventReceiver-failed", "", throwable);
            }
            Notification notification = new Notification(EventClient.FAILED, (Object)this, EventClient.this.myNotifCounter.getAndIncrement(), System.currentTimeMillis());
            notification.setSource(throwable);
            EventClient.this.broadcaster.sendNotification(notification);
        }

        public void nonFatal(Exception exception) {
            if (logger.traceOn()) {
                logger.trace("MyEventReceiver-nonFatal", "", exception);
            }
            Notification notification = new Notification(EventClient.NONFATAL, (Object)this, EventClient.this.myNotifCounter.getAndIncrement(), System.currentTimeMillis());
            notification.setSource(exception);
            EventClient.this.broadcaster.sendNotification(notification);
        }
    }

    private class DispatchingJob
    extends RepeatedSingletonJob {
        public DispatchingJob() {
            super(EventClient.this.distributingExecutor);
        }

        public boolean isSuspended() {
            return EventClient.this.closed || EventClient.this.buffer.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void task() {
            TargetedNotification[] targetedNotificationArray;
            int n = 0;
            Object object = EventClient.this.buffer;
            synchronized (object) {
                targetedNotificationArray = EventClient.this.buffer.removeNotifs();
                n = EventClient.this.buffer.removeLost();
            }
            if ((targetedNotificationArray == null || targetedNotificationArray.length == 0) && n == 0) {
                return;
            }
            if (targetedNotificationArray != null && targetedNotificationArray.length > 0) {
                if (logger.traceOn()) {
                    logger.trace("DispatchingJob-task", "Forwarding: " + targetedNotificationArray.length);
                }
                for (TargetedNotification targetedNotification : targetedNotificationArray) {
                    ListenerInfo listenerInfo = (ListenerInfo)EventClient.this.listenerInfoMap.get(targetedNotification.getListenerID());
                    try {
                        listenerInfo.getListener().handleNotification(targetedNotification.getNotification(), listenerInfo.getHandback());
                    }
                    catch (Exception exception) {
                        logger.fine("DispatchingJob.task", "listener got exception", exception);
                    }
                }
            }
            if (n > 0) {
                if (logger.traceOn()) {
                    logger.trace("DispatchingJob-task", "lost: " + n);
                }
                object = new Notification(EventClient.NOTIFS_LOST, EventClient.this, EventClient.this.myNotifCounter.getAndIncrement(), System.currentTimeMillis(), "Lost notifications.");
                ((Notification)object).setUserData(new Long(n));
                EventClient.this.broadcaster.sendNotification((Notification)object);
            }
        }
    }
}

