/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.defaults.JmxProperties;
import java.util.logging.Level;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private Number modulus = INTEGER_ZERO;
    private Number offset = INTEGER_ZERO;
    private boolean notify = false;
    private boolean differenceMode = false;
    private Number initThreshold = INTEGER_ZERO;
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};

    @Override
    public synchronized void start() {
        if (this.isActive()) {
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, CounterMonitor.class.getName(), "start", "the monitor is already active");
            return;
        }
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)observedObject;
            counterMonitorObservedObject.setThreshold(this.initThreshold);
            counterMonitorObservedObject.setModulusExceeded(false);
            counterMonitorObservedObject.setEventAlreadyNotified(false);
            counterMonitorObservedObject.setPreviousScanCounter(null);
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized Number getDerivedGauge(ObjectName objectName) {
        return (Number)super.getDerivedGauge(objectName);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        return super.getDerivedGaugeTimeStamp(objectName);
    }

    @Override
    public synchronized Number getThreshold(ObjectName objectName) {
        CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)this.getObservedObject(objectName);
        if (counterMonitorObservedObject == null) {
            return null;
        }
        if (this.offset.longValue() > 0L && this.modulus.longValue() > 0L && counterMonitorObservedObject.getThreshold().longValue() > this.modulus.longValue()) {
            return this.initThreshold;
        }
        return counterMonitorObservedObject.getThreshold();
    }

    @Override
    public synchronized Number getInitThreshold() {
        return this.initThreshold;
    }

    @Override
    public synchronized void setInitThreshold(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null threshold");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative threshold");
        }
        if (this.initThreshold.equals(number)) {
            return;
        }
        this.initThreshold = number;
        int n = 0;
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            this.resetAlreadyNotified(observedObject, n++, 16);
            CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)observedObject;
            counterMonitorObservedObject.setThreshold(number);
            counterMonitorObservedObject.setModulusExceeded(false);
            counterMonitorObservedObject.setEventAlreadyNotified(false);
        }
    }

    @Override
    @Deprecated
    public synchronized Number getDerivedGauge() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return (Number)((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGauge();
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        if (this.observedObjects.isEmpty()) {
            return 0L;
        }
        return ((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGaugeTimeStamp();
    }

    @Override
    @Deprecated
    public synchronized Number getThreshold() {
        return this.getThreshold(this.getObservedObject());
    }

    @Override
    @Deprecated
    public synchronized void setThreshold(Number number) throws IllegalArgumentException {
        this.setInitThreshold(number);
    }

    @Override
    public synchronized Number getOffset() {
        return this.offset;
    }

    @Override
    public synchronized void setOffset(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null offset");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative offset");
        }
        if (this.offset.equals(number)) {
            return;
        }
        this.offset = number;
        int n = 0;
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            this.resetAlreadyNotified(observedObject, n++, 16);
        }
    }

    @Override
    public synchronized Number getModulus() {
        return this.modulus;
    }

    @Override
    public synchronized void setModulus(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null modulus");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative modulus");
        }
        if (this.modulus.equals(number)) {
            return;
        }
        this.modulus = number;
        int n = 0;
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            this.resetAlreadyNotified(observedObject, n++, 16);
            CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)observedObject;
            counterMonitorObservedObject.setModulusExceeded(false);
        }
    }

    @Override
    public synchronized boolean getNotify() {
        return this.notify;
    }

    @Override
    public synchronized void setNotify(boolean bl) {
        if (this.notify == bl) {
            return;
        }
        this.notify = bl;
    }

    @Override
    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    @Override
    public synchronized void setDifferenceMode(boolean bl) {
        if (this.differenceMode == bl) {
            return;
        }
        this.differenceMode = bl;
        for (Monitor.ObservedObject observedObject : this.observedObjects) {
            CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)observedObject;
            counterMonitorObservedObject.setThreshold(this.initThreshold);
            counterMonitorObservedObject.setModulusExceeded(false);
            counterMonitorObservedObject.setEventAlreadyNotified(false);
            counterMonitorObservedObject.setPreviousScanCounter(null);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    private synchronized boolean updateDerivedGauge(Object object, CounterMonitorObservedObject counterMonitorObservedObject) {
        boolean bl;
        if (this.differenceMode) {
            if (counterMonitorObservedObject.getPreviousScanCounter() != null) {
                this.setDerivedGaugeWithDifference((Number)object, null, counterMonitorObservedObject);
                if (((Number)counterMonitorObservedObject.getDerivedGauge()).longValue() < 0L) {
                    if (this.modulus.longValue() > 0L) {
                        this.setDerivedGaugeWithDifference((Number)object, this.modulus, counterMonitorObservedObject);
                    }
                    counterMonitorObservedObject.setThreshold(this.initThreshold);
                    counterMonitorObservedObject.setEventAlreadyNotified(false);
                }
                bl = true;
            } else {
                bl = false;
            }
            counterMonitorObservedObject.setPreviousScanCounter((Number)object);
        } else {
            counterMonitorObservedObject.setDerivedGauge((Number)object);
            bl = true;
        }
        return bl;
    }

    private synchronized MonitorNotification updateNotifications(CounterMonitorObservedObject counterMonitorObservedObject) {
        MonitorNotification monitorNotification = null;
        if (!counterMonitorObservedObject.getEventAlreadyNotified()) {
            if (((Number)counterMonitorObservedObject.getDerivedGauge()).longValue() >= counterMonitorObservedObject.getThreshold().longValue()) {
                if (this.notify) {
                    monitorNotification = new MonitorNotification("jmx.monitor.counter.threshold", this, 0L, 0L, "", null, null, null, counterMonitorObservedObject.getThreshold());
                }
                if (!this.differenceMode) {
                    counterMonitorObservedObject.setEventAlreadyNotified(true);
                }
            }
        } else if (JmxProperties.MONITOR_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder().append("The notification:").append("\n\tNotification observed object = ").append(counterMonitorObservedObject.getObservedObject()).append("\n\tNotification observed attribute = ").append(this.getObservedAttribute()).append("\n\tNotification threshold level = ").append(counterMonitorObservedObject.getThreshold()).append("\n\tNotification derived gauge = ").append(counterMonitorObservedObject.getDerivedGauge()).append("\nhas already been sent");
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, CounterMonitor.class.getName(), "updateNotifications", stringBuilder.toString());
        }
        return monitorNotification;
    }

    private synchronized void updateThreshold(CounterMonitorObservedObject counterMonitorObservedObject) {
        if (((Number)counterMonitorObservedObject.getDerivedGauge()).longValue() >= counterMonitorObservedObject.getThreshold().longValue()) {
            if (this.offset.longValue() > 0L) {
                long l;
                for (l = counterMonitorObservedObject.getThreshold().longValue(); ((Number)counterMonitorObservedObject.getDerivedGauge()).longValue() >= l; l += this.offset.longValue()) {
                }
                switch (counterMonitorObservedObject.getType()) {
                    case INTEGER: {
                        counterMonitorObservedObject.setThreshold((int)l);
                        break;
                    }
                    case BYTE: {
                        counterMonitorObservedObject.setThreshold((byte)l);
                        break;
                    }
                    case SHORT: {
                        counterMonitorObservedObject.setThreshold((short)l);
                        break;
                    }
                    case LONG: {
                        counterMonitorObservedObject.setThreshold(l);
                        break;
                    }
                    default: {
                        JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, CounterMonitor.class.getName(), "updateThreshold", "the threshold type is invalid");
                    }
                }
                if (!this.differenceMode && this.modulus.longValue() > 0L && counterMonitorObservedObject.getThreshold().longValue() > this.modulus.longValue()) {
                    counterMonitorObservedObject.setModulusExceeded(true);
                    counterMonitorObservedObject.setDerivedGaugeExceeded((Number)counterMonitorObservedObject.getDerivedGauge());
                }
                counterMonitorObservedObject.setEventAlreadyNotified(false);
            } else {
                counterMonitorObservedObject.setModulusExceeded(true);
                counterMonitorObservedObject.setDerivedGaugeExceeded((Number)counterMonitorObservedObject.getDerivedGauge());
            }
        }
    }

    private synchronized void setDerivedGaugeWithDifference(Number number, Number number2, CounterMonitorObservedObject counterMonitorObservedObject) {
        long l = number.longValue() - counterMonitorObservedObject.getPreviousScanCounter().longValue();
        if (number2 != null) {
            l += this.modulus.longValue();
        }
        switch (counterMonitorObservedObject.getType()) {
            case INTEGER: {
                counterMonitorObservedObject.setDerivedGauge((int)l);
                break;
            }
            case BYTE: {
                counterMonitorObservedObject.setDerivedGauge((byte)l);
                break;
            }
            case SHORT: {
                counterMonitorObservedObject.setDerivedGauge((short)l);
                break;
            }
            case LONG: {
                counterMonitorObservedObject.setDerivedGauge(l);
                break;
            }
            default: {
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, CounterMonitor.class.getName(), "setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    @Override
    Monitor.ObservedObject createObservedObject(ObjectName objectName) {
        CounterMonitorObservedObject counterMonitorObservedObject = new CounterMonitorObservedObject(objectName);
        counterMonitorObservedObject.setThreshold(this.initThreshold);
        counterMonitorObservedObject.setModulusExceeded(false);
        counterMonitorObservedObject.setEventAlreadyNotified(false);
        counterMonitorObservedObject.setPreviousScanCounter(null);
        return counterMonitorObservedObject;
    }

    @Override
    synchronized boolean isComparableTypeValid(ObjectName objectName, String string, Comparable<?> comparable) {
        CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)this.getObservedObject(objectName);
        if (counterMonitorObservedObject == null) {
            return false;
        }
        if (comparable instanceof Integer) {
            counterMonitorObservedObject.setType(Monitor.NumericalType.INTEGER);
        } else if (comparable instanceof Byte) {
            counterMonitorObservedObject.setType(Monitor.NumericalType.BYTE);
        } else if (comparable instanceof Short) {
            counterMonitorObservedObject.setType(Monitor.NumericalType.SHORT);
        } else if (comparable instanceof Long) {
            counterMonitorObservedObject.setType(Monitor.NumericalType.LONG);
        } else {
            return false;
        }
        return true;
    }

    @Override
    synchronized Comparable<?> getDerivedGaugeFromComparable(ObjectName objectName, String string, Comparable<?> comparable) {
        CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)this.getObservedObject(objectName);
        if (counterMonitorObservedObject == null) {
            return null;
        }
        if (counterMonitorObservedObject.getModulusExceeded() && ((Number)counterMonitorObservedObject.getDerivedGauge()).longValue() < counterMonitorObservedObject.getDerivedGaugeExceeded().longValue()) {
            counterMonitorObservedObject.setThreshold(this.initThreshold);
            counterMonitorObservedObject.setModulusExceeded(false);
            counterMonitorObservedObject.setEventAlreadyNotified(false);
        }
        counterMonitorObservedObject.setDerivedGaugeValid(this.updateDerivedGauge(comparable, counterMonitorObservedObject));
        return (Comparable)counterMonitorObservedObject.getDerivedGauge();
    }

    @Override
    synchronized void onErrorNotification(MonitorNotification monitorNotification) {
        CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)this.getObservedObject(monitorNotification.getObservedObject());
        if (counterMonitorObservedObject == null) {
            return;
        }
        counterMonitorObservedObject.setModulusExceeded(false);
        counterMonitorObservedObject.setEventAlreadyNotified(false);
        counterMonitorObservedObject.setPreviousScanCounter(null);
    }

    @Override
    synchronized MonitorNotification buildAlarmNotification(ObjectName objectName, String string, Comparable<?> comparable) {
        MonitorNotification monitorNotification;
        CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)this.getObservedObject(objectName);
        if (counterMonitorObservedObject == null) {
            return null;
        }
        if (counterMonitorObservedObject.getDerivedGaugeValid()) {
            monitorNotification = this.updateNotifications(counterMonitorObservedObject);
            this.updateThreshold(counterMonitorObservedObject);
        } else {
            monitorNotification = null;
        }
        return monitorNotification;
    }

    @Override
    synchronized boolean isThresholdTypeValid(ObjectName objectName, String string, Comparable<?> comparable) {
        CounterMonitorObservedObject counterMonitorObservedObject = (CounterMonitorObservedObject)this.getObservedObject(objectName);
        if (counterMonitorObservedObject == null) {
            return false;
        }
        Class<? extends Number> clazz = CounterMonitor.classForType(counterMonitorObservedObject.getType());
        return clazz.isInstance(counterMonitorObservedObject.getThreshold()) && CounterMonitor.isValidForType(this.offset, clazz) && CounterMonitor.isValidForType(this.modulus, clazz);
    }

    static class CounterMonitorObservedObject
    extends Monitor.ObservedObject {
        private Number threshold;
        private Number previousScanCounter;
        private boolean modulusExceeded;
        private Number derivedGaugeExceeded;
        private boolean derivedGaugeValid;
        private boolean eventAlreadyNotified;
        private Monitor.NumericalType type;

        public CounterMonitorObservedObject(ObjectName objectName) {
            super(objectName);
        }

        public final synchronized Number getThreshold() {
            return this.threshold;
        }

        public final synchronized void setThreshold(Number number) {
            this.threshold = number;
        }

        public final synchronized Number getPreviousScanCounter() {
            return this.previousScanCounter;
        }

        public final synchronized void setPreviousScanCounter(Number number) {
            this.previousScanCounter = number;
        }

        public final synchronized boolean getModulusExceeded() {
            return this.modulusExceeded;
        }

        public final synchronized void setModulusExceeded(boolean bl) {
            this.modulusExceeded = bl;
        }

        public final synchronized Number getDerivedGaugeExceeded() {
            return this.derivedGaugeExceeded;
        }

        public final synchronized void setDerivedGaugeExceeded(Number number) {
            this.derivedGaugeExceeded = number;
        }

        public final synchronized boolean getDerivedGaugeValid() {
            return this.derivedGaugeValid;
        }

        public final synchronized void setDerivedGaugeValid(boolean bl) {
            this.derivedGaugeValid = bl;
        }

        public final synchronized boolean getEventAlreadyNotified() {
            return this.eventAlreadyNotified;
        }

        public final synchronized void setEventAlreadyNotified(boolean bl) {
            this.eventAlreadyNotified = bl;
        }

        public final synchronized Monitor.NumericalType getType() {
            return this.type;
        }

        public final synchronized void setType(Monitor.NumericalType numericalType) {
            this.type = numericalType;
        }
    }
}

