/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.swing.BakedArrayList;
import sun.swing.plaf.synth.DefaultSynthStyle;
import sun.swing.plaf.synth.StyleAssociation;

class DefaultSynthStyleFactory
extends SynthStyleFactory {
    public static final int NAME = 0;
    public static final int REGION = 1;
    private List<StyleAssociation> _styles;
    private BakedArrayList _tmpList = new BakedArrayList(5);
    private Map<BakedArrayList, SynthStyle> _resolvedStyles;
    private SynthStyle _defaultStyle;

    DefaultSynthStyleFactory() {
        this._styles = new ArrayList<StyleAssociation>();
        this._resolvedStyles = new HashMap<BakedArrayList, SynthStyle>();
    }

    public synchronized void addStyle(DefaultSynthStyle defaultSynthStyle, String string, int n) throws PatternSyntaxException {
        if (string == null) {
            string = ".*";
        }
        if (n == 0) {
            this._styles.add(StyleAssociation.createStyleAssociation(string, defaultSynthStyle, n));
        } else if (n == 1) {
            this._styles.add(StyleAssociation.createStyleAssociation(string.toLowerCase(), defaultSynthStyle, n));
        }
    }

    public synchronized SynthStyle getStyle(JComponent jComponent, Region region) {
        BakedArrayList bakedArrayList = this._tmpList;
        bakedArrayList.clear();
        this.getMatchingStyles(bakedArrayList, jComponent, region);
        if (bakedArrayList.size() == 0) {
            return this.getDefaultStyle();
        }
        bakedArrayList.cacheHashCode();
        SynthStyle synthStyle = this.getCachedStyle(bakedArrayList);
        if (synthStyle == null && (synthStyle = this.mergeStyles(bakedArrayList)) != null) {
            this.cacheStyle(bakedArrayList, synthStyle);
        }
        return synthStyle;
    }

    private SynthStyle getDefaultStyle() {
        if (this._defaultStyle == null) {
            this._defaultStyle = new DefaultSynthStyle();
            ((DefaultSynthStyle)this._defaultStyle).setFont(new FontUIResource("Dialog", 0, 12));
        }
        return this._defaultStyle;
    }

    private void getMatchingStyles(List list, JComponent jComponent, Region region) {
        String string = region.getLowerCaseName();
        String string2 = jComponent.getName();
        if (string2 == null) {
            string2 = "";
        }
        for (int i = this._styles.size() - 1; i >= 0; --i) {
            StyleAssociation styleAssociation;
            String string3 = (styleAssociation = this._styles.get(i)).getID() == 0 ? string2 : string;
            if (!styleAssociation.matches(string3) || list.indexOf(styleAssociation.getStyle()) != -1) continue;
            list.add(styleAssociation.getStyle());
        }
    }

    private void cacheStyle(List list, SynthStyle synthStyle) {
        BakedArrayList bakedArrayList = new BakedArrayList(list);
        this._resolvedStyles.put(bakedArrayList, synthStyle);
    }

    private SynthStyle getCachedStyle(List list) {
        if (list.size() == 0) {
            return null;
        }
        return this._resolvedStyles.get(list);
    }

    private SynthStyle mergeStyles(List list) {
        int n = list.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return (SynthStyle)((DefaultSynthStyle)list.get(0)).clone();
        }
        DefaultSynthStyle defaultSynthStyle = (DefaultSynthStyle)list.get(n - 1);
        defaultSynthStyle = (DefaultSynthStyle)defaultSynthStyle.clone();
        for (int i = n - 2; i >= 0; --i) {
            defaultSynthStyle = ((DefaultSynthStyle)list.get(i)).addTo(defaultSynthStyle);
        }
        return defaultSynthStyle;
    }
}

