/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.LoginOptions;
import sun.security.krb5.internal.util.KerberosFlags;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class TicketFlags
extends KerberosFlags {
    public TicketFlags() {
        super(32);
    }

    public TicketFlags(boolean[] blArray) throws Asn1Exception {
        super(blArray);
        if (blArray.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(int n, byte[] byArray) throws Asn1Exception {
        super(n, byArray);
        if (n > byArray.length * 8 || n > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(DerValue derValue) throws IOException, Asn1Exception {
        this(derValue.getUnalignedBitString(true).toBooleanArray());
    }

    public static TicketFlags parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new TicketFlags(derValue2);
    }

    public Object clone() {
        try {
            return new TicketFlags(this.toBooleanArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean match(LoginOptions loginOptions) {
        boolean bl = false;
        if (this.get(1) == loginOptions.get(1) && this.get(3) == loginOptions.get(3) && this.get(8) == loginOptions.get(8)) {
            bl = true;
        }
        return bl;
    }

    public boolean match(TicketFlags ticketFlags) {
        boolean bl = true;
        for (int i = 0; i <= 31; ++i) {
            if (this.get(i) == ticketFlags.get(i)) continue;
            return false;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = this.toBooleanArray();
        block14: for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            switch (i) {
                case 0: {
                    stringBuffer.append("RESERVED;");
                    continue block14;
                }
                case 1: {
                    stringBuffer.append("FORWARDABLE;");
                    continue block14;
                }
                case 2: {
                    stringBuffer.append("FORWARDED;");
                    continue block14;
                }
                case 3: {
                    stringBuffer.append("PROXIABLE;");
                    continue block14;
                }
                case 4: {
                    stringBuffer.append("PROXY;");
                    continue block14;
                }
                case 5: {
                    stringBuffer.append("MAY-POSTDATE;");
                    continue block14;
                }
                case 6: {
                    stringBuffer.append("POSTDATED;");
                    continue block14;
                }
                case 7: {
                    stringBuffer.append("INVALID;");
                    continue block14;
                }
                case 8: {
                    stringBuffer.append("RENEWABLE;");
                    continue block14;
                }
                case 9: {
                    stringBuffer.append("INITIAL;");
                    continue block14;
                }
                case 10: {
                    stringBuffer.append("PRE-AUTHENT;");
                    continue block14;
                }
                case 11: {
                    stringBuffer.append("HW-AUTHENT;");
                }
            }
        }
        String string = stringBuffer.toString();
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

