/*	$NetBSD$	*/

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Julian Coleman.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define MODENAME_LEN 18

#define REG_TGC 0x6000

#define REG_PLL 0x0000
#define REG_NUM_PLL 0
#define REG_PFC 0x1000
#define REG_NUM_PFC 1
#define REG_USC 0x1001
#define REG_NUM_USC 2
#define REG_DAC 0x5001
#define REG_NUM_DAC 3
#define REG_VBE 0x6001
#define REG_NUM_VBE 4
#define REG_VBS 0x6002
#define REG_NUM_VBS 5
#define REG_VSE 0x6003
#define REG_NUM_VSE 6
#define REG_VSS 0x6004
#define REG_NUM_VSS 7
#define REG_HRE 0x6005
#define REG_NUM_HRE 8
#define REG_HBE 0x6006
#define REG_NUM_HBE 9
#define REG_HBS 0x6007
#define REG_NUM_HBS 10
#define REG_HSE 0x6008
#define REG_NUM_HSE 11
#define REG_HSS 0x6009
#define REG_NUM_HSS 12
#define REG_HCE 0x600a
#define REG_NUM_HCE 13
#define REG_HCS 0x600b
#define REG_NUM_HCS 14
#define REG_EPE 0x600c
#define REG_NUM_EPE 15
#define REG_EIE 0x600d
#define REG_NUM_EIE 16
#define REG_EIS 0x600e
#define REG_NUM_EIS 17
#define DAC_REG_NUM 18

static uint32_t dac_reg_list[DAC_REG_NUM] = {
	REG_PLL,
	REG_PFC,
	REG_USC,
	REG_DAC,
	REG_VBE,
	REG_VBS,
	REG_VSE,
	REG_VSS,
	REG_HRE,
	REG_HBE,
	REG_HBS,
	REG_HSE,
	REG_HSS,
	REG_HCE,
	REG_HCS,
	REG_EPE,
	REG_EIE,
	REG_EIS,
};

static uint32_t dac_reg_mask[DAC_REG_NUM] = {
	0xffff,
	0x0003,
	0x07ff,
	0x007f,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
	0x0fff,
};
static uint32_t dac_reg_tgc_mask = 0x007f;

struct ffb_dac_modes {
	char modename[MODENAME_LEN];
	uint32_t versions;
#define VERSION_FFB1		0x00000001
#define VERSION_FFB2		0x00000002
#define VERSION_FFB2p		0x00000004
#define VERSION_FFB1_3D		0x00000010
#define VERSION_FFB2_3D		0x00000020
#define VERSION_FFB2p3D		0x00000040
#define VERSION_AFB		0x00000100
#define VERSION_ZBUFFER		0x00001000
#define VERSION_DOUBLE_BUFFER	0x00002000
	uint32_t reg_list[DAC_REG_NUM];
	uint32_t reg_tgc;
};

struct ffb_dac_modes dac_mode_list[] = {
	{
		/* From PROM */
		"640x480x60i",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x5dd0,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0025,	/* 0x6001 */
			0x0205,	/* 0x6002 */
			0x0005,	/* 0x6003 */
			0x020c,	/* 0x6004 */
			0x00a5,	/* 0x6005 */
			0x003b,	/* 0x6006 */
			0x00b8,	/* 0x6007 */
			0x001c,	/* 0x6008 */
			0x00c2,	/* 0x6009 */
			0x00b4,	/* 0x600a */
			0x0037,	/* 0x600b */
			0x000d,	/* 0x600c */
			0x000b,	/* 0x600d */
			0x0206,	/* 0x600e */
		},
		0x0063	/* 0x6000 */
	},

	{
		/* From PROM */
		"768x575x50i",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x5b34,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x002b,	/* 0x6001 */
			0x026a,	/* 0x6002 */
			0x0004,	/* 0x6003 */
			0x0270,	/* 0x6004 */
			0x00c8,	/* 0x6005 */
			0x004c,	/* 0x6006 */
			0x00e2,	/* 0x6007 */
			0x0022,	/* 0x6008 */
			0x00e9,	/* 0x6009 */
			0x00de,	/* 0x600a */
			0x0048,	/* 0x600b */
			0x0010,	/* 0x600c */
			0x0009,	/* 0x600d */
			0x026b,	/* 0x600e */
		},
		0x0063	/* 0x6000 */
	},

	{
		/* From PROM */
		"960x680x108s",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x42a5,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0025,	/* 0x6001 */
			0x02cd,	/* 0x6002 */
			0x0003,	/* 0x6003 */
			0x02d0,	/* 0x6004 */
			0x025f,	/* 0x6005 */
			0x007f,	/* 0x6006 */
			0x025f,	/* 0x6007 */
			0x001f,	/* 0x6008 */
			0x027f,	/* 0x6009 */
			0x025b,	/* 0x600a */
			0x007b,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"960x680x112s",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x432d,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0027,	/* 0x6001 */
			0x02cf,	/* 0x6002 */
			0x0007,	/* 0x6003 */
			0x02d1,	/* 0x6004 */
			0x0257,	/* 0x6005 */
			0x0083,	/* 0x6006 */
			0x0263,	/* 0x6007 */
			0x0017,	/* 0x6008 */
			0x026f,	/* 0x6009 */
			0x025f,	/* 0x600a */
			0x007f,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"640x480x60",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x54c3,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0010, /* 0x5001 */
			0x0022,	/* 0x6001 */
			0x0202,	/* 0x6002 */
			0x0001,	/* 0x6003 */
			0x020c,	/* 0x6004 */
			0x015f,	/* 0x6005 */
			0x0047,	/* 0x6006 */
			0x0187,	/* 0x6007 */
			0x002f,	/* 0x6008 */
			0x018f,	/* 0x6009 */
			0x0183,	/* 0x600a */
			0x0043,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"800x600x75",
		VERSION_FFB2p3D,
		{
			0x4cc2,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0110, /* 0x5001 */
			0x0017,	/* 0x6001 */
			0x026f,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x0270,	/* 0x6004 */
			0x01e7,	/* 0x6005 */
			0x0077,	/* 0x6006 */
			0x0207,	/* 0x6007 */
			0x0027,	/* 0x6008 */
			0x020f,	/* 0x6009 */
			0x0203,	/* 0x600a */
			0x0073,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"1024x768x60",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x4ab0,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0110, /* 0x5001 */
			0x0022,	/* 0x6001 */
			0x0322,	/* 0x6002 */
			0x0005,	/* 0x6003 */
			0x0325,	/* 0x6004 */
			0x025b,	/* 0x6005 */
			0x0093,	/* 0x6006 */
			0x0293,	/* 0x6007 */
			0x0043,	/* 0x6008 */
			0x029f,	/* 0x6009 */
			0x028f,	/* 0x600a */
			0x008f,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"1024x768x70",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x4bce, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0010, /* 0x5001 */
			0x0022, /* 0x6001 */
			0x0322, /* 0x6002 */
			0x0005, /* 0x6003 */
			0x0325, /* 0x6004 */
			0x0253, /* 0x6005 */
			0x008b, /* 0x6006 */
			0x028b, /* 0x6007 */
			0x0043, /* 0x6008 */
			0x0297, /* 0x6009 */
			0x0287, /* 0x600a */
			0x0087, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		/* Register 0x0000 different from AFB */
		"1024x768x75",
		VERSION_FFB2p3D,
		{
			0x4b46,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0110, /* 0x5001 */
			0x001e,	/* 0x6001 */
			0x031e,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x031f,	/* 0x6004 */
			0x025f,	/* 0x6005 */
			0x0087,	/* 0x6006 */
			0x0287,	/* 0x6007 */
			0x002f,	/* 0x6008 */
			0x028f,	/* 0x6009 */
			0x0283,	/* 0x600a */
			0x0083,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		/* Register 0x0000 different from FFB - this is 80Hz! */
		"1024x768x75",
		VERSION_AFB,
		{
			0x4b4b,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0110, /* 0x5001 */
			0x001e,	/* 0x6001 */
			0x031e,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x031f,	/* 0x6004 */
			0x025f,	/* 0x6005 */
			0x0087,	/* 0x6006 */
			0x0287,	/* 0x6007 */
			0x002f,	/* 0x6008 */
			0x028f,	/* 0x6009 */
			0x0283,	/* 0x600a */
			0x0083,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1024x768x77",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x4b4b, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x0022, /* 0x6001 */
			0x0322, /* 0x6002 */
			0x0003, /* 0x6003 */
			0x0324, /* 0x6004 */
			0x0267, /* 0x6005 */
			0x0097, /* 0x6006 */
			0x0297, /* 0x6007 */
			0x001f, /* 0x6008 */
			0x02a7, /* 0x6009 */
			0x0293, /* 0x600a */
			0x0093, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1024x800x84",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x4ac6, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x0022, /* 0x6001 */
			0x0342, /* 0x6002 */
			0x0003, /* 0x6003 */
			0x0344, /* 0x6004 */
			0x027d, /* 0x6005 */
			0x008b, /* 0x6006 */
			0x028b, /* 0x6007 */
			0x003f, /* 0x6008 */
			0x0293, /* 0x6009 */
			0x0287, /* 0x600a */
			0x0087, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		/* Register 0x6004 different from AFB */
		"1152x900x66",
		VERSION_FFB2p3D,
		{
			0x4ac6, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x0022, /* 0x6001 */
			0x03a6, /* 0x6002 */
			0x0003, /* 0x6003 */
			0x03a8, /* 0x6004 */
			0x02bb, /* 0x6005 */
			0x00a7, /* 0x6006 */
			0x02e7, /* 0x6007 */
			0x003f, /* 0x6008 */
			0x02fb, /* 0x6009 */
			0x02e3, /* 0x600a */
			0x00a3, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		/* Register 0x6004 different from FFB */
		"1152x900x66",
		VERSION_AFB,
		{
			0x4ac6, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x0022, /* 0x6001 */
			0x03a6, /* 0x6002 */
			0x0003, /* 0x6003 */
			0x03a6, /* 0x6004 */
			0x02bb, /* 0x6005 */
			0x00a7, /* 0x6006 */
			0x02e7, /* 0x6007 */
			0x003f, /* 0x6008 */
			0x02fb, /* 0x6009 */
			0x02e3, /* 0x600a */
			0x00a3, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1152x900x76",
		VERSION_FFB1,
		{
			0x42a8, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x0408, /* 0x1001 */
			0x0010, /* 0x5001 */
			0x0028, /* 0x6001 */
			0x03ac, /* 0x6002 */
			0x0007, /* 0x6003 */
			0x03ae, /* 0x6004 */
			0x02cf, /* 0x6005 */
			0x00a7, /* 0x6006 */
			0x02e7, /* 0x6007 */
			0x001f, /* 0x6008 */
			0x02ef, /* 0x6009 */
			0x02e3, /* 0x600a */
			0x00a3, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1152x900x76",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x42a8, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x0028, /* 0x6001 */
			0x03ac, /* 0x6002 */
			0x0007, /* 0x6003 */
			0x03ae, /* 0x6004 */
			0x02af, /* 0x6005 */
			0x009f, /* 0x6006 */
			0x02df, /* 0x6007 */
			0x003f, /* 0x6008 */
			0x02ef, /* 0x6009 */
			0x02db, /* 0x600a */
			0x009b, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1280x800x76",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x432d, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x002a, /* 0x6001 */
			0x034a, /* 0x6002 */
			0x0006, /* 0x6003 */
			0x034d, /* 0x6004 */
			0x02d7, /* 0x6005 */
			0x0086, /* 0x6006 */
			0x0306, /* 0x6007 */
			0x0038, /* 0x6008 */
			0x0310, /* 0x6009 */
			0x0302, /* 0x600a */
			0x0082, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1280x1024x60",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x42a8,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0110, /* 0x5001 */
			0x0028, /* 0x6001 */
			0x0428, /* 0x6002 */
			0x0002, /* 0x6003 */
			0x0429, /* 0x6004 */
			0x0313, /* 0x6005 */
			0x00b3, /* 0x6006 */
			0x0333, /* 0x6007 */
			0x0037, /* 0x6008 */
			0x034b, /* 0x6009 */
			0x032f, /* 0x600a */
			0x00af, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"1280x1024x67",
		VERSION_FFB1_3D | VERSION_FFB2p3D | VERSION_AFB,
		{
			0x4334, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x0028, /* 0x6001 */
			0x0428, /* 0x6002 */
			0x0007, /* 0x6003 */
			0x042a, /* 0x6004 */
			0x02ff, /* 0x6005 */
			0x00a7, /* 0x6006 */
			0x0327, /* 0x6007 */
			0x0037, /* 0x6008 */
			0x032f, /* 0x6009 */
			0x0323, /* 0x600a */
			0x00a3, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1280x1024x75",
		VERSION_FFB2p3D,
		{
			0x42b2,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0110, /* 0x5001 */
			0x0028,	/* 0x6001 */
			0x0428,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x0429,	/* 0x6004 */
			0x0303,	/* 0x6005 */
			0x00c3,	/* 0x6006 */
			0x0343,	/* 0x6007 */
			0x0047,	/* 0x6008 */
			0x034b,	/* 0x6009 */
			0x033f,	/* 0x600a */
			0x00bf,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"1280x1024x76",
		VERSION_FFB2p3D | VERSION_AFB,
		{
			0x42b2, /* 0x0000 */
			0x0002, /* 0x1000 */
			0x012c, /* 0x1001 */
			0x0090, /* 0x5001 */
			0x0027, /* 0x6001 */
			0x0427, /* 0x6002 */
			0x0007, /* 0x6003 */
			0x0429, /* 0x6004 */
			0x031f, /* 0x6005 */
			0x00af, /* 0x6006 */
			0x032f, /* 0x6007 */
			0x001f, /* 0x6008 */
			0x033f, /* 0x6009 */
			0x032b, /* 0x600a */
			0x00ab, /* 0x600b */
			0x0000, /* 0x600c */
			0x0000, /* 0x600d */
			0x0000, /* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From VESA timings */
		"1280x1024x85",
		VERSION_FFB2p3D,
		{
			0x4346,	/* 0x0000 */
			0x0002,	/* 0x1000 */
			0x012c,	/* 0x1001 */
			0x0090,	/* 0x5001 */
			0x002e,	/* 0x6001 */
			0x042e,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x042f,	/* 0x6004 */
			0x030f,	/* 0x6005 */
			0x00c7,	/* 0x6006 */
			0x0347,	/* 0x6007 */
			0x004f,	/* 0x6008 */
			0x035f,	/* 0x6009 */
			0x0343,	/* 0x600a */
			0x00c3,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"1440x900x76",
		VERSION_FFB2p3D,
		{
			0x42b2,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0029,	/* 0x6001 */
			0x03ad,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x03af,	/* 0x6004 */
			0x01ad,	/* 0x6005 */
			0x0063,	/* 0x6006 */
			0x01cb,	/* 0x6007 */
			0x0027,	/* 0x6008 */
			0x01d5,	/* 0x6009 */
			0x01c7,	/* 0x600a */
			0x005f,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1600x1000x66",
		VERSION_FFB2p3D,
		{
			0x42b2,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0024,	/* 0x6001 */
			0x040c,	/* 0x6002 */
			0x0004,	/* 0x6003 */
			0x040e,	/* 0x6004 */
			0x01c9,	/* 0x6005 */
			0x0051,	/* 0x6006 */
			0x01e1,	/* 0x6007 */
			0x0021,	/* 0x6008 */
			0x01eb,	/* 0x6009 */
			0x01dd,	/* 0x600a */
			0x004d,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1600x1000x76",
		VERSION_FFB2p3D,
		{
			0x42bf,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0030,	/* 0x6001 */
			0x0418,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x041a,	/* 0x6004 */
			0x01dd,	/* 0x6005 */
			0x007b,	/* 0x6006 */
			0x020b,	/* 0x6007 */
			0x0035,	/* 0x6008 */
			0x0213,	/* 0x6009 */
			0x0207,	/* 0x600a */
			0x0077,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From VESA timings */
		"1600x1200x60",
		VERSION_FFB2p3D,
		{
			0x4230,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090,	/* 0x5001 */
			0x0030,	/* 0x6001 */
			0x04e0,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x04e1,	/* 0x6004 */
			0x01eb,	/* 0x6005 */
			0x007b,	/* 0x6006 */
			0x020b,	/* 0x6007 */
			0x002f,	/* 0x6008 */
			0x021b,	/* 0x6009 */
			0x0207,	/* 0x600a */
			0x0077,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From VESA timings */
		"1600x1200x70",
		VERSION_FFB2p3D,
		{
			0x4238,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090,	/* 0x5001 */
			0x0030,	/* 0x6001 */
			0x04e0,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x04e1,	/* 0x6004 */
			0x01eb,	/* 0x6005 */
			0x007b,	/* 0x6006 */
			0x020b,	/* 0x6007 */
			0x002f,	/* 0x6008 */
			0x021b,	/* 0x6009 */
			0x0207,	/* 0x600a */
			0x0077,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"1600x1200x75",
		VERSION_FFB2p3D,
		{
			0x423c,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0110, /* 0x5001 */
			0x0030,	/* 0x6001 */
			0x04e0,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x04e1,	/* 0x6004 */
			0x01eb,	/* 0x6005 */
			0x007b,	/* 0x6006 */
			0x020b,	/* 0x6007 */
			0x002f,	/* 0x6008 */
			0x021b,	/* 0x6009 */
			0x0207,	/* 0x600a */
			0x0077,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/* From PROM */
		"1600x1280x76",
		VERSION_FFB2p3D,
		{
			0x42d0,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0039,	/* 0x6001 */
			0x0539,	/* 0x6002 */
			0x0007,	/* 0x6003 */
			0x053b,	/* 0x6004 */
			0x01db,	/* 0x6005 */
			0x007b,	/* 0x6006 */
			0x020b,	/* 0x6007 */
			0x0035,	/* 0x6008 */
			0x0211,	/* 0x6009 */
			0x0207,	/* 0x600a */
			0x0077,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/*
		   From Modeline:
		     Modeline "1680x1050x60"   146.571   1680 1784 1968 2256   1050 1051 1054 1083  -hsync -vsync
		 */
		"1680x1050x60",
		VERSION_FFB2p3D,
		{
			0x43cc,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090,	/* 0x5001 */
			0x001f,	/* 0x6001 */
			0x0439,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x043a,	/* 0x6004 */
			0x0205,	/* 0x6005 */
			0x0047,	/* 0x6006 */
			0x01eb,	/* 0x6007 */
			0x002d,	/* 0x6008 */
			0x0233,	/* 0x6009 */
			0x01e7,	/* 0x600a */
			0x0043,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/*
		   From Modeline:
		     Modeline "1920x1080x60" 145.8 1920 1968 2000 2176 1080 1083 1089 1118 -hsync -vsync
		 */
		"1920x1080x60",
		VERSION_FFB2p3D,
		{
			0x42b6,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090,	/* 0x5001 */
			0x0022,	/* 0x6001 */
			0x045a,	/* 0x6002 */
			0x0005,	/* 0x6003 */
			0x045d,	/* 0x6004 */
			0x0217,	/* 0x6005 */
			0x0033,	/* 0x6006 */
			0x0213,	/* 0x6007 */
			0x0007,	/* 0x6008 */
			0x021f,	/* 0x6009 */
			0x020f,	/* 0x600a */
			0x002f,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1920x1080x72",
		VERSION_FFB2p3D,
		{
			0x42d0,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0058,	/* 0x6001 */
			0x0490,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x0493,	/* 0x6004 */
			0x0249,	/* 0x6005 */
			0x0093,	/* 0x6006 */
			0x0273,	/* 0x6007 */
			0x0035,	/* 0x6008 */
			0x027f,	/* 0x6009 */
			0x026f,	/* 0x600a */
			0x008f,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/*
		   1920x1200x59.9 (74.0kHz, 153.90MHz)
		 */
		"1920x1200x60",
		VERSION_FFB2p3D,
		{
			0x42b9,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0100,	/* 0x1001 */
			0x0000,	/* 0x5001 */
			0x001f,	/* 0x6001 */
			0x04cf,	/* 0x6002 */
			0x0005,	/* 0x6003 */
			0x04d2,	/* 0x6004 */
			0x01ff,	/* 0x6005 */
			0x0023,	/* 0x6006 */
			0x0203,	/* 0x6007 */
			0x0007,	/* 0x6008 */
			0x0207,	/* 0x6009 */
			0x01ff,	/* 0x600a */
			0x001f,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x002b	/* 0x6000 */
	},

	{
		/*
		   From Modeline:
		     Modeline "1920x1200"   207.9   1920 2056 2264 2608   1200 1201 1204 1245  -hsync -vsync
		 */
		"1920x1200x64",
		VERSION_FFB2p3D,
		{
			0x42cd,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090,	/* 0x5001 */
			0x002b,	/* 0x6001 */
			0x04db,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x04dc,	/* 0x6004 */
			0x0257,	/* 0x6005 */
			0x0089,	/* 0x6006 */
			0x0269,	/* 0x6007 */
			0x0033,	/* 0x6008 */
			0x028b,	/* 0x6009 */
			0x0265,	/* 0x600a */
			0x0085,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},

	{
		/* From PROM */
		"1920x1200x70",
		VERSION_FFB2p3D,
		{
			0x4241,	/* 0x0000 */
			0x0003,	/* 0x1000 */
			0x0108,	/* 0x1001 */
			0x0090, /* 0x5001 */
			0x0026,	/* 0x6001 */
			0x04d6,	/* 0x6002 */
			0x0002,	/* 0x6003 */
			0x04d7,	/* 0x6004 */
			0x023b,	/* 0x6005 */
			0x008e,	/* 0x6006 */
			0x026e,	/* 0x6007 */
			0x0038,	/* 0x6008 */
			0x0274,	/* 0x6009 */
			0x026a,	/* 0x600a */
			0x008a,	/* 0x600b */
			0x0000,	/* 0x600c */
			0x0000,	/* 0x600d */
			0x0000,	/* 0x600e */
		},
		0x0033	/* 0x6000 */
	},
};

/* EDID registers */

#define REG_UCT	0x1001	/* User Control */
#define REG_MPD 0x8001	/* Monitor Serial Interface Data */
#define REG_MPS 0x8002	/* Monitor Serial Interface Control */

/* 0x1001 user control */
#define UCR_BLN 	0x02	/* Asynchronus Blank */

/* 0x8001 monitor serial port data */
#define MPD_SCL 	0x01    /* SCL Data */
#define MPD_SDA 	0x02    /* SDA Data */
   
/* 0x8002 monitor serial port sense */
#define MPS_SCL 	0x01    /* SCL Sense */
#define MPS_SDA 	0x02    /* SDA Sense */

#define EDID_DATA_LEN	128
