/* $NetBSD$ */

/*-
 * Copyright (c) 2017 Jared McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "firmload.h"

static void
usage(const char *pn)
{
	fprintf(stderr, "usage: %s drvname imgname\n", pn);
	exit(EXIT_FAILURE);
}

int
main(int argc, char *argv[])
{
	struct stat st;
	const char *drvname, *imgname;
	int fd;

	if (argc != 3)
		usage(argv[0]);
		/* NOTREACHED */

	drvname = argv[1];
	imgname = argv[2];

	fd = firmware_open(drvname, imgname);
	if (fd == -1)
		err(EXIT_FAILURE, "couldn't open firmware %s/%s",
		    drvname, imgname);

	if (fstat(fd, &st) == -1)
		err(EXIT_FAILURE, "couldn't fstat firmware %s/%s",
		    drvname, imgname);

	printf("Loaded %ju byte firmware image\n", st.st_size);

	close(fd);

	return EXIT_SUCCESS;
}
