/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.ccvs.ui.CVSDecoratorConfiguration;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.core.ExceptionCollector;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamUI;

public class CVSLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IResourceStateChangeListener,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.team.cvs.ui.decorator";
    private static ImageDescriptor dirty;
    private static ImageDescriptor checkedIn;
    private static ImageDescriptor noRemoteDir;
    private static ImageDescriptor added;
    private static ImageDescriptor merged;
    private static ImageDescriptor newResource;
    private static ImageDescriptor edited;
    private static ExceptionCollector exceptions;
    private static String DECORATOR_FORMAT;
    private static SimpleDateFormat decorateFormatter;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public CVSLightweightDecorator() {
        ResourceStateChangeListeners.getListener().addResourceStateChangeListener((IResourceStateChangeListener)this);
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
        CVSUIPlugin.addPropertyChangeListener(this);
        CVSProviderPlugin.broadcastDecoratorEnablementChanged((boolean)true);
    }

    public static boolean isDirty(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isIgnored() && cvsResource.isModified(null);
    }

    public static boolean isDirty(IResource resource) {
        if (!resource.exists()) {
            return false;
        }
        try {
            return CVSLightweightDecorator.isDirty(CVSWorkspaceRoot.getCVSResourceFor((IResource)resource));
        }
        catch (CVSException e) {
            boolean accessible = resource.getProject().isAccessible();
            if (accessible) {
                CVSLightweightDecorator.handleException((Exception)((Object)e));
            }
            return accessible;
        }
    }

    private CVSTeamProvider getCVSProviderFor(IResource resource) {
        RepositoryProvider p = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
        if (p == null) {
            return null;
        }
        return (CVSTeamProvider)p;
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = CVSLightweightDecorator.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        return null;
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = this.getResource(element);
        if (resource == null || resource.getType() == 8) {
            return;
        }
        CVSTeamProvider cvsProvider = this.getCVSProviderFor(resource);
        if (cvsProvider == null) {
            return;
        }
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        try {
            if (cvsResource.isIgnored()) {
                return;
            }
        }
        catch (CVSException e) {
            CVSLightweightDecorator.handleException((Exception)((Object)e));
            return;
        }
        boolean isDirty = false;
        boolean computeDeepDirtyCheck = this.isDeepDirtyCalculationEnabled();
        int type = resource.getType();
        if (type == 1 || computeDeepDirtyCheck) {
            isDirty = CVSLightweightDecorator.isDirty(resource);
        }
        CVSLightweightDecorator.decorateTextLabel(resource, decoration, isDirty, true, null);
        ImageDescriptor overlay = CVSLightweightDecorator.getOverlay(resource, isDirty, cvsProvider);
        if (overlay != null) {
            decoration.addOverlay(overlay);
        }
    }

    private boolean isDeepDirtyCalculationEnabled() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        return store.getBoolean("pref_calculate_dirty");
    }

    public static void decorateTextLabel(IResource resource, IDecoration decoration, boolean isDirty, boolean showRevisions, String overrideRevision) {
        try {
            CVSTag tag;
            HashMap<String, String> bindings = new HashMap<String, String>(3);
            String format = "";
            IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
            if (!resource.isAccessible() || resource.getLocation() == null) {
                return;
            }
            int type = resource.getType();
            format = type == 2 ? store.getString("pref_foldertext_decoration") : (type == 4 ? store.getString("pref_projecttext_decoration") : store.getString("pref_filetext_decoration"));
            if (isDirty) {
                bindings.put("dirty_flag", store.getString("pref_dirty_flag"));
            }
            if ((tag = CVSLightweightDecorator.getTagToShow(resource)) != null) {
                Date date;
                String name = tag.getName();
                if (tag.getType() == 3 && (date = tag.asDate()) != null) {
                    name = decorateFormatter.format(date);
                }
                bindings.put("tag", name);
            }
            if (type != 1) {
                ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)resource));
                FolderSyncInfo folderInfo = folder.getFolderSyncInfo();
                if (folderInfo != null) {
                    ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(folderInfo.getRoot());
                    bindings.put("host", location.getHost());
                    bindings.put("method", location.getMethod().getName());
                    bindings.put("user", location.getUsername());
                    bindings.put("root", location.getRootDirectory());
                    bindings.put("repository", folderInfo.getRepository());
                }
            } else {
                format = store.getString("pref_filetext_decoration");
                ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                ResourceSyncInfo fileInfo = file.getSyncInfo();
                if (fileInfo != null) {
                    if (fileInfo.isAdded()) {
                        bindings.put("added_flag", store.getString("pref_added_flag"));
                    } else if (showRevisions) {
                        if (overrideRevision != null) {
                            bindings.put("revision", overrideRevision);
                        } else {
                            bindings.put("revision", fileInfo.getRevision());
                        }
                    }
                    Command.KSubstOption option = fileInfo.getKeywordMode() != null ? fileInfo.getKeywordMode() : Command.KSubstOption.fromFile((IFile)((IFile)resource));
                    bindings.put("keyword", option.getShortDisplayText());
                } else {
                    Command.KSubstOption option = Command.KSubstOption.fromFile((IFile)((IFile)resource));
                    bindings.put("keyword", option.getShortDisplayText());
                }
            }
            CVSDecoratorConfiguration.decorate(decoration, format, bindings);
        }
        catch (CVSException e) {
            CVSLightweightDecorator.handleException((Exception)((Object)e));
            return;
        }
    }

    protected static CVSTag getTagToShow(IResource resource) throws CVSException {
        FolderSyncInfo parentInfo;
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        CVSEntryLineTag tag = null;
        boolean managed = false;
        if (cvsResource.isFolder()) {
            FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
            if (folderInfo != null) {
                tag = folderInfo.getTag();
                managed = true;
            }
        } else {
            ResourceSyncInfo info = ((ICVSFile)cvsResource).getSyncInfo();
            if (info != null) {
                tag = info.getTag();
                managed = true;
            }
        }
        ICVSFolder parent = cvsResource.getParent();
        if (parent != null && managed && (parentInfo = parent.getFolderSyncInfo()) != null) {
            CVSEntryLineTag parentTag = parentInfo.getTag();
            parentTag = parentTag == null ? CVSTag.DEFAULT : parentTag;
            Object object = tag = tag == null ? CVSTag.DEFAULT : tag;
            if (parentTag.getName().equals(tag.getName())) {
                tag = null;
            }
        }
        return tag;
    }

    public static ImageDescriptor getOverlay(IResource resource, boolean isDirty, CVSTeamProvider provider) {
        boolean decorateEdited;
        boolean showDirty;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        boolean showNewResources = store.getBoolean("pref_show_newresource");
        if (showNewResources) {
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            try {
                if (cvsResource.exists()) {
                    boolean isNewResource = false;
                    if (cvsResource.isFolder()) {
                        if (!((ICVSFolder)cvsResource).isCVSFolder()) {
                            isNewResource = true;
                        }
                    } else if (!cvsResource.isManaged()) {
                        isNewResource = true;
                    }
                    if (isNewResource) {
                        return newResource;
                    }
                }
            }
            catch (CVSException e) {
                CVSLightweightDecorator.handleException((Exception)((Object)e));
                return null;
            }
        }
        if ((showDirty = store.getBoolean("pref_show_overlaydirty")) && isDirty) {
            return dirty;
        }
        boolean showAdded = store.getBoolean("pref_show_added");
        if (showAdded && resource.getType() == 1) {
            try {
                if (resource.getLocation() != null) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                    ResourceSyncInfo info = cvsFile.getSyncInfo();
                    if (info != null && info.isNeedsMerge(cvsFile.getTimeStamp())) {
                        return merged;
                    }
                    if (info != null && info.isAdded()) {
                        return added;
                    }
                }
            }
            catch (CVSException e) {
                CVSLightweightDecorator.handleException((Exception)((Object)e));
                return null;
            }
        }
        try {
            decorateEdited = provider.isWatchEditEnabled();
        }
        catch (CVSException e1) {
            CVSLightweightDecorator.handleException((Exception)((Object)e1));
            decorateEdited = false;
        }
        if (decorateEdited && resource.getType() == 1 && !resource.isReadOnly() && CVSWorkspaceRoot.hasRemote((IResource)resource)) {
            return edited;
        }
        boolean showHasRemote = store.getBoolean("pref_show_hasremote");
        if (showHasRemote && CVSWorkspaceRoot.hasRemote((IResource)resource)) {
            if (resource.getType() != 1) {
                ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)resource));
                try {
                    FolderSyncInfo folderSyncInfo = cvsFolder.getFolderSyncInfo();
                    if (folderSyncInfo != null && folderSyncInfo.isVirtualDirectory()) {
                        return noRemoteDir;
                    }
                }
                catch (CVSException e) {
                    CVSLightweightDecorator.handleException((Exception)((Object)e));
                }
            }
            return checkedIn;
        }
        return null;
    }

    private void addWithParents(IResource resource, Set resources) {
        IResource current = resource;
        while (current.getType() != 8) {
            resources.add(current);
            current = current.getParent();
        }
    }

    public static void refresh() {
        CVSUIPlugin.getPlugin().getWorkbench().getDecoratorManager().update(ID);
    }

    public void refresh(IProject project) {
        final ArrayList resources = new ArrayList();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    resources.add(resource);
                    return true;
                }
            });
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
        }
        catch (CoreException e) {
            CVSLightweightDecorator.handleException((Exception)((Object)e));
        }
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void externalSyncInfoChange(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceModified(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceStateChanged(IResource[] changedResources) {
        HashSet<IResource> resourcesToUpdate = new HashSet<IResource>();
        boolean showingDeepDirtyIndicators = this.isDeepDirtyCalculationEnabled();
        for (int i = 0; i < changedResources.length; ++i) {
            IResource resource = changedResources[i];
            if (showingDeepDirtyIndicators) {
                this.addWithParents(resource, resourcesToUpdate);
                continue;
            }
            resourcesToUpdate.add(resource);
        }
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resourcesToUpdate.toArray()));
    }

    public void projectConfigured(IProject project) {
        this.refresh(project);
    }

    public void projectDeconfigured(IProject project) {
        this.refresh(project);
    }

    private void postLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CVSLightweightDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    public void dispose() {
        super.dispose();
        CVSProviderPlugin.broadcastDecoratorEnablementChanged((boolean)false);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        CVSUIPlugin.removePropertyChangeListener(this);
    }

    private static void handleException(Exception e) {
        exceptions.handleException(e);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (prop.equals(TeamUI.GLOBAL_IGNORES_CHANGED)) {
            CVSLightweightDecorator.refresh();
        } else if (prop.equals("org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED")) {
            CVSLightweightDecorator.refresh();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        exceptions = new ExceptionCollector(Policy.bind("CVSDecorator.exceptionMessage"), "org.eclipse.team.cvs.ui", 4, CVSUIPlugin.getPlugin().getLog());
        DECORATOR_FORMAT = "yyyy/MM/dd HH:mm:ss";
        decorateFormatter = new SimpleDateFormat(DECORATOR_FORMAT, Locale.getDefault());
        dirty = new CachedImageDescriptor(TeamUIPlugin.getImageDescriptor((String)"ovr/dirty_ov.gif"));
        checkedIn = new CachedImageDescriptor(TeamUIPlugin.getImageDescriptor((String)"ovr/version_controlled.gif"));
        added = new CachedImageDescriptor(TeamUIPlugin.getImageDescriptor((String)"ovr/version_controlled.gif"));
        merged = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/merged_ov.gif"));
        newResource = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/question_ov.gif"));
        edited = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/edited_ov.gif"));
        noRemoteDir = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/no_remotedir_ov.gif"));
    }

    public static class Decoration
    implements IDecoration {
        public String prefix;
        public String suffix;
        public ImageDescriptor overlay;

        public void addPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void addSuffix(String suffix) {
            this.suffix = suffix;
        }

        public void addOverlay(ImageDescriptor overlay) {
            this.overlay = overlay;
        }

        public void addOverlay(ImageDescriptor overlay, int quadrant) {
        }
    }

    public static class CachedImageDescriptor
    extends ImageDescriptor {
        ImageDescriptor descriptor;
        ImageData data;

        public CachedImageDescriptor(ImageDescriptor descriptor) {
            Assert.isNotNull((Object)descriptor);
            this.descriptor = descriptor;
        }

        public ImageData getImageData() {
            if (this.data == null) {
                this.data = this.descriptor.getImageData();
            }
            return this.data;
        }
    }
}

