/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.NestedRegistryModelObject;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.osgi.framework.Bundle;

public class Namespace
extends NestedRegistryModelObject {
    private String hostId;
    private IExtensionPoint[] extensionPoints;
    private IExtension[] extensions;
    private transient ResourceBundle resourceBundle;
    private boolean missingResourceBundle = false;
    private Bundle bundle;

    public String getUniqueIdentifier() {
        return this.getName();
    }

    public void setUniqueIdentifier(String value) {
        this.setName(value);
    }

    public void setExtensions(IExtension[] value) {
        this.extensions = value;
    }

    public IExtension getExtension(String id) {
        if (id == null) {
            return null;
        }
        IExtension[] list = this.getExtensions();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!id.equals(list[i].getSimpleIdentifier())) continue;
            return list[i];
        }
        return null;
    }

    public IExtension[] getExtensions() {
        return this.extensions == null ? new IExtension[]{} : this.extensions;
    }

    public void setExtensionPoints(IExtensionPoint[] value) {
        this.extensionPoints = value;
    }

    public IExtensionPoint getExtensionPoint(String xpt) {
        if (xpt == null) {
            return null;
        }
        IExtensionPoint[] list = this.getExtensionPoints();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!xpt.equals(list[i].getSimpleIdentifier())) continue;
            return list[i];
        }
        return null;
    }

    public IExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints == null ? new IExtensionPoint[]{} : this.extensionPoints;
    }

    public void setHostIdentifier(String value) {
        this.hostId = value;
    }

    public String getHostIdentifier() {
        return this.hostId;
    }

    public boolean isFragment() {
        return this.hostId != null;
    }

    public String toString() {
        return "Namespace: " + this.getName();
    }

    public long getId() {
        return this.bundle == null ? -1L : this.bundle.getBundleId();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle value) {
        this.bundle = value;
    }

    public String getResourceString(String value) {
        if (this.resourceBundle != null) {
            return ResourceTranslator.getResourceString(null, value, this.resourceBundle);
        }
        if (this.missingResourceBundle) {
            return value;
        }
        if (this.resourceBundle == null) {
            try {
                this.resourceBundle = ResourceTranslator.getResourceBundle(this.bundle);
            }
            catch (MissingResourceException e) {
                this.resourceBundle = null;
            }
        }
        if (this.resourceBundle == null) {
            this.missingResourceBundle = true;
            return value;
        }
        return ResourceTranslator.getResourceString(null, value, this.resourceBundle);
    }
}

