/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;

public class RefactoringScanner {
    private String fPattern;
    private IScanner fScanner;
    private ISourceRange fNoFlyZone;
    private Set fMatches;

    public RefactoringScanner(String pattern) {
        Assert.isNotNull(pattern);
        this.fPattern = pattern;
    }

    public void scan(ICompilationUnit cu) throws JavaModelException {
        char[] chars = cu.getBuffer().getCharacters();
        this.fMatches = new HashSet();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(chars);
        IImportContainer importContainer = cu.getImportContainer();
        this.fNoFlyZone = importContainer.exists() ? importContainer.getSourceRange() : null;
        this.doScan();
    }

    public void scan(String text) {
        char[] chars = text.toCharArray();
        this.fMatches = new HashSet();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(chars);
        this.doScan();
    }

    private void doScan() {
        try {
            int token = this.fScanner.getNextToken();
            while (token != 158) {
                switch (token) {
                    case 45: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        this.parseCurrentToken();
                    }
                }
                token = this.fScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private static boolean isWholeWord(String value, int from, int to) {
        char ch;
        if (from > 0 && (Character.isLetterOrDigit(ch = value.charAt(from - 1)) || ch == '_')) {
            return false;
        }
        return to >= value.length() || !Character.isLetterOrDigit(ch = value.charAt(to)) && ch != '_';
    }

    private void parseCurrentToken() {
        String value = new String(this.fScanner.getRawTokenSource());
        int start = this.fScanner.getCurrentTokenStartPosition();
        int index = value.indexOf(this.fPattern);
        while (index != -1) {
            if (RefactoringScanner.isWholeWord(value, index, index + this.fPattern.length())) {
                this.addMatch(start + index);
            }
            index = value.indexOf(this.fPattern, index + 1);
        }
    }

    private void addMatch(int matchStart) {
        if (this.fNoFlyZone != null && this.fNoFlyZone.getOffset() <= matchStart && matchStart < this.fNoFlyZone.getOffset() + this.fNoFlyZone.getLength()) {
            return;
        }
        this.fMatches.add(new Integer(matchStart));
    }

    public Set getMatches() {
        return this.fMatches;
    }
}

