/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public abstract class SelectionListenerAction
extends BaseSelectionListenerAction {
    private static final List EMPTY_LIST = Arrays.asList(new Object[0]);
    private boolean selectionDirty = true;
    private List resources;
    private List nonResources;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    protected SelectionListenerAction(String text) {
        super(text);
    }

    protected void clearCache() {
        this.selectionDirty = true;
        this.resources = null;
        this.nonResources = null;
    }

    private final void computeResources() {
        this.resources = null;
        this.nonResources = null;
        Iterator e = this.getStructuredSelection().iterator();
        while (e.hasNext()) {
            Object resource;
            Object next = e.next();
            if (next instanceof IResource) {
                if (this.resources == null) {
                    this.resources = new ArrayList(this.getStructuredSelection().size());
                }
                this.resources.add(next);
                continue;
            }
            if (next instanceof IAdaptable && (resource = ((IAdaptable)next).getAdapter(class$org$eclipse$core$resources$IResource == null ? SelectionListenerAction.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource)) != null) {
                if (this.resources == null) {
                    this.resources = new ArrayList(this.getStructuredSelection().size());
                }
                this.resources.add(resource);
                continue;
            }
            if (this.nonResources == null) {
                this.nonResources = new ArrayList(1);
            }
            this.nonResources.add(next);
        }
    }

    protected List getSelectedNonResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.nonResources == null) {
            return EMPTY_LIST;
        }
        return this.nonResources;
    }

    protected List getSelectedResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.resources == null) {
            return EMPTY_LIST;
        }
        return this.resources;
    }

    protected boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }

    protected boolean selectionIsOfType(int resourceMask) {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        Iterator e = this.getSelectedResources().iterator();
        while (e.hasNext()) {
            IResource next = (IResource)e.next();
            if (this.resourceIsType(next, resourceMask)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

