/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.ui.internal.activities.AbstractActivityRegistry;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.internal.util.ConfigurationElementMemento;

final class ExtensionActivityRegistry
extends AbstractActivityRegistry {
    private List activityRequirementBindingDefinitions;
    private List activityDefinitions;
    private List activityPatternBindingDefinitions;
    private List categoryActivityBindingDefinitions;
    private List categoryDefinitions;
    private List defaultEnabledActivities;
    private IExtensionRegistry extensionRegistry;

    ExtensionActivityRegistry(IExtensionRegistry extensionRegistry) {
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        this.extensionRegistry = extensionRegistry;
        this.extensionRegistry.addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent registryChangeEvent) {
                IExtensionDelta[] extensionDeltas = registryChangeEvent.getExtensionDeltas("org.eclipse.ui", "activities");
                if (extensionDeltas.length != 0) {
                    try {
                        ExtensionActivityRegistry.this.load();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getNamespace(IConfigurationElement configurationElement) {
        IExtension extension;
        String namespace = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            namespace = extension.getNamespace();
        }
        return namespace;
    }

    private void load() throws IOException {
        if (this.activityRequirementBindingDefinitions == null) {
            this.activityRequirementBindingDefinitions = new ArrayList();
        } else {
            this.activityRequirementBindingDefinitions.clear();
        }
        if (this.activityDefinitions == null) {
            this.activityDefinitions = new ArrayList();
        } else {
            this.activityDefinitions.clear();
        }
        if (this.activityPatternBindingDefinitions == null) {
            this.activityPatternBindingDefinitions = new ArrayList();
        } else {
            this.activityPatternBindingDefinitions.clear();
        }
        if (this.categoryActivityBindingDefinitions == null) {
            this.categoryActivityBindingDefinitions = new ArrayList();
        } else {
            this.categoryActivityBindingDefinitions.clear();
        }
        if (this.categoryDefinitions == null) {
            this.categoryDefinitions = new ArrayList();
        } else {
            this.categoryDefinitions.clear();
        }
        if (this.defaultEnabledActivities == null) {
            this.defaultEnabledActivities = new ArrayList();
        } else {
            this.defaultEnabledActivities.clear();
        }
        IConfigurationElement[] configurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.activities");
        for (int i = 0; i < configurationElements.length; ++i) {
            IConfigurationElement configurationElement = configurationElements[i];
            String name = configurationElement.getName();
            if ("activityRequirementBinding".equals(name)) {
                this.readActivityRequirementBindingDefinition(configurationElement);
                continue;
            }
            if ("activity".equals(name)) {
                this.readActivityDefinition(configurationElement);
                continue;
            }
            if ("activityPatternBinding".equals(name)) {
                this.readActivityPatternBindingDefinition(configurationElement);
                continue;
            }
            if ("categoryActivityBinding".equals(name)) {
                this.readCategoryActivityBindingDefinition(configurationElement);
                continue;
            }
            if ("category".equals(name)) {
                this.readCategoryDefinition(configurationElement);
                continue;
            }
            if (!"defaultEnablement".equals(name)) continue;
            this.readDefaultEnablement(configurationElement);
        }
        boolean activityRegistryChanged = false;
        if (!((Object)this.activityRequirementBindingDefinitions).equals(((AbstractActivityRegistry)this).activityRequirementBindingDefinitions)) {
            ((AbstractActivityRegistry)this).activityRequirementBindingDefinitions = Collections.unmodifiableList(this.activityRequirementBindingDefinitions);
            activityRegistryChanged = true;
        }
        if (!((Object)this.activityDefinitions).equals(((AbstractActivityRegistry)this).activityDefinitions)) {
            ((AbstractActivityRegistry)this).activityDefinitions = Collections.unmodifiableList(this.activityDefinitions);
            activityRegistryChanged = true;
        }
        if (!((Object)this.activityPatternBindingDefinitions).equals(((AbstractActivityRegistry)this).activityPatternBindingDefinitions)) {
            ((AbstractActivityRegistry)this).activityPatternBindingDefinitions = Collections.unmodifiableList(this.activityPatternBindingDefinitions);
            activityRegistryChanged = true;
        }
        if (!((Object)this.categoryActivityBindingDefinitions).equals(((AbstractActivityRegistry)this).categoryActivityBindingDefinitions)) {
            ((AbstractActivityRegistry)this).categoryActivityBindingDefinitions = Collections.unmodifiableList(this.categoryActivityBindingDefinitions);
            activityRegistryChanged = true;
        }
        if (!((Object)this.categoryDefinitions).equals(((AbstractActivityRegistry)this).categoryDefinitions)) {
            ((AbstractActivityRegistry)this).categoryDefinitions = Collections.unmodifiableList(this.categoryDefinitions);
            activityRegistryChanged = true;
        }
        if (!((Object)this.defaultEnabledActivities).equals(((AbstractActivityRegistry)this).defaultEnabledActivities)) {
            ((AbstractActivityRegistry)this).defaultEnabledActivities = Collections.unmodifiableList(this.defaultEnabledActivities);
            activityRegistryChanged = true;
        }
        if (activityRegistryChanged) {
            this.fireActivityRegistryChanged();
        }
    }

    private void readDefaultEnablement(IConfigurationElement configurationElement) {
        String enabledActivity = Persistence.readDefaultEnablement(new ConfigurationElementMemento(configurationElement));
        if (enabledActivity != null) {
            this.defaultEnabledActivities.add(enabledActivity);
        }
    }

    private void readActivityRequirementBindingDefinition(IConfigurationElement configurationElement) {
        ActivityRequirementBindingDefinition activityRequirementBindingDefinition = Persistence.readActivityRequirementBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (activityRequirementBindingDefinition != null) {
            this.activityRequirementBindingDefinitions.add(activityRequirementBindingDefinition);
        }
    }

    private void readActivityDefinition(IConfigurationElement configurationElement) {
        ActivityDefinition activityDefinition = Persistence.readActivityDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (activityDefinition != null) {
            this.activityDefinitions.add(activityDefinition);
        }
    }

    private void readActivityPatternBindingDefinition(IConfigurationElement configurationElement) {
        ActivityPatternBindingDefinition activityPatternBindingDefinition = Persistence.readActivityPatternBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (activityPatternBindingDefinition != null) {
            this.activityPatternBindingDefinitions.add(activityPatternBindingDefinition);
        }
    }

    private void readCategoryActivityBindingDefinition(IConfigurationElement configurationElement) {
        CategoryActivityBindingDefinition categoryActivityBindingDefinition = Persistence.readCategoryActivityBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (categoryActivityBindingDefinition != null) {
            this.categoryActivityBindingDefinitions.add(categoryActivityBindingDefinition);
        }
    }

    private void readCategoryDefinition(IConfigurationElement configurationElement) {
        CategoryDefinition categoryDefinition = Persistence.readCategoryDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (categoryDefinition != null) {
            this.categoryDefinitions.add(categoryDefinition);
        }
    }
}

