/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.BuildModel;

public class WorkspaceBuildModel
extends BuildModel
implements IEditableModel {
    private IFile file;
    private boolean dirty;
    private boolean editable = true;

    public WorkspaceBuildModel(IFile file) {
        this.setFile(file);
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(event.getChangeType() != 99);
        super.fireModelChanged(event);
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return swriter.toString();
    }

    public IFile getFile() {
        return this.file;
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void load() {
        if (this.file == null) {
            return;
        }
        if (this.file.exists()) {
            InputStream stream = null;
            boolean outOfSync = false;
            try {
                stream = this.file.getContents(false);
            }
            catch (CoreException e) {
                outOfSync = true;
            }
            if (outOfSync) {
                try {
                    stream = this.file.getContents(true);
                }
                catch (CoreException e) {
                    return;
                }
            }
            try {
                this.load(stream, outOfSync);
                stream.close();
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        } else {
            this.build = new Build();
            this.build.setModel(this);
            this.loaded = true;
        }
    }

    public boolean isInSync() {
        return this.isInSync(this.file.getLocation().toFile());
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.file.getLocation().toFile());
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("8859_1"));
            if (this.file.exists()) {
                this.file.setContents((InputStream)stream, false, false, null);
            } else {
                this.file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(PrintWriter writer) {
        this.getBuild().write("", writer);
        this.dirty = false;
    }

    public void setDirty(boolean newDirty) {
        this.dirty = newDirty;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void setFile(IFile newFile) {
        this.file = newFile;
    }
}

