/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ModifierChangeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;

public class ModifierCorrectionSubProcessor {
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;

    /*
     * WARNING - void declaration
     */
    public static void addNonAccessibleReferenceProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind, int relevance) throws CoreException {
        String name;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                binding = ((SimpleName)selectedNode).resolveBinding();
                break;
            }
            case 40: {
                binding = ((QualifiedName)selectedNode).resolveBinding();
                break;
            }
            case 43: {
                binding = ((SimpleType)selectedNode).resolveBinding();
                break;
            }
            case 32: {
                binding = ((MethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 48: {
                binding = ((SuperMethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 22: {
                binding = ((FieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 47: {
                binding = ((SuperFieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 14: {
                binding = ((ClassInstanceCreation)selectedNode).resolveConstructorBinding();
                break;
            }
            case 46: {
                binding = ((SuperConstructorInvocation)selectedNode).resolveConstructorBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        boolean isLocalVar = false;
        if (binding instanceof IMethodBinding) {
            typeBinding = ((IMethodBinding)binding).getDeclaringClass();
            name = binding.getName() + "()";
        } else if (binding instanceof IVariableBinding) {
            typeBinding = ((IVariableBinding)binding).getDeclaringClass();
            name = binding.getName();
            isLocalVar = !((IVariableBinding)binding).isField();
        } else if (binding instanceof ITypeBinding) {
            typeBinding = (ITypeBinding)binding;
            name = binding.getName();
        } else {
            return;
        }
        if (typeBinding != null && typeBinding.isFromSource() || isLocalVar) {
            ICompilationUnit targetCU;
            int includedModifiers = 0;
            int excludedModifiers = 0;
            switch (kind) {
                case 2: {
                    void var9_10;
                    excludedModifiers = 7;
                    includedModifiers = ModifierCorrectionSubProcessor.getNeededVisibility(selectedNode, typeBinding);
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changevisibility.description", new String[]{var9_10, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                    break;
                }
                case 1: {
                    void var9_10;
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertostatic.description", var9_10);
                    includedModifiers = 8;
                    break;
                }
                case 4: {
                    void var9_10;
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertononstatic.description", var9_10);
                    excludedModifiers = 8;
                    break;
                }
                case 3: {
                    void var9_10;
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertodefault.description", var9_10);
                    excludedModifiers = 2;
                    break;
                }
                case 5: {
                    void var9_10;
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertononfinal.description", var9_10);
                    excludedModifiers = 16;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            ICompilationUnit iCompilationUnit = targetCU = isLocalVar ? cu : ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), typeBinding);
            if (targetCU != null) {
                void var13_13;
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCompletionProposal((String)var13_13, targetCU, binding, selectedNode, includedModifiers, excludedModifiers, relevance, image));
            }
        }
        if (kind == 2 && binding.getKind() == 3 && Modifier.isPrivate((int)binding.getModifiers()) && (selectedNode instanceof SimpleName || selectedNode instanceof FieldAccess && ((FieldAccess)selectedNode).getExpression() instanceof ThisExpression)) {
            UnresolvedElementsSubProcessor.getVariableProposals(context, problem, proposals);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addChangeOverriddenModfierProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind) throws JavaModelException {
        ICompilationUnit targetCU;
        IMethodBinding defining;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding method = ((MethodDeclaration)selectedNode).resolveBinding();
        ITypeBinding curr = method.getDeclaringClass();
        IMethodBinding overriddenClass = null;
        if (kind == 2 && problem.getProblemId() != 67109274 && (defining = Bindings.findMethodDefininition(method, false)) != null) {
            int excludedModifiers = 7;
            int includedModifiers = JdtFlags.getVisibilityCode((IBinding)defining);
            String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemethodvisibility.description", new String[]{ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCompletionProposal(label, cu, (IBinding)method, selectedNode, includedModifiers, excludedModifiers, 8, image));
        }
        if (overriddenClass == null && curr.getSuperclass() != null) {
            curr = curr.getSuperclass();
            overriddenClass = Bindings.findMethodInType(curr, method.getName(), method.getParameterTypes());
        }
        if (overriddenClass != null && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), curr)) != null) {
            void var12_15;
            void var13_17;
            void var11_13;
            String methodName = curr.getName() + '.' + overriddenClass.getName();
            switch (kind) {
                case 2: {
                    int excludedModifiers = 7;
                    int includedModifiers = JdtFlags.getVisibilityCode((IBinding)method);
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changeoverriddenvisibility.description", new String[]{methodName, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                    break;
                }
                case 5: {
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemethodtononfinal.description", methodName);
                    int excludedModifiers = 16;
                    int includedModifiers = 0;
                    break;
                }
                case 4: {
                    String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemethodtononstatic.description", methodName);
                    int excludedModifiers = 8;
                    int includedModifiers = 0;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCompletionProposal((String)var11_13, targetCU, (IBinding)overriddenClass, selectedNode, (int)var13_17, (int)var12_15, 7, image));
        }
    }

    public static void addNonFinalLocalProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertofinal.description", binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    public static void addRemoveInvalidModfiersProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            selectedNode = ((MethodDeclaration)selectedNode).getName();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding != null) {
            String methodName = binding.getName();
            String label = problem.getProblemId() == 67109271 ? CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemethodtononstatic.description", methodName) : CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.removeinvalidmodifiers.description", methodName);
            int excludedModifiers = 0;
            int includedModifiers = 0;
            switch (problem.getProblemId()) {
                case 67109271: {
                    excludedModifiers = 8;
                    break;
                }
                case 67109223: {
                    excludedModifiers = -1026;
                    break;
                }
                case 16777519: {
                    excludedModifiers = -3074;
                    break;
                }
                case 16777518: {
                    excludedModifiers = -3090;
                    break;
                }
                case 33554775: {
                    excludedModifiers = -1042;
                    break;
                }
                case 0x1000131: 
                case 16777525: {
                    excludedModifiers = -2058;
                    break;
                }
                case 0x1000130: {
                    excludedModifiers = -3104;
                    break;
                }
                case 16777522: {
                    excludedModifiers = -3089;
                    break;
                }
                case 67109220: {
                    excludedModifiers = -17;
                    break;
                }
                case 33554774: {
                    excludedModifiers = -224;
                    break;
                }
                case 67109222: {
                    excludedModifiers = -3360;
                    break;
                }
                case 67109260: {
                    excludedModifiers = -17;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, includedModifiers, excludedModifiers, relevance, image));
        }
    }

    private static String getVisibilityString(int code) {
        if (Modifier.isPublic((int)code)) {
            return "public";
        }
        if (Modifier.isProtected((int)code)) {
            return "protected";
        }
        if (Modifier.isPrivate((int)code)) {
            return "private";
        }
        return CorrectionMessages.getString("ModifierCorrectionSubProcessor.default");
    }

    private static int getNeededVisibility(ASTNode currNode, ITypeBinding targetType) {
        ITypeBinding currNodeBinding = Bindings.getBindingOfParentType(currNode);
        if (currNodeBinding == null) {
            return 1;
        }
        if (Bindings.isSuperType(targetType, currNodeBinding)) {
            return 4;
        }
        if (currNodeBinding.getPackage().getKey().equals(targetType.getPackage().getKey())) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static void addAbstractMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        boolean hasNoBody;
        void var6_6;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        ASTNode parentType = ASTResolving.findParentType((ASTNode)var6_6);
        TypeDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        if (parentType instanceof TypeDeclaration) {
            parentTypeDecl = (TypeDeclaration)parentType;
            parentIsAbstractClass = !parentTypeDecl.isInterface() && Modifier.isAbstract((int)parentTypeDecl.getModifiers());
        }
        boolean bl = hasNoBody = var6_6.getBody() == null;
        if (problem.getProblemId() == 67109227 || parentIsAbstractClass) {
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            int newModifiers = var6_6.getModifiers() & 0xFFFFFBFF;
            rewrite.set((ASTNode)var6_6, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
            if (hasNoBody) {
                Block newBody = ast.newBlock();
                rewrite.set((ASTNode)var6_6, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
                Expression expr = ASTNodeFactory.newDefaultExpression(ast, var6_6.getReturnType(), var6_6.getExtraDimensions());
                if (expr != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expr);
                    newBody.statements().add(returnStatement);
                }
            }
            String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removeabstract.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
        }
        if (!hasNoBody && problem.getProblemId() == 603979889) {
            ASTRewrite rewrite = ASTRewrite.create((AST)var6_6.getAST());
            rewrite.remove((ASTNode)var6_6.getBody(), null);
            String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removebody.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal2);
        }
        if (problem.getProblemId() == 67109227 && parentTypeDecl != null) {
            ASTRewriteCorrectionProposal proposal = ModifierCorrectionSubProcessor.getMakeTypeAbstractProposal(cu, parentTypeDecl, 5);
            proposals.add(proposal);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addNativeMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        void var6_6;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        int newModifiers = var6_6.getModifiers() & 0xFFFFFEFF;
        rewrite.set((ASTNode)var6_6, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        Block newBody = ast.newBlock();
        rewrite.set((ASTNode)var6_6, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
        Expression expr = ASTNodeFactory.newDefaultExpression(ast, var6_6.getReturnType(), var6_6.getExtraDimensions());
        if (expr != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expr);
            newBody.statements().add(returnStatement);
        }
        String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removenative.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
        proposals.add(proposal);
        if (var6_6.getBody() != null) {
            ASTRewrite rewrite2 = ASTRewrite.create((AST)var6_6.getAST());
            rewrite2.remove((ASTNode)var6_6.getBody(), null);
            String label2 = CorrectionMessages.getString("ModifierCorrectionSubProcessor.removebody.description");
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, cu, rewrite2, 5, image2);
            proposals.add(proposal2);
        }
    }

    public static ASTRewriteCorrectionProposal getMakeTypeAbstractProposal(ICompilationUnit cu, TypeDeclaration typeDeclaration, int relevance) {
        ASTRewrite rewrite = ASTRewrite.create((AST)typeDeclaration.getAST());
        int newModifiers = typeDeclaration.getModifiers() | 0x400;
        rewrite.set((ASTNode)typeDeclaration, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.addabstract.description", typeDeclaration.getName().getIdentifier());
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, relevance, image);
        return proposal;
    }

    public static void addMethodRequiresBodyProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Expression expression;
        ICompilationUnit cu = context.getCompilationUnit();
        AST ast = context.getASTRoot().getAST();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        int newModifiers = decl.getModifiers() & 0xFFFFFBFF;
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        Block body = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)body, null);
        Type returnType = decl.getReturnType();
        if (!decl.isConstructor() && (expression = ASTNodeFactory.newDefaultExpression(ast, returnType, decl.getExtraDimensions())) != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        String label = CorrectionMessages.getString("ModifierCorrectionSubProcessor.addmissingbody.description");
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 9, image);
        proposals.add(proposal);
        rewrite = ASTRewrite.create((AST)ast);
        newModifiers = decl.getModifiers() | 0x400;
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        String label2 = CorrectionMessages.getString("ModifierCorrectionSubProcessor.setmethodabstract.description");
        Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, cu, rewrite, 8, image2);
        proposals.add(proposal2);
    }

    public static void addNeedToEmulateProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = CorrectionMessages.getFormattedString("ModifierCorrectionSubProcessor.changemodifiertofinal.description", binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }
}

