/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.ui.internal.ide.HelpIdeResources;
import org.eclipse.help.ui.internal.search.HelpSearchQuery;
import org.eclipse.help.ui.internal.search.HelpSearchResult;
import org.eclipse.help.ui.internal.search.ResultTableContentProvider;
import org.eclipse.help.ui.internal.search.ResultTableLabelProvider;
import org.eclipse.help.ui.internal.search.SortAction;
import org.eclipse.help.ui.internal.search.SorterByScore;
import org.eclipse.help.ui.internal.search.SorterByTitle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.PartInitException;

public class ResultPage
extends AbstractTextSearchViewPage {
    final int SORT_BY_SCORE = 0;
    final int SORT_BY_TITLE = 1;
    private ResultTableContentProvider contentProvider;
    private SortAction currentSortAction;
    private SortAction sortByScoreAction = new SortAction(HelpIdeResources.getString("HelpSearchResultPage.score"), this, 0);
    private SortAction sortByTitleAction = new SortAction(HelpIdeResources.getString("HelpSearchResultPage.title"), this, 1);

    public ResultPage() {
        super(1);
        this.currentSortAction = this.sortByScoreAction;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        Object element = match.getElement();
        try {
            final SearchHit hit = (SearchHit)element;
            HelpSearchQuery query = (HelpSearchQuery)((HelpSearchResult)this.getInput()).getQuery();
            final String urlQuery = query.getQueryData().toURLQuery();
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        BaseHelpSystem.getHelpDisplay().displaySearch(urlQuery, hit.getHref(), false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " doesn't support tree mode.");
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setSorter((ViewerSorter)new SorterByScore());
        viewer.setLabelProvider((IBaseLabelProvider)new ResultTableLabelProvider());
        this.contentProvider = new ResultTableContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(HelpIdeResources.getString("HelpSearchResultPage.sortBy"));
        sortMenu.add((IAction)this.sortByScoreAction);
        sortMenu.add((IAction)this.sortByTitleAction);
        this.sortByScoreAction.setChecked(this.currentSortAction == this.sortByScoreAction);
        this.sortByTitleAction.setChecked(this.currentSortAction == this.sortByTitleAction);
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setSortOrder(SortAction action) {
        this.currentSortAction = action;
        StructuredViewer viewer = this.getViewer();
        if (action.getSortOrder() == 0) {
            viewer.setSorter((ViewerSorter)new SorterByScore());
        } else {
            viewer.setSorter((ViewerSorter)new SorterByTitle());
        }
    }
}

