/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.util.Arrays;
import java.util.List;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo {
    private static final long serialVersionUID = -1935722590756516193L;
    private Descriptor modelMBeanDescriptor;
    private MBeanAttributeInfo[] modelMBeanAttributes;
    private MBeanConstructorInfo[] modelMBeanConstructors;
    private MBeanNotificationInfo[] modelMBeanNotifications;
    private MBeanOperationInfo[] modelMBeanOperations;

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        this(className, description, attributes, constructors, operations, notifications, null);
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeanDescriptor) {
        super(className, description, attributes, constructors, operations, notifications);
        this.modelMBeanAttributes = attributes;
        this.modelMBeanConstructors = constructors;
        this.modelMBeanNotifications = notifications;
        this.modelMBeanOperations = operations;
        this.checkAndSetDescriptor(mbeanDescriptor);
    }

    public Descriptor[] getDescriptors(String type) throws MBeanException, RuntimeOperationsException {
        if (type == null) {
            Descriptor[] attrs = this.getDescriptors("attribute");
            Descriptor[] opers = this.getDescriptors("operation");
            Descriptor[] ctors = this.getDescriptors("constructor");
            Descriptor[] notifs = this.getDescriptors("notification");
            Descriptor[] all = new Descriptor[attrs.length + opers.length + ctors.length + notifs.length + 1];
            int i = 0;
            all[i] = this.getMBeanDescriptor();
            System.arraycopy(attrs, 0, all, ++i, attrs.length);
            System.arraycopy(opers, 0, all, i += attrs.length, opers.length);
            System.arraycopy(ctors, 0, all, i += opers.length, ctors.length);
            System.arraycopy(notifs, 0, all, i += ctors.length, notifs.length);
            return all;
        }
        if (type.equals("attribute")) {
            MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
            if (attrs == null) {
                return new Descriptor[0];
            }
            Descriptor[] attributes = new Descriptor[attrs.length];
            int i = 0;
            while (i < attrs.length) {
                ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                attributes[i] = attr.getDescriptor();
                ++i;
            }
            return attributes;
        }
        if (type.equals("operation")) {
            MBeanOperationInfo[] opers = this.modelMBeanOperations;
            if (opers == null) {
                return new Descriptor[0];
            }
            Descriptor[] operations = new Descriptor[opers.length];
            int i = 0;
            while (i < opers.length) {
                ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                operations[i] = oper.getDescriptor();
                ++i;
            }
            return operations;
        }
        if (type.equals("constructor")) {
            MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
            if (ctors == null) {
                return new Descriptor[0];
            }
            Descriptor[] constructors = new Descriptor[ctors.length];
            int i = 0;
            while (i < ctors.length) {
                ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                constructors[i] = ctor.getDescriptor();
                ++i;
            }
            return constructors;
        }
        if (type.equals("notification")) {
            MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
            if (notifs == null) {
                return new Descriptor[0];
            }
            Descriptor[] notifications = new Descriptor[notifs.length];
            int i = 0;
            while (i < notifs.length) {
                ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                notifications[i] = notif.getDescriptor();
                ++i;
            }
            return notifications;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor type"));
    }

    public void setDescriptors(Descriptor[] descriptors) throws MBeanException, RuntimeOperationsException {
        if (descriptors == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptors cannot be null"));
        }
        RuntimeOperationsException x = null;
        int i = 0;
        while (i < descriptors.length) {
            try {
                this.setDescriptor(descriptors[i], null);
            }
            catch (RuntimeOperationsException ignored) {
                x = ignored;
            }
            ++i;
        }
        if (x != null) {
            throw x;
        }
    }

    public Descriptor getDescriptor(String name, String type) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor name cannot be null"));
        }
        if (type == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor type cannot be null"));
        }
        if (type.equals("MBean")) {
            return this.getMBeanDescriptor();
        }
        Descriptor[] descrs = this.getDescriptors(type);
        int i = 0;
        while (i < descrs.length) {
            Descriptor descr = descrs[i];
            if (name.equals(descr.getFieldValue("name"))) {
                return descr;
            }
            ++i;
        }
        return null;
    }

    public void setDescriptor(Descriptor descriptor, String descriptorType) throws MBeanException, RuntimeOperationsException {
        block15: {
            MBeanOperationInfo[] opers;
            String name;
            block19: {
                block18: {
                    block17: {
                        block16: {
                            if (descriptor == null) {
                                return;
                            }
                            if (descriptorType == null) {
                                descriptorType = (String)descriptor.getFieldValue("descriptorType");
                                if (descriptorType == null) {
                                    throw new RuntimeOperationsException(new IllegalArgumentException("Field descriptorType in the given descriptor is not valid"));
                                }
                                if (descriptorType.equals("operation")) {
                                    String role = (String)descriptor.getFieldValue("role");
                                    if (role == null) {
                                        throw new RuntimeOperationsException(new IllegalArgumentException("Field role in the given descriptor is not valid"));
                                    }
                                    descriptorType = role;
                                }
                            }
                            if ((name = (String)descriptor.getFieldValue("name")) == null) {
                                throw new RuntimeOperationsException(new IllegalArgumentException("Field name in the given descriptor is not valid"));
                            }
                            if (!descriptorType.equals("MBean")) break block16;
                            this.setMBeanDescriptor(descriptor);
                            break block15;
                        }
                        if (!descriptorType.equals("attribute")) break block17;
                        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
                        if (attrs == null) break block15;
                        int i = 0;
                        while (i < attrs.length) {
                            ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                            if (name.equals(attr.getName())) {
                                attr.setDescriptor(descriptor);
                                break block15;
                            }
                            ++i;
                        }
                        break block15;
                    }
                    if (!descriptorType.equals("notification")) break block18;
                    MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
                    if (notifs == null) break block15;
                    int i = 0;
                    while (i < notifs.length) {
                        ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                        if (name.equals(notif.getName())) {
                            notif.setDescriptor(descriptor);
                            break block15;
                        }
                        ++i;
                    }
                    break block15;
                }
                if (!descriptorType.equals("constructor")) break block19;
                MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
                if (ctors == null) break block15;
                int i = 0;
                while (i < ctors.length) {
                    ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                    if (name.equals(ctor.getName())) {
                        ctor.setDescriptor(descriptor);
                        break block15;
                    }
                    ++i;
                }
                break block15;
            }
            if (descriptorType.equals("operation") && (opers = this.modelMBeanOperations) != null) {
                int i = 0;
                while (i < opers.length) {
                    ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                    if (name.equals(oper.getName())) {
                        oper.setDescriptor(descriptor);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public ModelMBeanAttributeInfo getAttribute(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                if (name.equals(attr.getName())) {
                    return (ModelMBeanAttributeInfo)attr.clone();
                }
                ++i;
            }
        }
        return null;
    }

    public ModelMBeanOperationInfo getOperation(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanOperationInfo[] opers = this.modelMBeanOperations;
        if (opers != null) {
            int i = 0;
            while (i < opers.length) {
                ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                if (name.equals(oper.getName())) {
                    return (ModelMBeanOperationInfo)oper.clone();
                }
                ++i;
            }
        }
        return null;
    }

    public ModelMBeanConstructorInfo getConstructor(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
        if (ctors != null) {
            int i = 0;
            while (i < ctors.length) {
                ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                if (name.equals(ctor.getName())) {
                    return (ModelMBeanConstructorInfo)ctor.clone();
                }
                ++i;
            }
        }
        return null;
    }

    public ModelMBeanNotificationInfo getNotification(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
        if (notifs != null) {
            int i = 0;
            while (i < notifs.length) {
                ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                if (name.equals(notif.getName())) {
                    return (ModelMBeanNotificationInfo)notif.clone();
                }
                ++i;
            }
        }
        return null;
    }

    public Descriptor getMBeanDescriptor() throws MBeanException, RuntimeOperationsException {
        return (Descriptor)this.modelMBeanDescriptor.clone();
    }

    public void setMBeanDescriptor(Descriptor descriptor) throws MBeanException, RuntimeOperationsException {
        if (descriptor == null) {
            this.modelMBeanDescriptor = this.createDefaultMBeanDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.modelMBeanDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    public MBeanConstructorInfo[] getConstructors() {
        MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
        if (ctors == null) {
            return null;
        }
        MBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[ctors.length];
        int i = 0;
        while (i < ctors.length) {
            ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
            constructors[i] = (ModelMBeanConstructorInfo)ctor.clone();
            ++i;
        }
        return constructors;
    }

    public MBeanAttributeInfo[] getAttributes() {
        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
        if (attrs == null) {
            return null;
        }
        MBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[attrs.length];
        int i = 0;
        while (i < attrs.length) {
            ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
            attributes[i] = (ModelMBeanAttributeInfo)attr.clone();
            ++i;
        }
        return attributes;
    }

    public MBeanOperationInfo[] getOperations() {
        MBeanOperationInfo[] opers = this.modelMBeanOperations;
        if (opers == null) {
            return null;
        }
        MBeanOperationInfo[] operations = new ModelMBeanOperationInfo[opers.length];
        int i = 0;
        while (i < opers.length) {
            ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
            operations[i] = (ModelMBeanOperationInfo)oper.clone();
            ++i;
        }
        return operations;
    }

    public MBeanNotificationInfo[] getNotifications() {
        MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
        if (notifs == null) {
            return null;
        }
        MBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[notifs.length];
        int i = 0;
        while (i < notifs.length) {
            ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
            notifications[i] = (ModelMBeanNotificationInfo)notif.clone();
            ++i;
        }
        return notifications;
    }

    public Object clone() {
        ModelMBeanInfoSupport info = (ModelMBeanInfoSupport)super.clone();
        info.modelMBeanDescriptor = (Descriptor)this.modelMBeanDescriptor.clone();
        return info;
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        this.modelMBeanDescriptor = descriptor == null || !this.isDescriptorValid(descriptor) ? this.createDefaultMBeanDescriptor() : (Descriptor)descriptor.clone();
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        List<String> names = Arrays.asList(descriptor.getFieldNames());
        if (!names.contains("name") || !names.contains("descriptortype")) {
            return false;
        }
        return "MBean".equals(descriptor.getFieldValue("descriptortype"));
    }

    private Descriptor createDefaultMBeanDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "displayName", "persistPolicy", "log", "export", "visibility"};
        int index = this.getClassName().lastIndexOf(46) + 1;
        Object[] values = new Object[]{this.getClassName().substring(index), "MBean", this.getClassName(), "Never", "false", null, "1"};
        return new DescriptorSupport(names, values);
    }
}

