/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public Label breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public int caseCount = 0;
    public int blockStart;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo caseInits;
        SwitchFlowContext switchContext;
        block11: {
            try {
                flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
                this.breakLabel = new Label();
                switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel);
                caseInits = FlowInfo.DEAD_END;
                this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
                int caseIndex = 0;
                if (this.statements != null) {
                    boolean didAlreadyComplain = false;
                    int max = this.statements.length;
                    for (int i = 0; i < max; ++i) {
                        Statement statement = this.statements[i];
                        if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                            this.scope.switchCase = this.cases[caseIndex];
                            ++caseIndex;
                            caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                            didAlreadyComplain = false;
                        } else if (statement == this.defaultCase) {
                            this.scope.switchCase = this.defaultCase;
                            caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                            didAlreadyComplain = false;
                        }
                        if (!statement.complainIfUnreachable(caseInits, this.scope, didAlreadyComplain)) {
                            caseInits = statement.analyseCode(this.scope, switchContext, caseInits);
                            continue;
                        }
                        didAlreadyComplain = true;
                    }
                }
                if (this.defaultCase != null) break block11;
                flowInfo.addPotentialInitializationsFrom(((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak));
                this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo didAlreadyComplain = flowInfo;
                Object var12_14 = null;
                if (this.scope != null) {
                    this.scope.switchCase = null;
                }
                return didAlreadyComplain;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var12_16 = null;
                    if (this.scope == null) break block12;
                    this.scope.switchCase = null;
                }
                throw throwable;
            }
        }
        UnconditionalFlowInfo mergedInfo = ((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        UnconditionalFlowInfo unconditionalFlowInfo = mergedInfo;
        Object var12_15 = null;
        if (this.scope != null) {
            this.scope.switchCase = null;
        }
        return unconditionalFlowInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        try {
            int i;
            int[] sortedIndexes = new int[this.caseCount];
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                Object var15_4 = null;
                if (this.scope != null) {
                    this.scope.switchCase = null;
                }
                return;
            }
            int pc = codeStream.position;
            this.breakLabel.initialize(codeStream);
            CaseLabel[] caseLabels = new CaseLabel[this.caseCount];
            int[] constants = new int[this.caseCount];
            boolean needSwitch = this.caseCount != 0;
            for (i = 0; i < this.caseCount; ++i) {
                constants[i] = this.cases[i].constantExpression.constant.intValue();
                this.cases[i].targetLabel = caseLabels[i] = new CaseLabel(codeStream);
            }
            for (i = 0; i < this.caseCount; ++i) {
                sortedIndexes[i] = i;
            }
            int[] localKeysCopy = new int[this.caseCount];
            System.arraycopy(constants, 0, localKeysCopy, 0, this.caseCount);
            CodeStream.sort(localKeysCopy, 0, this.caseCount - 1, sortedIndexes);
            CaseLabel defaultLabel = new CaseLabel(codeStream);
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = defaultLabel;
            }
            this.expression.generateCode(currentScope, codeStream, needSwitch);
            if (needSwitch) {
                int max = localKeysCopy[this.caseCount - 1];
                int min = localKeysCopy[0];
                if ((long)((double)this.caseCount * 2.5) > (long)max - (long)min) {
                    if (max > 0x7FFF0000 && currentScope.environment().options.complianceLevel < 0x300000L) {
                        codeStream.lookupswitch(defaultLabel, constants, sortedIndexes, caseLabels);
                    } else {
                        codeStream.tableswitch(defaultLabel, min, max, constants, sortedIndexes, caseLabels);
                    }
                } else {
                    codeStream.lookupswitch(defaultLabel, constants, sortedIndexes, caseLabels);
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
            }
            int caseIndex = 0;
            if (this.statements != null) {
                int maxCases = this.statements.length;
                for (int i2 = 0; i2 < maxCases; ++i2) {
                    Statement statement = this.statements[i2];
                    if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                        this.scope.switchCase = this.cases[caseIndex];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                        ++caseIndex;
                    } else if (statement == this.defaultCase) {
                        this.scope.switchCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                    }
                    statement.generateCode(this.scope, codeStream);
                }
            }
            this.breakLabel.place();
            if (this.defaultCase == null) {
                defaultLabel.place();
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            if (this.scope != currentScope) {
                codeStream.exitUserScope(this.scope);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        catch (Throwable throwable) {
            Object var15_6 = null;
            if (this.scope != null) {
                this.scope.switchCase = null;
            }
            throw throwable;
        }
        Object var15_5 = null;
        if (this.scope != null) {
            this.scope.switchCase = null;
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        SwitchStatement.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                output.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(indent, output);
                    continue;
                }
                this.statements[i].printStatement(indent + 2, output);
            }
        }
        output.append("\n");
        return SwitchStatement.printIndent(indent, output).append('}');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(BlockScope upperScope) {
        try {
            TypeBinding testType = this.expression.resolveType(upperScope);
            if (testType == null) {
                Object var17_3 = null;
                if (this.scope == null) return;
                this.scope.switchCase = null;
                return;
            }
            this.expression.implicitWidening(testType, testType);
            if (this.expression.isConstantValueOfTypeAssignableToType(testType, BaseTypes.IntBinding) || testType.isCompatibleWith(BaseTypes.IntBinding)) {
                if (this.statements != null) {
                    this.scope = this.explicitDeclarations == 0 ? upperScope : new BlockScope(upperScope);
                    int length = this.statements.length;
                    this.cases = new CaseStatement[length];
                    int[] casesValues = new int[length];
                    CaseStatement[] duplicateCaseStatements = null;
                    int duplicateCaseStatementsCounter = 0;
                    int counter = 0;
                    for (int i = 0; i < length; ++i) {
                        Statement statement = this.statements[i];
                        Constant constant = statement.resolveCase(this.scope, testType, this);
                        if (constant == null || constant == NotAConstant) continue;
                        int key = constant.intValue();
                        for (int j = 0; j < counter; ++j) {
                            if (casesValues[j] != key) continue;
                            CaseStatement currentCaseStatement = (CaseStatement)statement;
                            if (duplicateCaseStatements == null) {
                                this.scope.problemReporter().duplicateCase(this.cases[j]);
                                this.scope.problemReporter().duplicateCase(currentCaseStatement);
                                duplicateCaseStatements = new CaseStatement[length];
                                duplicateCaseStatements[duplicateCaseStatementsCounter++] = this.cases[j];
                                duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                                continue;
                            }
                            boolean found = false;
                            for (int k = 2; k < duplicateCaseStatementsCounter; ++k) {
                                if (duplicateCaseStatements[k] != statement) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            this.scope.problemReporter().duplicateCase(currentCaseStatement);
                            duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                        }
                        casesValues[counter++] = key;
                    }
                } else if ((this.bits & 8) != 0) {
                    upperScope.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
                }
                Object var17_5 = null;
                if (this.scope == null) return;
                this.scope.switchCase = null;
                return;
            }
            upperScope.problemReporter().incorrectSwitchType(this.expression, testType);
        }
        catch (Throwable throwable) {
            Object var17_6 = null;
            if (this.scope == null) throw throwable;
            this.scope.switchCase = null;
            throw throwable;
        }
        Object var17_4 = null;
        if (this.scope == null) return;
        this.scope.switchCase = null;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, this.scope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                for (int i = 0; i < statementsLength; ++i) {
                    this.statements[i].traverse(visitor, this.scope);
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label) {
        if (this.breakLabel.hasForwardReferences()) {
            label.appendForwardReferencesFrom(this.breakLabel);
        }
    }
}

