/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleURLConnection;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleContext;

public abstract class BundleResourceHandler
extends URLStreamHandler {
    public static final String SECURITY_AUTHORIZED = "SECURITY_AUTHORIZED";
    protected static BundleContext context;
    protected BundleEntry bundleEntry;
    protected AdminPermission adminPermission;

    public BundleResourceHandler() {
    }

    public BundleResourceHandler(BundleEntry bundleEntry) {
        this.bundleEntry = bundleEntry;
    }

    protected void parseURL(URL url, String str, int start, int end) {
        int dotIndex;
        this.checkAdminPermission();
        if (end < start) {
            return;
        }
        if (url.getPath() != null) {
            this.bundleEntry = null;
        }
        String spec = "";
        if (start < end) {
            spec = str.substring(start, end);
        }
        end -= start;
        String path = url.getPath();
        String bundleId = url.getHost();
        int pathIdx = 0;
        if (spec.startsWith("//")) {
            int bundleIdIdx = 2;
            pathIdx = spec.indexOf(47, bundleIdIdx);
            if (pathIdx == -1) {
                pathIdx = end;
                path = "";
            }
            bundleId = spec.substring(bundleIdIdx, pathIdx);
        }
        if (pathIdx < end && spec.charAt(pathIdx) == '/') {
            path = spec.substring(pathIdx, end);
        } else if (end > pathIdx) {
            int last;
            if (path == null || path.equals("")) {
                path = "/";
            }
            path = (last = path.lastIndexOf(47) + 1) == 0 ? spec.substring(pathIdx, end) : path.substring(0, last) + spec.substring(pathIdx, end);
        }
        if (path == null) {
            path = "";
        }
        while ((dotIndex = path.indexOf("/./")) >= 0) {
            path = path.substring(0, dotIndex + 1) + path.substring(dotIndex + 3);
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        while ((dotIndex = path.indexOf("/../")) >= 0) {
            if (dotIndex != 0) {
                path = path.substring(0, path.lastIndexOf(47, dotIndex - 1)) + path.substring(dotIndex + 3);
                continue;
            }
            path = path.substring(dotIndex + 3);
        }
        if (path.endsWith("/..") && path.length() > 3) {
            path = path.substring(0, path.length() - 2);
        }
        this.setURL(url, url.getProtocol(), bundleId, 0, SECURITY_AUTHORIZED, null, path, null, null);
    }

    protected URLConnection openConnection(URL url) throws IOException {
        String authority = url.getAuthority();
        if (!url.getAuthority().equals(SECURITY_AUTHORIZED)) {
            this.checkAdminPermission();
        }
        if (this.bundleEntry != null) {
            return new BundleURLConnection(url, this.bundleEntry);
        }
        String bidString = url.getHost();
        if (bidString == null) {
            throw new IOException(AdaptorMsg.formatter.getString("URL_NO_BUNDLE_ID", (Object)url.toExternalForm()));
        }
        AbstractBundle bundle = null;
        try {
            Long bundleID = new Long(bidString);
            bundle = (AbstractBundle)context.getBundle(bundleID.longValue());
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException(AdaptorMsg.formatter.getString("URL_INVALID_BUNDLE_ID", (Object)bidString));
        }
        if (bundle == null) {
            throw new IOException(AdaptorMsg.formatter.getString("URL_NO_BUNDLE_FOUND", (Object)url.toExternalForm()));
        }
        return new BundleURLConnection(url, this.findBundleEntry(url, bundle));
    }

    protected abstract BundleEntry findBundleEntry(URL var1, AbstractBundle var2) throws IOException;

    protected String toExternalForm(URL url) {
        String path;
        StringBuffer result = new StringBuffer(url.getProtocol());
        result.append("://");
        String bundleId = url.getHost();
        if (bundleId != null && bundleId.length() > 0) {
            result.append(bundleId);
        }
        if ((path = url.getPath()) != null) {
            if (path.length() > 0 && path.charAt(0) != '/') {
                result.append("/");
            }
            result.append(path);
        }
        return result.toString();
    }

    public static void setContext(BundleContext context) {
        BundleResourceHandler.context = context;
    }

    protected int hashCode(URL url) {
        String path;
        String host;
        int hash = 0;
        String protocol = url.getProtocol();
        if (protocol != null) {
            hash += protocol.hashCode();
        }
        if ((host = url.getHost()) != null) {
            hash += host.hashCode();
        }
        if ((path = url.getPath()) != null) {
            hash += path.hashCode();
        }
        return hash;
    }

    protected boolean equals(URL url1, URL url2) {
        return this.sameFile(url1, url2);
    }

    protected synchronized InetAddress getHostAddress(URL url) {
        return null;
    }

    protected boolean hostsEqual(URL url1, URL url2) {
        String host1 = url1.getHost();
        String host2 = url2.getHost();
        if (host1 != null && host2 != null) {
            return host1.equalsIgnoreCase(host2);
        }
        return host1 == null && host2 == null;
    }

    protected boolean sameFile(URL url1, URL url2) {
        String path2;
        String a2;
        String p2;
        String p1 = url1.getProtocol();
        if (!(p1 == (p2 = url2.getProtocol()) || p1 != null && p1.equalsIgnoreCase(p2))) {
            return false;
        }
        if (!this.hostsEqual(url1, url2)) {
            return false;
        }
        String a1 = url1.getAuthority();
        if (!(a1 == (a2 = url2.getAuthority()) || a1 != null && a1.equals(a2))) {
            return false;
        }
        String path1 = url1.getPath();
        return path1 == (path2 = url2.getPath()) || path1 != null && path1.equals(path2);
    }

    protected void checkAdminPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.adminPermission == null) {
                this.adminPermission = new AdminPermission();
            }
            sm.checkPermission((Permission)this.adminPermission);
        }
    }
}

