/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.ui.antsupport.AntSupportMessages;
import org.eclipse.ant.internal.ui.antsupport.logger.NullBuildLogger;
import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamMonitor;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamsProxy;
import org.eclipse.ant.internal.ui.launchConfigurations.TaskLinkManager;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class AntProcessBuildLogger
extends NullBuildLogger {
    private File fBuildFileParent = null;
    private long fStartTime;
    private AntProcess fProcess = null;

    protected void logMessage(String message, BuildEvent event, int overridePriority) {
        int priority = overridePriority;
        if (priority == -1) {
            priority = event.getPriority();
        }
        if (priority > this.getMessageOutputLevel()) {
            return;
        }
        AntProcess antProcess = this.getAntProcess(event.getProject().getUserProperty("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID"));
        if (antProcess == null) {
            return;
        }
        StringBuffer fullMessage = new StringBuffer(System.getProperty("line.separator"));
        if (event.getException() == null && event.getTask() != null && !this.fEmacsMode) {
            this.adornMessage(event, fullMessage);
        } else {
            fullMessage.append(message);
        }
        message = fullMessage.toString();
        AntStreamMonitor monitor = this.getMonitor(priority);
        monitor.append(message);
        this.logMessageToLogFile(message, priority);
    }

    private void adornMessage(BuildEvent event, StringBuffer fullMessage) {
        block6: {
            String name = event.getTask().getTaskName();
            if (name == null) {
                name = "null";
            }
            Location location = event.getTask().getLocation();
            StringBuffer column = new StringBuffer();
            int size = 15 - (name.length() + 3);
            for (int i = 0; i < size; ++i) {
                column.append(' ');
            }
            StringBuffer labelBuff = new StringBuffer();
            labelBuff.append('[');
            labelBuff.append(name);
            labelBuff.append("] ");
            int offset = Math.max(size, 0) + 1;
            String label = labelBuff.toString();
            if (event.getMessage() == null) {
                return;
            }
            try {
                BufferedReader r = new BufferedReader(new StringReader(event.getMessage()));
                String line = r.readLine();
                fullMessage.append(column);
                this.appendAndLink(fullMessage, location, label, offset, line);
                line = r.readLine();
                while (line != null) {
                    fullMessage.append(System.getProperty("line.separator"));
                    fullMessage.append(column);
                    this.appendAndLink(fullMessage, location, label, offset, line);
                    line = r.readLine();
                }
            }
            catch (IOException e) {
                if (event.getMessage() == null) break block6;
                fullMessage.append(label).append(event.getMessage());
            }
        }
    }

    private void appendAndLink(StringBuffer fullMessage, Location location, String label, int offset, String line) {
        fullMessage.append(label);
        fullMessage.append(line);
        if (location != null) {
            String newLine = (label + line).trim();
            Region region = new Region(offset, label.length() - 3);
            IConsoleHyperlink link = this.getTaskLink(location);
            if (link != null) {
                TaskLinkManager.addTaskHyperlink((IProcess)this.getAntProcess(null), (IConsoleHyperlink)link, (IRegion)region, (String)newLine);
            }
        }
    }

    private AntStreamMonitor getMonitor(int priority) {
        AntStreamsProxy proxy = (AntStreamsProxy)this.fProcess.getStreamsProxy();
        AntStreamMonitor monitor = null;
        switch (priority) {
            case 2: {
                monitor = (AntStreamMonitor)proxy.getOutputStreamMonitor();
                break;
            }
            case 0: {
                monitor = (AntStreamMonitor)proxy.getErrorStreamMonitor();
                break;
            }
            case 4: {
                monitor = (AntStreamMonitor)proxy.getDebugStreamMonitor();
                break;
            }
            case 1: {
                monitor = (AntStreamMonitor)proxy.getWarningStreamMonitor();
                break;
            }
            case 3: {
                monitor = (AntStreamMonitor)proxy.getVerboseStreamMonitor();
            }
        }
        return monitor;
    }

    private void logMessageToLogFile(String message, int priority) {
        if (priority == 0) {
            if (this.getErrorPrintStream() != null && this.getErrorPrintStream() != System.err) {
                this.getErrorPrintStream().println(message);
            }
        } else if (this.getOutputPrintStream() != null && this.getOutputPrintStream() != System.out) {
            this.getOutputPrintStream().println(message);
        }
    }

    private IConsoleHyperlink getTaskLink(Location location) {
        if (location != null) {
            return AntUtil.getTaskLink((String)location.toString(), (File)this.fBuildFileParent);
        }
        return null;
    }

    private AntProcess getAntProcess(String processId) {
        if (this.fProcess == null && processId != null) {
            IProcess[] all = DebugPlugin.getDefault().getLaunchManager().getProcesses();
            for (int i = 0; i < all.length; ++i) {
                IProcess process = all[i];
                if (!(process instanceof AntProcess) || !processId.equals(process.getAttribute("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID"))) continue;
                this.fProcess = (AntProcess)process;
                break;
            }
        }
        return this.fProcess;
    }

    public void buildStarted(BuildEvent event) {
        this.fStartTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent event) {
        this.handleException(event);
        this.fHandledException = null;
        this.fBuildFileParent = null;
        this.logMessage(this.getTimeString(System.currentTimeMillis() - this.fStartTime), event, this.fMessageOutputLevel);
        this.fProcess = null;
        event.getProject().removeBuildListener((BuildListener)this);
    }

    private String getTimeString(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        StringBuffer result = new StringBuffer(AntSupportMessages.getString("AntProcessBuildLogger.Total_time"));
        if (minutes > 0L) {
            result.append(minutes);
            if (minutes > 1L) {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._minutes_2"));
            } else {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._minute_3"));
            }
        }
        if (seconds > 0L) {
            if (minutes > 0L) {
                result.append(' ');
            }
            result.append(seconds);
            if (seconds > 1L) {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._seconds_4"));
            } else {
                result.append(AntSupportMessages.getString("AntProcessBuildLogger._second_5"));
            }
        }
        if (seconds == 0L && minutes == 0L) {
            result.append(milliseconds);
            result.append(AntSupportMessages.getString("AntProcessBuildLogger._milliseconds_6"));
        }
        result.append(System.getProperty("line.separator"));
        return result.toString();
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() > this.getMessageOutputLevel()) {
            return;
        }
        if (event.getMessage() != null && event.getMessage().length() > 0) {
            this.logMessage(event.getMessage(), event, -1);
        }
    }

    protected void handleException(BuildEvent event) {
        Throwable exception = event.getException();
        if (exception == null || exception == this.fHandledException || exception instanceof OperationCanceledException || exception instanceof AntSecurityException) {
            return;
        }
        this.fHandledException = exception;
        this.logMessage(MessageFormat.format(AntSupportMessages.getString("AntProcessBuildLogger.BUILD_FAILED__{0}_1"), exception.toString()), event, 0);
    }

    public void targetStarted(BuildEvent event) {
        if (2 > this.getMessageOutputLevel()) {
            return;
        }
        StringBuffer msg = new StringBuffer(System.getProperty("line.separator"));
        msg.append(event.getTarget().getName());
        msg.append(':');
        this.logMessage(msg.toString(), event, 2);
    }
}

